/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.coyote.AbstractProcessorLight;
import org.apache.coyote.ActionCode;
import org.apache.coyote.ActionHook;
import org.apache.coyote.Adapter;
import org.apache.coyote.AsyncContextCallback;
import org.apache.coyote.AsyncStateMachine;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.ContinueResponseTiming;
import org.apache.coyote.ErrorState;
import org.apache.coyote.Request;
import org.apache.coyote.RequestInfo;
import org.apache.coyote.Response;
import org.apache.coyote.UpgradeToken;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.parser.Host;
import org.apache.tomcat.util.log.UserDataHelper;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.DispatchType;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractProcessor
extends AbstractProcessorLight
implements ActionHook {
    private static final StringManager sm = StringManager.getManager(AbstractProcessor.class);
    protected char[] hostNameC = new char[0];
    protected Adapter adapter;
    protected final AsyncStateMachine asyncStateMachine;
    private volatile long asyncTimeout = -1L;
    private volatile long asyncTimeoutGeneration = 0L;
    protected final AbstractEndpoint<?> endpoint;
    protected final Request request;
    protected final Response response;
    protected volatile SocketWrapperBase<?> socketWrapper = null;
    protected volatile SSLSupport sslSupport;
    private ErrorState errorState = ErrorState.NONE;
    protected final UserDataHelper userDataHelper;

    public AbstractProcessor(AbstractEndpoint<?> abstractEndpoint) {
        this(abstractEndpoint, new Request(), new Response());
    }

    protected AbstractProcessor(AbstractEndpoint<?> abstractEndpoint, Request request, Response response) {
        this.endpoint = abstractEndpoint;
        this.asyncStateMachine = new AsyncStateMachine(this);
        this.request = request;
        this.response = response;
        this.response.setHook(this);
        this.request.setResponse(this.response);
        this.request.setHook(this);
        this.userDataHelper = new UserDataHelper(this.getLog());
    }

    protected void setErrorState(ErrorState errorState, Throwable throwable) {
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)sm.getString("abstractProcessor.setErrorState", new Object[]{errorState}), throwable);
        }
        boolean bl = this.response.setError();
        boolean bl2 = this.errorState.isIoAllowed() && !errorState.isIoAllowed();
        this.errorState = this.errorState.getMostSevere(errorState);
        if (this.response.getStatus() < 400 && !(throwable instanceof IOException)) {
            this.response.setStatus(500);
        }
        if (throwable != null) {
            this.request.setAttribute("javax.servlet.error.exception", throwable);
        }
        if (bl2 && this.isAsync() && bl && this.asyncStateMachine.asyncError()) {
            this.processSocketEvent(SocketEvent.ERROR, true);
        }
    }

    protected ErrorState getErrorState() {
        return this.errorState;
    }

    @Override
    public Request getRequest() {
        return this.request;
    }

    public void setAdapter(Adapter adapter) {
        this.adapter = adapter;
    }

    public Adapter getAdapter() {
        return this.adapter;
    }

    protected void setSocketWrapper(SocketWrapperBase<?> socketWrapperBase) {
        this.socketWrapper = socketWrapperBase;
    }

    protected final SocketWrapperBase<?> getSocketWrapper() {
        return this.socketWrapper;
    }

    @Override
    public final void setSslSupport(SSLSupport sSLSupport) {
        this.sslSupport = sSLSupport;
    }

    protected Executor getExecutor() {
        return this.endpoint.getExecutor();
    }

    @Override
    public boolean isAsync() {
        return this.asyncStateMachine.isAsync();
    }

    @Override
    public AbstractEndpoint.Handler.SocketState asyncPostProcess() {
        return this.asyncStateMachine.asyncPostProcess();
    }

    @Override
    public final AbstractEndpoint.Handler.SocketState dispatch(SocketEvent socketEvent) throws IOException {
        AbstractEndpoint.Handler.SocketState socketState;
        if (socketEvent == SocketEvent.OPEN_WRITE && this.response.getWriteListener() != null) {
            this.asyncStateMachine.asyncOperation();
            try {
                if (this.flushBufferedWrite()) {
                    return AbstractEndpoint.Handler.SocketState.LONG;
                }
            }
            catch (IOException iOException) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((Object)"Unable to write async data.", (Throwable)iOException);
                }
                socketEvent = SocketEvent.ERROR;
                this.request.setAttribute("javax.servlet.error.exception", iOException);
            }
        } else if (socketEvent == SocketEvent.OPEN_READ && this.request.getReadListener() != null) {
            this.dispatchNonBlockingRead();
        } else if (socketEvent == SocketEvent.ERROR) {
            if (this.request.getAttribute("javax.servlet.error.exception") == null) {
                this.request.setAttribute("javax.servlet.error.exception", this.socketWrapper.getError());
            }
            if (this.request.getReadListener() != null || this.response.getWriteListener() != null) {
                this.asyncStateMachine.asyncOperation();
            }
        }
        RequestInfo requestInfo = this.request.getRequestProcessor();
        try {
            requestInfo.setStage(3);
            if (!this.getAdapter().asyncDispatch(this.request, this.response, socketEvent)) {
                this.setErrorState(ErrorState.CLOSE_NOW, null);
            }
        }
        catch (InterruptedIOException interruptedIOException) {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, interruptedIOException);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
            this.setErrorState(ErrorState.CLOSE_NOW, throwable);
            this.getLog().error((Object)sm.getString("http11processor.request.process"), throwable);
        }
        requestInfo.setStage(7);
        if (this.getErrorState().isError()) {
            this.request.updateCounters();
            socketState = AbstractEndpoint.Handler.SocketState.CLOSED;
        } else if (this.isAsync()) {
            socketState = AbstractEndpoint.Handler.SocketState.LONG;
        } else {
            this.request.updateCounters();
            socketState = this.dispatchEndRequest();
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((Object)("Socket: [" + this.socketWrapper + "], Status in: [" + (Object)((Object)socketEvent) + "], State out: [" + (Object)((Object)socketState) + "]"));
        }
        return socketState;
    }

    protected void parseHost(MessageBytes messageBytes) {
        if (messageBytes == null || messageBytes.isNull()) {
            this.populateHost();
            this.populatePort();
            return;
        }
        if (messageBytes.getLength() == 0) {
            this.request.serverName().setString("");
            this.populatePort();
            return;
        }
        ByteChunk byteChunk = messageBytes.getByteChunk();
        byte[] byArray = byteChunk.getBytes();
        int n = byteChunk.getLength();
        int n2 = byteChunk.getStart();
        if (this.hostNameC.length < n) {
            this.hostNameC = new char[n];
        }
        try {
            int n3;
            int n4 = Host.parse(messageBytes);
            if (n4 != -1) {
                n3 = 0;
                for (int i = n4 + 1; i < n; ++i) {
                    char c = (char)byArray[i + n2];
                    if (c < '0' || c > '9') {
                        this.response.setStatus(400);
                        this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                        return;
                    }
                    n3 = n3 * 10 + c - 48;
                }
                this.request.setServerPort(n3);
                n = n4;
            }
            for (n3 = 0; n3 < n; ++n3) {
                this.hostNameC[n3] = (char)byArray[n3 + n2];
            }
            this.request.serverName().setChars(this.hostNameC, 0, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            UserDataHelper.Mode mode = this.userDataHelper.getNextMode();
            if (mode != null) {
                String string = sm.getString("abstractProcessor.hostInvalid", new Object[]{messageBytes.toString()});
                switch (mode) {
                    case INFO_THEN_DEBUG: {
                        string = string + sm.getString("abstractProcessor.fallToDebug");
                    }
                    case INFO: {
                        this.getLog().info((Object)string, (Throwable)illegalArgumentException);
                        break;
                    }
                    case DEBUG: {
                        this.getLog().debug((Object)string, (Throwable)illegalArgumentException);
                    }
                }
            }
            this.response.setStatus(400);
            this.setErrorState(ErrorState.CLOSE_CLEAN, illegalArgumentException);
        }
    }

    protected void populateHost() {
    }

    protected void populatePort() {
    }

    @Override
    public final void action(ActionCode actionCode, Object object) {
        switch (actionCode) {
            case COMMIT: {
                if (this.response.isCommitted()) break;
                try {
                    this.prepareResponse();
                }
                catch (IOException iOException) {
                    this.handleIOException(iOException);
                }
                break;
            }
            case CLOSE: {
                this.action(ActionCode.COMMIT, null);
                try {
                    this.finishResponse();
                }
                catch (IOException iOException) {
                    this.handleIOException(iOException);
                }
                break;
            }
            case ACK: {
                this.ack((ContinueResponseTiming)((Object)object));
                break;
            }
            case CLIENT_FLUSH: {
                this.action(ActionCode.COMMIT, null);
                try {
                    this.flush();
                }
                catch (IOException iOException) {
                    this.handleIOException(iOException);
                    this.response.setErrorException(iOException);
                }
                break;
            }
            case AVAILABLE: {
                this.request.setAvailable(this.available(Boolean.TRUE.equals(object)));
                break;
            }
            case REQ_SET_BODY_REPLAY: {
                ByteChunk byteChunk = (ByteChunk)object;
                this.setRequestBody(byteChunk);
                break;
            }
            case IS_ERROR: {
                ((AtomicBoolean)object).set(this.getErrorState().isError());
                break;
            }
            case IS_IO_ALLOWED: {
                ((AtomicBoolean)object).set(this.getErrorState().isIoAllowed());
                break;
            }
            case CLOSE_NOW: {
                this.setSwallowResponse();
                if (object instanceof Throwable) {
                    this.setErrorState(ErrorState.CLOSE_NOW, (Throwable)object);
                    break;
                }
                this.setErrorState(ErrorState.CLOSE_NOW, null);
                break;
            }
            case DISABLE_SWALLOW_INPUT: {
                this.disableSwallowRequest();
                this.setErrorState(ErrorState.CLOSE_CLEAN, null);
                break;
            }
            case REQ_HOST_ADDR_ATTRIBUTE: {
                if (!this.getPopulateRequestAttributesFromSocket() || this.socketWrapper == null) break;
                this.request.remoteAddr().setString(this.socketWrapper.getRemoteAddr());
                break;
            }
            case REQ_HOST_ATTRIBUTE: {
                this.populateRequestAttributeRemoteHost();
                break;
            }
            case REQ_LOCALPORT_ATTRIBUTE: {
                if (!this.getPopulateRequestAttributesFromSocket() || this.socketWrapper == null) break;
                this.request.setLocalPort(this.socketWrapper.getLocalPort());
                break;
            }
            case REQ_LOCAL_ADDR_ATTRIBUTE: {
                if (!this.getPopulateRequestAttributesFromSocket() || this.socketWrapper == null) break;
                this.request.localAddr().setString(this.socketWrapper.getLocalAddr());
                break;
            }
            case REQ_LOCAL_NAME_ATTRIBUTE: {
                if (!this.getPopulateRequestAttributesFromSocket() || this.socketWrapper == null) break;
                this.request.localName().setString(this.socketWrapper.getLocalName());
                break;
            }
            case REQ_REMOTEPORT_ATTRIBUTE: {
                if (!this.getPopulateRequestAttributesFromSocket() || this.socketWrapper == null) break;
                this.request.setRemotePort(this.socketWrapper.getRemotePort());
                break;
            }
            case REQ_SSL_ATTRIBUTE: {
                this.populateSslRequestAttributes();
                break;
            }
            case REQ_SSL_CERTIFICATE: {
                try {
                    this.sslReHandShake();
                }
                catch (IOException iOException) {
                    this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
                }
                break;
            }
            case ASYNC_START: {
                this.asyncStateMachine.asyncStart((AsyncContextCallback)object);
                break;
            }
            case ASYNC_COMPLETE: {
                this.clearDispatches();
                if (!this.asyncStateMachine.asyncComplete()) break;
                this.processSocketEvent(SocketEvent.OPEN_READ, true);
                break;
            }
            case ASYNC_DISPATCH: {
                if (!this.asyncStateMachine.asyncDispatch()) break;
                this.processSocketEvent(SocketEvent.OPEN_READ, true);
                break;
            }
            case ASYNC_DISPATCHED: {
                this.asyncStateMachine.asyncDispatched();
                break;
            }
            case ASYNC_ERROR: {
                this.asyncStateMachine.asyncError();
                break;
            }
            case ASYNC_IS_ASYNC: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsync());
                break;
            }
            case ASYNC_IS_COMPLETING: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isCompleting());
                break;
            }
            case ASYNC_IS_DISPATCHING: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncDispatching());
                break;
            }
            case ASYNC_IS_ERROR: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncError());
                break;
            }
            case ASYNC_IS_STARTED: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncStarted());
                break;
            }
            case ASYNC_IS_TIMINGOUT: {
                ((AtomicBoolean)object).set(this.asyncStateMachine.isAsyncTimingOut());
                break;
            }
            case ASYNC_RUN: {
                this.asyncStateMachine.asyncRun((Runnable)object);
                break;
            }
            case ASYNC_SETTIMEOUT: {
                if (object == null) {
                    return;
                }
                long l = (Long)object;
                this.setAsyncTimeout(l);
                break;
            }
            case ASYNC_TIMEOUT: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.asyncStateMachine.asyncTimeout());
                break;
            }
            case ASYNC_POST_PROCESS: {
                this.asyncStateMachine.asyncPostProcess();
                break;
            }
            case REQUEST_BODY_FULLY_READ: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.isRequestBodyFullyRead());
                break;
            }
            case NB_READ_INTEREST: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.isReadyForRead());
                break;
            }
            case NB_WRITE_INTEREST: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.isReadyForWrite());
                break;
            }
            case DISPATCH_READ: {
                this.addDispatch(DispatchType.NON_BLOCKING_READ);
                break;
            }
            case DISPATCH_WRITE: {
                this.addDispatch(DispatchType.NON_BLOCKING_WRITE);
                break;
            }
            case DISPATCH_EXECUTE: {
                this.executeDispatches();
                break;
            }
            case UPGRADE: {
                this.doHttpUpgrade((UpgradeToken)object);
                break;
            }
            case IS_PUSH_SUPPORTED: {
                AtomicBoolean atomicBoolean = (AtomicBoolean)object;
                atomicBoolean.set(this.isPushSupported());
                break;
            }
            case PUSH_REQUEST: {
                this.doPush((Request)object);
                break;
            }
            case CONNECTION_ID: {
                AtomicReference atomicReference = (AtomicReference)object;
                atomicReference.set(this.getConnectionID());
                break;
            }
            case STREAM_ID: {
                AtomicReference atomicReference = (AtomicReference)object;
                atomicReference.set(this.getStreamID());
                break;
            }
        }
    }

    private void handleIOException(IOException iOException) {
        if (iOException instanceof CloseNowException) {
            this.setErrorState(ErrorState.CLOSE_NOW, iOException);
        } else {
            this.setErrorState(ErrorState.CLOSE_CONNECTION_NOW, iOException);
        }
    }

    protected void dispatchNonBlockingRead() {
        this.asyncStateMachine.asyncOperation();
    }

    @Override
    public void timeoutAsync(long l) {
        if (l < 0L) {
            this.doTimeoutAsync();
        } else {
            long l2 = this.getAsyncTimeout();
            if (l2 > 0L) {
                long l3 = this.asyncStateMachine.getLastAsyncStart();
                if (l - l3 > l2) {
                    this.doTimeoutAsync();
                }
            } else if (!this.asyncStateMachine.isAvailable()) {
                this.doTimeoutAsync();
            }
        }
    }

    private void doTimeoutAsync() {
        this.setAsyncTimeout(-1L);
        this.asyncTimeoutGeneration = this.asyncStateMachine.getCurrentGeneration();
        this.processSocketEvent(SocketEvent.TIMEOUT, true);
    }

    @Override
    public boolean checkAsyncTimeoutGeneration() {
        return this.asyncTimeoutGeneration == this.asyncStateMachine.getCurrentGeneration();
    }

    public void setAsyncTimeout(long l) {
        this.asyncTimeout = l;
    }

    public long getAsyncTimeout() {
        return this.asyncTimeout;
    }

    @Override
    public void recycle() {
        this.errorState = ErrorState.NONE;
        this.asyncStateMachine.recycle();
    }

    protected abstract void prepareResponse() throws IOException;

    protected abstract void finishResponse() throws IOException;

    @Deprecated
    protected void ack() {
        this.ack(ContinueResponseTiming.ALWAYS);
    }

    protected abstract void ack(ContinueResponseTiming var1);

    protected abstract void flush() throws IOException;

    protected abstract int available(boolean var1);

    protected abstract void setRequestBody(ByteChunk var1);

    protected abstract void setSwallowResponse();

    protected abstract void disableSwallowRequest();

    protected boolean getPopulateRequestAttributesFromSocket() {
        return true;
    }

    protected void populateRequestAttributeRemoteHost() {
        if (this.getPopulateRequestAttributesFromSocket() && this.socketWrapper != null) {
            this.request.remoteHost().setString(this.socketWrapper.getRemoteHost());
        }
    }

    protected void populateSslRequestAttributes() {
        try {
            if (this.sslSupport != null) {
                Object object = this.sslSupport.getCipherSuite();
                if (object != null) {
                    this.request.setAttribute("javax.servlet.request.cipher_suite", object);
                }
                if ((object = this.sslSupport.getPeerCertificateChain()) != null) {
                    this.request.setAttribute("javax.servlet.request.X509Certificate", object);
                }
                if ((object = this.sslSupport.getKeySize()) != null) {
                    this.request.setAttribute("javax.servlet.request.key_size", object);
                }
                if ((object = this.sslSupport.getSessionId()) != null) {
                    this.request.setAttribute("javax.servlet.request.ssl_session_id", object);
                }
                if ((object = this.sslSupport.getProtocol()) != null) {
                    this.request.setAttribute("org.apache.tomcat.util.net.secure_protocol_version", object);
                }
                this.request.setAttribute("javax.servlet.request.ssl_session_mgr", this.sslSupport);
            }
        }
        catch (Exception exception) {
            this.getLog().warn((Object)sm.getString("abstractProcessor.socket.ssl"), (Throwable)exception);
        }
    }

    protected void sslReHandShake() throws IOException {
    }

    protected void processSocketEvent(SocketEvent socketEvent, boolean bl) {
        SocketWrapperBase<?> socketWrapperBase = this.getSocketWrapper();
        if (socketWrapperBase != null) {
            socketWrapperBase.processSocket(socketEvent, bl);
        }
    }

    protected boolean isReadyForRead() {
        if (this.available(true) > 0) {
            return true;
        }
        if (!this.isRequestBodyFullyRead()) {
            this.registerReadInterest();
        }
        return false;
    }

    protected abstract boolean isRequestBodyFullyRead();

    protected abstract void registerReadInterest();

    protected abstract boolean isReadyForWrite();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeDispatches() {
        SocketWrapperBase<?> socketWrapperBase = this.getSocketWrapper();
        Iterator<DispatchType> iterator = this.getIteratorAndClearDispatches();
        if (socketWrapperBase != null) {
            SocketWrapperBase<?> socketWrapperBase2 = socketWrapperBase;
            synchronized (socketWrapperBase2) {
                while (iterator != null && iterator.hasNext()) {
                    DispatchType dispatchType = iterator.next();
                    socketWrapperBase.processSocket(dispatchType.getSocketStatus(), false);
                }
            }
        }
    }

    @Override
    public UpgradeToken getUpgradeToken() {
        throw new IllegalStateException(sm.getString("abstractProcessor.httpupgrade.notsupported"));
    }

    protected void doHttpUpgrade(UpgradeToken upgradeToken) {
        throw new UnsupportedOperationException(sm.getString("abstractProcessor.httpupgrade.notsupported"));
    }

    @Override
    public ByteBuffer getLeftoverInput() {
        throw new IllegalStateException(sm.getString("abstractProcessor.httpupgrade.notsupported"));
    }

    @Override
    public boolean isUpgrade() {
        return false;
    }

    protected boolean isPushSupported() {
        return false;
    }

    protected void doPush(Request request) {
        throw new UnsupportedOperationException(sm.getString("abstractProcessor.pushrequest.notsupported"));
    }

    protected Object getConnectionID() {
        return null;
    }

    protected Object getStreamID() {
        return null;
    }

    protected abstract boolean flushBufferedWrite() throws IOException;

    protected abstract AbstractEndpoint.Handler.SocketState dispatchEndRequest() throws IOException;

    @Override
    protected final void logAccess(SocketWrapperBase<?> socketWrapperBase) throws IOException {
        this.setSocketWrapper(socketWrapperBase);
        this.request.setStartTime(System.currentTimeMillis());
        this.response.setStatus(400);
        this.response.setError();
        this.getAdapter().log(this.request, this.response, 0L);
    }
}

