//-*****************************************************************************
//
// Copyright (c) 2009-2013,
//  Sony Pictures Imageworks, Inc. and
//  Industrial Light & Magic, a division of Lucasfilm Entertainment Company Ltd.
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are
// met:
// *       Redistributions of source code must retain the above copyright
// notice, this list of conditions and the following disclaimer.
// *       Redistributions in binary form must reproduce the above
// copyright notice, this list of conditions and the following disclaimer
// in the documentation and/or other materials provided with the
// distribution.
// *       Neither the name of Sony Pictures Imageworks, nor
// Industrial Light & Magic nor the names of their contributors may be used
// to endorse or promote products derived from this software without specific
// prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
// "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
// LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
// A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
// OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
// SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
// LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
// OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
//
//-*****************************************************************************

#ifndef Alembic_AbcGeom_All_h
#define Alembic_AbcGeom_All_h

#include <Alembic/AbcGeom/ArchiveBounds.h>

#include <Alembic/AbcGeom/GeometryScope.h>

#include <Alembic/AbcGeom/Basis.h>
#include <Alembic/Util/Export.h>
#include <Alembic/AbcGeom/OCurves.h>
#include <Alembic/AbcGeom/ICurves.h>

#include <Alembic/AbcGeom/OFaceSet.h>
#include <Alembic/AbcGeom/IFaceSet.h>

#include <Alembic/AbcGeom/IGeomBase.h>
#include <Alembic/AbcGeom/OGeomBase.h>

#include <Alembic/AbcGeom/OGeomParam.h>
#include <Alembic/AbcGeom/IGeomParam.h>

#include <Alembic/AbcGeom/FilmBackXformOp.h>
#include <Alembic/AbcGeom/CameraSample.h>
#include <Alembic/AbcGeom/OCamera.h>
#include <Alembic/AbcGeom/ICamera.h>

#include <Alembic/AbcGeom/ILight.h>
#include <Alembic/AbcGeom/OLight.h>

#include <Alembic/AbcGeom/INuPatch.h>
#include <Alembic/AbcGeom/ONuPatch.h>

#include <Alembic/AbcGeom/OPoints.h>
#include <Alembic/AbcGeom/IPoints.h>

#include <Alembic/AbcGeom/OPolyMesh.h>
#include <Alembic/AbcGeom/IPolyMesh.h>

#include <Alembic/AbcGeom/OSubD.h>
#include <Alembic/AbcGeom/ISubD.h>

#include <Alembic/AbcGeom/XformOp.h>
#include <Alembic/AbcGeom/XformSample.h>
#include <Alembic/AbcGeom/OXform.h>
#include <Alembic/AbcGeom/IXform.h>

#include <Alembic/AbcGeom/Visibility.h>

#endif
