/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.util.CharUtilities;

public class PDFText
extends PDFObject {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private String text;

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    @Override
    protected String toPDFString() {
        if (this.getText() == null) {
            throw new IllegalArgumentException("The text of this PDFText must not be empty");
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append("(");
        sb.append(PDFText.escapeText(this.getText()));
        sb.append(")");
        return sb.toString();
    }

    public static final String escapeText(String text) {
        return PDFText.escapeText(text, false);
    }

    public static final String escapeText(String text, boolean forceHexMode) {
        if (text != null && text.length() > 0) {
            boolean unicode = false;
            boolean hexMode = false;
            if (forceHexMode) {
                hexMode = true;
            } else {
                int c = text.length();
                for (int i = 0; i < c; ++i) {
                    if (text.charAt(i) < '\u0080') continue;
                    unicode = true;
                    hexMode = true;
                    break;
                }
            }
            if (hexMode) {
                byte[] uniBytes;
                try {
                    uniBytes = text.getBytes("UTF-16");
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException("Incompatible VM", uee);
                }
                return PDFText.toHex(uniBytes);
            }
            StringBuffer result = new StringBuffer(text.length() * 2);
            result.append("(");
            int l = text.length();
            if (unicode) {
                result.append("\\376\\377");
                for (int i = 0; i < l; ++i) {
                    char ch = text.charAt(i);
                    int high = (ch & 0xFF00) >>> 8;
                    int low = ch & 0xFF;
                    result.append("\\");
                    result.append(Integer.toOctalString(high));
                    result.append("\\");
                    result.append(Integer.toOctalString(low));
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    char ch = text.charAt(i);
                    if (ch >= '\u0100') {
                        throw new IllegalStateException("Can only treat text in 8-bit ASCII/PDFEncoding");
                    }
                    PDFText.escapeStringChar(ch, result);
                }
            }
            result.append(")");
            return result.toString();
        }
        return "()";
    }

    public static final String toHex(byte[] data, boolean brackets) {
        StringBuffer sb = new StringBuffer(data.length * 2);
        if (brackets) {
            sb.append("<");
        }
        for (byte aData : data) {
            sb.append(DIGITS[aData >>> 4 & 0xF]);
            sb.append(DIGITS[aData & 0xF]);
        }
        if (brackets) {
            sb.append(">");
        }
        return sb.toString();
    }

    public static final String toHex(byte[] data) {
        return PDFText.toHex(data, true);
    }

    public static final byte[] toUTF16(String text) {
        try {
            return text.getBytes("UnicodeBig");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Incompatible VM", uee);
        }
    }

    public static final String toUnicodeHex(char c) {
        byte[] uniBytes;
        StringBuffer buf = new StringBuffer(4);
        try {
            char[] a = new char[]{c};
            uniBytes = new String(a).getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Incompatible VM", uee);
        }
        for (byte uniByte : uniBytes) {
            buf.append(DIGITS[uniByte >>> 4 & 0xF]);
            buf.append(DIGITS[uniByte & 0xF]);
        }
        return buf.toString();
    }

    public static final void toUnicodeHex(int c, StringBuffer sb) {
        if (CharUtilities.isBmpCodePoint(c)) {
            sb.append(Integer.toHexString(c + 65536).substring(1).toUpperCase(Locale.US));
        } else {
            sb.append(Integer.toHexString(c + 0x1000000).substring(1).toUpperCase(Locale.US));
        }
    }

    public static final String escapeString(String s) {
        if (s == null || s.length() == 0) {
            return "()";
        }
        StringBuffer sb = new StringBuffer(64);
        sb.append("(");
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            PDFText.escapeStringChar(c, sb);
        }
        sb.append(")");
        return sb.toString();
    }

    public static final void escapeStringChar(char c, StringBuffer target) {
        if (c > '\u007f') {
            target.append("\\");
            target.append(Integer.toOctalString(c));
        } else {
            switch (c) {
                case '\n': {
                    target.append("\\n");
                    break;
                }
                case '\r': {
                    target.append("\\r");
                    break;
                }
                case '\t': {
                    target.append("\\t");
                    break;
                }
                case '\b': {
                    target.append("\\b");
                    break;
                }
                case '\f': {
                    target.append("\\f");
                    break;
                }
                case '\\': {
                    target.append("\\\\");
                    break;
                }
                case '(': {
                    target.append("\\(");
                    break;
                }
                case ')': {
                    target.append("\\)");
                    break;
                }
                default: {
                    target.append(c);
                }
            }
        }
    }

    public static final byte[] escapeByteArray(byte[] data) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(data.length);
        bout.write(40);
        block10: for (byte b : data) {
            switch (b) {
                case 10: {
                    bout.write(92);
                    bout.write(110);
                    continue block10;
                }
                case 13: {
                    bout.write(92);
                    bout.write(114);
                    continue block10;
                }
                case 9: {
                    bout.write(92);
                    bout.write(116);
                    continue block10;
                }
                case 8: {
                    bout.write(92);
                    bout.write(98);
                    continue block10;
                }
                case 12: {
                    bout.write(92);
                    bout.write(102);
                    continue block10;
                }
                case 92: {
                    bout.write(92);
                    bout.write(92);
                    continue block10;
                }
                case 40: {
                    bout.write(92);
                    bout.write(40);
                    continue block10;
                }
                case 41: {
                    bout.write(92);
                    bout.write(41);
                    continue block10;
                }
                default: {
                    bout.write(b);
                }
            }
        }
        bout.write(41);
        return bout.toByteArray();
    }

    public static String toPDFString(CharSequence text) {
        return PDFText.toPDFString(text, '?');
    }

    public static String toPDFString(CharSequence text, char replacement) {
        StringBuffer sb = new StringBuffer();
        int c = text.length();
        for (int i = 0; i < c; ++i) {
            char ch = text.charAt(i);
            if (ch > '\u007f') {
                sb.append(replacement);
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

