// -*- c++ -*-
// Generated by gmmproc 2.46.2 -- DO NOT MODIFY!
#ifndef _GTKSPELLMM_GTKSPELL_H
#define _GTKSPELLMM_GTKSPELL_H

#include <gtkspellmmconfig.h>


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2013-2014  Sandro Mani <manisandro@gmail.com>
 *
 * This file is part of gtkspellmm.
 *
 * gtkspellmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * gtkspellmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glibmm.h>
#include <gtkmm.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GtkSpellChecker GtkSpellChecker;
typedef struct _GtkSpellCheckerClass GtkSpellCheckerClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace GtkSpell
{ class Checker_Class; } // namespace GtkSpell
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace GtkSpell
{
  
  class Error : public Glib::Error
{
public:
  /**  @var Code BACKEND
   * %Error code for backend errors.
   * 
   *  @enum Code
   * 
   * %Error codes used for GtkSpell errors.
   */
  enum Code
  {
    BACKEND
  };

  Error(Code error_code, const Glib::ustring& error_message);
  explicit Error(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace GtkSpell

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<GtkSpell::Error::Code> : public Glib::Value_Enum<GtkSpell::Error::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace GtkSpell
{


class Checker : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Checker CppObjectType;
  typedef Checker_Class CppClassType;
  typedef GtkSpellChecker BaseObjectType;
  typedef GtkSpellCheckerClass BaseClassType;

  // noncopyable
  Checker(const Checker&) = delete;
  Checker& operator=(const Checker&) = delete;

private:  friend class Checker_Class;
  static CppClassType checker_class_;

protected:
  explicit Checker(const Glib::ConstructParams& construct_params);
  explicit Checker(GtkSpellChecker* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  Checker(Checker&& src) noexcept;
  Checker& operator=(Checker&& src) noexcept;

  virtual ~Checker() noexcept;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSpellChecker*       gobj()       { return reinterpret_cast<GtkSpellChecker*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSpellChecker* gobj() const { return reinterpret_cast<GtkSpellChecker*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSpellChecker* gobj_copy();

private:

  
public:
  /** Constructs a new GtkSpell::Checker object */
  Checker();

  
  /** Attach the GtkSpell::Checker to the specified Gtk::TextView
   *
   * @param view A Gtk::TextView
   *
   * @return Whether the operation succeded
   */
  bool attach(Gtk::TextView& view);

  
  /** Retreives the GtkSpell::Checker attached to a Gtk::TextView
   *
   * @param view A Gtk::TextView
   *
   * @return A Glib::RefPtr to the attached Gtk::SpellChecker, if any, otherwise
   * a @c null Glib::RefPtr
   */
  static Glib::RefPtr<Checker> get_from_text_view(Gtk::TextView& view);

  
  /** Detaches the Gtk::SpellChecker
   *
   * If the Gtk::SpellChecker is not attached to any Gtk::TextView, the function
   * silently exits
   */
  void detach();

  
  /** Retreives a list of spelling suggestions for the specified word.
   *
   * @param word The word for which to fetch suggestions
   *
   * @return The list of spelling suggestions for the specified word.
   *
   * @newin{3,0,4}
   */
  std::vector<Glib::ustring> get_suggestions(const Glib::ustring& word);

  
  /** Retreives a Gtk::Menu of replacement spellings
   *
   * @param iter A Gtk::TextIter position in the buffer to be corrected
   *
   * @return A pointer to a Gtk::Menu, or @c null if the word is not misspelt
   */
  Gtk::Menu* get_suggestions_menu(Gtk::TextIter& iter);

  
  /** Sets the language to be used for spelling, throws an exception on failure
   *
   * @param lang The language, as a locale specifier (i.e. "en", or "en_US")
   *
   * @throws Gtk::Error An exception describing the error occured
   */
  void set_language(const Glib::ustring& lang);

  
  /** Gets the language currently being used for spelling
   *
   * @return The language, as a locale specifier (i.e. "en", or "en_US")
   */
  Glib::ustring get_language();

  
  /** Gets the list of available languages
   *
   * @return The list of languages
   * 
   * @newin{3,0,2}
   */
  static std::vector<Glib::ustring> get_language_list();

  
  /** Translates the language code to a human readable format
   *  (i.e. "en_US" -> "English (United States)").
   *
   * @param lang The language locale specifier (i.e. "en", or "en_US").
   *
   * @note If the iso-codes package is not available, the unchanged code is
   * returned.
   *
   * @returns The translated language specifier.
   *
   * @newin{3,0,2}
   */
  static Glib::ustring decode_language_code(const Glib::ustring& lang);

  
  /** Check the specified word.
   *
   * @param word The word to check.
   *
   * @returns TRUE if the word is correctly spelled, FALSE otherwise.
   *
   * @newin{3,0,4}
   */
  bool check_word(const Glib::ustring& word);

  
  /** Rechecks the entire text buffer
   */
  void recheck_all();

  
  /** Add the specified word to the user dictionary.
   *
   * @param word The word to add to the user dictionary.
   *
   * @newin{3,0,5}
   */
  void add_to_dictionary(const Glib::ustring& word);

  
  /** Add the specified word to the user ignore list.
   *
   * @param word The word to add to the user ignore list.
   *
   * @newin{3,0,5}
   */
  void ignore_word(const Glib::ustring& word);

  
  /** This signal is emitted when a new language is selected from the context menu
   *
   * @param newlang The new spelling language
   *
   * @par Slot Prototype:
   * <tt>void on_my_%language_changed(const Glib::ustring& newlang)</tt>
   *
   * The signal_language_changed() signal is emitted when the user selects
   * a new spelling language from the context menu.
   * 
   * @param newlang The new language which was selected.
   */

  Glib::SignalProxy1< void,const Glib::ustring& > signal_language_changed();


  /** Whether to show decoded language codes in the context menu
   *  (requires the iso-codes package).
   *
   * @newin{3,0,2}
   */
  /** Whether to show decoded language codes in the context menu (requires the iso-codes package).
   *
   * @return A PropertyProxy that allows you to get or set the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy< bool > property_decode_language_codes() ;

/** Whether to show decoded language codes in the context menu (requires the iso-codes package).
   *
   * @return A PropertyProxy_ReadOnly that allows you to get the value of the property,
   * or receive notification when the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_decode_language_codes() const;
;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_language_changed().
  virtual void on_language_changed(const Glib::ustring& newlang);


};

} // namespace GtkSpell


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates GtkSpell::Checker
   */
  Glib::RefPtr<GtkSpell::Checker> wrap(GtkSpellChecker* object, bool take_copy = false);
}


#endif /* _GTKSPELLMM_GTKSPELL_H */

