/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import java.util.UUID;
import javax.swing.JOptionPane;
import org.protege.editor.owl.model.io.OntologySaver;
import org.protege.editor.owl.ui.GatherOntologiesPanel;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.slf4j.LoggerFactory;

public class GatherOntologiesAction
extends ProtegeOWLAction {
    public void actionPerformed(ActionEvent e) {
        GatherOntologiesPanel panel = GatherOntologiesPanel.showDialog(this.getOWLEditorKit());
        if (panel == null) {
            return;
        }
        boolean errors = false;
        OWLDocumentFormat saveAsFormat = panel.getOntologyFormat();
        File saveAsLocation = panel.getSaveLocation();
        OntologySaver.Builder ontologySaverBuilder = OntologySaver.builder();
        for (OWLOntology ont : panel.getOntologiesToSave()) {
            OWLDocumentFormat documentFormat;
            OWLOntologyManager man = this.getOWLModelManager().getOWLOntologyManager();
            Object format = saveAsFormat != null ? saveAsFormat : ((documentFormat = man.getOntologyFormat(ont)) != null ? documentFormat : new RDFXMLDocumentFormat());
            URI originalPhysicalURI = man.getOntologyDocumentIRI(ont).toURI();
            String originalPath = originalPhysicalURI.getPath();
            if (originalPath == null) {
                originalPath = UUID.randomUUID().toString() + ".owl";
            }
            File originalFile = new File(originalPath);
            String originalFileName = originalFile.getName();
            File saveAsFile = new File(saveAsLocation, originalFileName);
            ontologySaverBuilder.addOntology(ont, (OWLDocumentFormat)format, IRI.create((File)saveAsFile));
        }
        try {
            ontologySaverBuilder.build().saveOntologies();
        }
        catch (OWLOntologyStorageException e1) {
            LoggerFactory.getLogger(GatherOntologiesAction.class).error("An error occurred whilst saving a gathered ontology: {}", (Throwable)e1);
            errors = true;
        }
        if (errors) {
            JOptionPane.showMessageDialog((Component)this.getWorkspace(), "There were errors when saving the ontologies.  Please check the log for details.", "Error during save", 0);
        }
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }
}

