/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.hierarchy.creation;

import java.awt.BorderLayout;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.AbstractOWLWizardPanel;
import org.protege.editor.owl.ui.tree.OWLModelManagerTree;
import org.semanticweb.owlapi.model.OWLClass;

public class PickRootClassPanel
extends AbstractOWLWizardPanel {
    private static final long serialVersionUID = 3010893357248469815L;
    public static final String ID = "PickRootClassPanel";
    private OWLModelManagerTree<OWLClass> tree;

    public PickRootClassPanel(OWLEditorKit owlEditorKit) {
        super(ID, "Pick root class", owlEditorKit);
    }

    protected void createUI(JComponent parent) {
        parent.setLayout(new BorderLayout());
        this.setInstructions("Please select the root class");
        this.tree = new OWLModelManagerTree<OWLClass>(this.getOWLEditorKit(), this.getOWLModelManager().getOWLHierarchyManager().getOWLClassHierarchyProvider());
        this.tree.setSelectedOWLObject(this.getOWLEditorKit().getWorkspace().getOWLSelectionModel().getLastSelectedClass());
        parent.add(ComponentFactory.createScrollPane(this.tree));
    }

    public void displayingPanel() {
        this.tree.requestFocus();
    }

    public OWLClass getRootClass() {
        OWLClass cls = (OWLClass)this.tree.getSelectedOWLObject();
        if (cls == null) {
            return this.getOWLModelManager().getOWLDataFactory().getOWLThing();
        }
        return (OWLClass)this.tree.getSelectedOWLObject();
    }

    public Object getNextPanelDescriptor() {
        return "TabIndentedHierarchyPanel";
    }

    public void dispose() {
        this.tree.dispose();
    }
}

