/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.search;

import com.google.common.base.Optional;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.search.SearchPanel;
import org.semanticweb.owlapi.model.OWLEntity;

public class SearchDialogPanel
extends JPanel {
    private final JTextField searchField;
    private final SearchPanel searchPanel;
    private final OWLEditorKit editorKit;

    public SearchDialogPanel(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.setLayout(new BorderLayout());
        this.searchField = new AugmentedJTextField("Enter search string");
        this.searchPanel = new SearchPanel(editorKit);
        this.add((Component)this.searchField, "North");
        this.add((Component)this.searchPanel, "Center");
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SearchDialogPanel.this.selectEntity();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    SearchDialogPanel.this.searchPanel.moveSelectionUp();
                    e.consume();
                }
                if (e.getKeyCode() == 40) {
                    SearchDialogPanel.this.searchPanel.moveSelectionDown();
                    e.consume();
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                SearchDialogPanel.this.performSearch();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SearchDialogPanel.this.performSearch();
            }
        });
        this.searchPanel.setSearchResultClickedListener((searchResult, e) -> {
            if (e.getClickCount() == 2) {
                this.selectEntity();
            }
        });
    }

    private void selectEntity() {
        Optional<OWLEntity> selectedEntity = this.searchPanel.getSelectedEntity();
        if (selectedEntity.isPresent()) {
            this.editorKit.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)selectedEntity.get());
            this.editorKit.getOWLWorkspace().displayOWLEntity((OWLEntity)selectedEntity.get());
        }
    }

    private void performSearch() {
        this.searchPanel.setSearchString(this.searchField.getText().trim());
    }

    public static JDialog createDialog(JComponent parent, OWLEditorKit editorKit) {
        JFrame parentFrame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, parent);
        final JDialog dialog = new JDialog((Window)parentFrame, "Search", Dialog.ModalityType.MODELESS);
        final SearchDialogPanel searchDialogPanel = new SearchDialogPanel(editorKit);
        searchDialogPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        searchDialogPanel.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "CLOSE_DIALOG");
        searchDialogPanel.getActionMap().put("CLOSE_DIALOG", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
            }
        });
        searchDialogPanel.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "CLOSE_DIALOG_WITH_ENTER");
        searchDialogPanel.getActionMap().put("CLOSE_DIALOG_WITH_ENTER", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialog.setVisible(false);
                searchDialogPanel.selectEntity();
            }
        });
        dialog.setContentPane(searchDialogPanel);
        dialog.setResizable(true);
        dialog.pack();
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                searchDialogPanel.searchField.requestFocusInWindow();
                searchDialogPanel.searchField.selectAll();
            }
        });
        return dialog;
    }
}

