/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.util.Construct;
import org.semanticweb.owlapi.util.Languages;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class DLExpressivityChecker
extends OWLObjectVisitorAdapter {
    private Set<Construct> constructs;
    private final List<OWLOntology> ontologies;

    public Collection<Languages> expressibleInLanguages() {
        return Arrays.stream(Languages.values()).filter(this::minimal).collect(Collectors.toList());
    }

    public boolean minimal(Languages l) {
        if (!l.components.containsAll(this.getOrderedConstructs())) {
            return false;
        }
        return Arrays.stream(Languages.values()).filter(p -> p.isSubLanguageOf(l)).noneMatch(this::minimal);
    }

    public boolean isWithin(Languages l) {
        return l.components.containsAll(this.getOrderedConstructs());
    }

    public boolean has(Construct c) {
        return this.getOrderedConstructs().contains((Object)c);
    }

    public DLExpressivityChecker(Set<OWLOntology> ontologies) {
        this.ontologies = new ArrayList<OWLOntology>(ontologies);
    }

    private static boolean isTop(OWLClassExpression classExpression) {
        return classExpression.isOWLThing();
    }

    public List<Construct> getConstructs() {
        return new ArrayList<Construct>(this.getOrderedConstructs());
    }

    @Nonnull
    public String getDescriptionLogicName() {
        return this.getOrderedConstructs().stream().map(Object::toString).collect(Collectors.joining());
    }

    private Set<Construct> getOrderedConstructs() {
        if (this.constructs == null) {
            this.constructs = new TreeSet<Construct>();
            this.ontologies.stream().flatMap(o -> o.getLogicalAxioms().stream()).forEach(ax -> ax.accept(this));
        }
        Construct.trim(this.constructs);
        return this.constructs;
    }

    private void addConstruct(Construct c) {
        if (this.constructs == null) {
            this.constructs = new TreeSet<Construct>();
        }
        if (c == Construct.ROLE_INVERSE && this.constructs.contains((Object)Construct.ROLE_REFLEXIVITY_CHAINS)) {
            this.constructs.add(c);
            this.constructs.remove((Object)Construct.ROLE_REFLEXIVITY_CHAINS);
            this.constructs.add(Construct.ROLE_COMPLEX);
        } else if (c == Construct.ROLE_REFLEXIVITY_CHAINS && this.constructs.contains((Object)Construct.ROLE_INVERSE)) {
            this.constructs.add(Construct.ROLE_COMPLEX);
        } else {
            this.constructs.add(c);
        }
    }

    private boolean isAtomic(OWLClassExpression classExpression) {
        if (classExpression.isAnonymous()) {
            return false;
        }
        return this.ontologies.stream().noneMatch(ont -> ont.getAxioms((OWLClass)classExpression, Imports.EXCLUDED).size() > 0);
    }

    private void checkCardinality(OWLDataCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.addConstruct(Construct.Q);
        } else {
            this.addConstruct(Construct.N);
        }
        ((OWLDataRange)restriction.getFiller()).accept(this);
        restriction.getProperty().accept(this);
    }

    private void checkCardinality(OWLObjectCardinalityRestriction restriction) {
        if (restriction.isQualified()) {
            this.addConstruct(Construct.Q);
        } else {
            this.addConstruct(Construct.N);
        }
        ((OWLClassExpression)restriction.getFiller()).accept(this);
        restriction.getProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.addConstruct(Construct.ROLE_INVERSE);
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLDataComplementOf node) {
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLDataOneOf node) {
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLDatatypeRestriction node) {
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLLiteral node) {
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLFacetRestriction node) {
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.addConstruct(Construct.CONCEPT_INTERSECTION);
        ce.getOperandsAsList().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.addConstruct(Construct.CONCEPT_UNION);
        ce.getOperandsAsList().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        if (this.isAtomic(ce)) {
            this.addConstruct(Construct.ATOMIC_NEGATION);
        } else {
            this.addConstruct(Construct.CONCEPT_COMPLEX_NEGATION);
        }
        ce.getOperand().accept(this);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        if (DLExpressivityChecker.isTop((OWLClassExpression)ce.getFiller())) {
            this.addConstruct(Construct.LIMITED_EXISTENTIAL);
        } else {
            this.addConstruct(Construct.FULL_EXISTENTIAL);
        }
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.addConstruct(Construct.UNIVERSAL_RESTRICTION);
        ce.getProperty().accept(this);
        ((OWLClassExpression)ce.getFiller()).accept(this);
    }

    @Override
    public void visit(OWLObjectHasValue ce) {
        this.addConstruct(Construct.NOMINALS);
        this.addConstruct(Construct.FULL_EXISTENTIAL);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLObjectHasSelf ce) {
        ce.getProperty().accept(this);
        this.addConstruct(Construct.ROLE_COMPLEX);
    }

    @Override
    public void visit(OWLObjectOneOf ce) {
        this.addConstruct(Construct.CONCEPT_UNION);
        this.addConstruct(Construct.NOMINALS);
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.addConstruct(Construct.FULL_EXISTENTIAL);
        ((OWLDataRange)ce.getFiller()).accept(this);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        ((OWLDataRange)ce.getFiller()).accept(this);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLDataHasValue ce) {
        this.addConstruct(Construct.D);
        ce.getProperty().accept(this);
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.checkCardinality(ce);
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        axiom.getSubClass().accept(this);
        axiom.getSuperClass().accept(this);
    }

    @Override
    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.ROLE_COMPLEX);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.ROLE_REFLEXIVITY_CHAINS);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.addConstruct(Construct.CONCEPT_COMPLEX_NEGATION);
        axiom.getClassExpressionsAsList().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.addConstruct(Construct.ROLE_DOMAIN_RANGE);
        this.addConstruct(Construct.D);
        axiom.getDomain().accept(this);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.addConstruct(Construct.ROLE_DOMAIN_RANGE);
        axiom.getDomain().accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.addConstruct(Construct.ROLE_HIERARCHY);
        axiom.getProperties().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.addConstruct(Construct.CONCEPT_UNION);
        this.addConstruct(Construct.NOMINALS);
        this.addConstruct(Construct.CONCEPT_COMPLEX_NEGATION);
    }

    @Override
    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.addConstruct(Construct.D);
        axiom.getProperties().forEach(prop -> prop.accept(this));
    }

    @Override
    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.addConstruct(Construct.ROLE_COMPLEX);
        axiom.getProperties().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.addConstruct(Construct.ROLE_DOMAIN_RANGE);
        ((OWLClassExpression)axiom.getRange()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.addConstruct(Construct.ROLE_HIERARCHY);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept(this);
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept(this);
    }

    @Override
    public void visit(OWLDisjointUnionAxiom axiom) {
        this.addConstruct(Construct.CONCEPT_UNION);
        this.addConstruct(Construct.CONCEPT_COMPLEX_NEGATION);
        axiom.getClassExpressions().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.ROLE_INVERSE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.addConstruct(Construct.ROLE_DOMAIN_RANGE);
        this.addConstruct(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.addConstruct(Construct.F);
        this.addConstruct(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.addConstruct(Construct.ROLE_HIERARCHY);
        this.addConstruct(Construct.D);
        axiom.getProperties().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        axiom.getClassExpression().accept(this);
    }

    @Override
    public void visit(OWLEquivalentClassesAxiom axiom) {
        axiom.getClassExpressionsAsList().forEach(o -> o.accept(this));
    }

    @Override
    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.addConstruct(Construct.D);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.ROLE_TRANSITIVE);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.ROLE_COMPLEX);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.addConstruct(Construct.ROLE_HIERARCHY);
        this.addConstruct(Construct.D);
    }

    @Override
    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.addConstruct(Construct.ROLE_INVERSE);
        this.addConstruct(Construct.F);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept(this);
    }

    @Override
    public void visit(OWLSameIndividualAxiom axiom) {
        this.addConstruct(Construct.NOMINALS);
    }

    @Override
    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.addConstruct(Construct.ROLE_REFLEXIVITY_CHAINS);
        axiom.getPropertyChain().forEach(o -> o.accept(this));
        axiom.getSuperProperty().accept(this);
    }

    @Override
    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.addConstruct(Construct.ROLE_INVERSE);
    }
}

