/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.util;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitor;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

@Deprecated
public class ObjectPropertySimplifier {
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final Simplifier simplifier = new Simplifier();

    public ObjectPropertySimplifier(@Nonnull OWLDataFactory dataFactory) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(dataFactory, "dataFactory cannot be null");
    }

    @Nonnull
    public OWLObjectPropertyExpression getSimplified(@Nonnull OWLObjectPropertyExpression prop) {
        OWLAPIPreconditions.checkNotNull(prop, "prop cannot be null");
        this.simplifier.reset();
        prop.accept(this.simplifier);
        if (this.simplifier.isInverse()) {
            return this.dataFactory.getOWLObjectInverseOf(this.simplifier.getProperty());
        }
        return this.simplifier.getProperty();
    }

    private static class Simplifier
    implements OWLPropertyExpressionVisitor {
        private OWLObjectProperty p;
        private int depth;

        Simplifier() {
        }

        public void reset() {
            this.depth = 0;
            this.p = null;
        }

        @Nonnull
        public OWLObjectProperty getProperty() {
            return OWLAPIPreconditions.verifyNotNull(this.p);
        }

        public boolean isInverse() {
            return this.depth % 2 != 0;
        }

        @Override
        public void visit(OWLObjectProperty property) {
            this.p = property;
        }

        @Override
        public void visit(OWLObjectInverseOf property) {
            ++this.depth;
            property.getInverse().accept(this);
        }

        @Override
        public void visit(OWLDataProperty property) {
        }

        @Override
        public void visit(OWLAnnotationProperty property) {
        }
    }
}

