/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLAxiomVisitorEx;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLPropertyAxiomImplWithEntityAndAnonCaching;

public class OWLSubPropertyChainAxiomImpl
extends OWLPropertyAxiomImplWithEntityAndAnonCaching
implements OWLSubPropertyChainOfAxiom {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final List<OWLObjectPropertyExpression> propertyChain;
    @Nonnull
    private final OWLObjectPropertyExpression superProperty;

    public OWLSubPropertyChainAxiomImpl(@Nonnull List<? extends OWLObjectPropertyExpression> propertyChain, @Nonnull OWLObjectPropertyExpression superProperty, @Nonnull Collection<? extends OWLAnnotation> annotations) {
        super(annotations);
        this.propertyChain = new ArrayList<OWLObjectPropertyExpression>((Collection)OWLAPIPreconditions.checkNotNull(propertyChain, "propertyChain cannot be null"));
        this.superProperty = OWLAPIPreconditions.checkNotNull(superProperty, "superProperty cannot be null");
    }

    @Override
    public OWLSubPropertyChainOfAxiom getAnnotatedAxiom(Set<OWLAnnotation> annotations) {
        return new OWLSubPropertyChainAxiomImpl(this.getPropertyChain(), this.getSuperProperty(), this.mergeAnnos(annotations));
    }

    @Override
    public OWLSubPropertyChainOfAxiom getAxiomWithoutAnnotations() {
        if (!this.isAnnotated()) {
            return this;
        }
        return new OWLSubPropertyChainAxiomImpl(this.getPropertyChain(), this.getSuperProperty(), NO_ANNOTATIONS);
    }

    @Override
    public List<OWLObjectPropertyExpression> getPropertyChain() {
        return new ArrayList<OWLObjectPropertyExpression>(this.propertyChain);
    }

    @Override
    public OWLObjectPropertyExpression getSuperProperty() {
        return this.superProperty;
    }

    @Override
    public boolean isEncodingOfTransitiveProperty() {
        if (this.propertyChain.size() == 2) {
            return this.superProperty.equals(this.propertyChain.get(0)) && this.superProperty.equals(this.propertyChain.get(1));
        }
        return false;
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLAxiomVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLAxiomVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLSubPropertyChainOfAxiom)) {
            return false;
        }
        OWLSubPropertyChainOfAxiom other = (OWLSubPropertyChainOfAxiom)obj;
        return other.getPropertyChain().equals(this.getPropertyChain()) && other.getSuperProperty().equals(this.superProperty);
    }

    @Override
    public AxiomType<?> getAxiomType() {
        return AxiomType.SUB_PROPERTY_CHAIN_OF;
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        OWLSubPropertyChainOfAxiom other = (OWLSubPropertyChainOfAxiom)object;
        for (int i = 0; i < this.propertyChain.size() && i < other.getPropertyChain().size(); ++i) {
            int diff = this.propertyChain.get(i).compareTo(other.getPropertyChain().get(i));
            if (diff == 0) continue;
            return diff;
        }
        int diff = this.propertyChain.size() - other.getPropertyChain().size();
        if (diff != 0) {
            return diff;
        }
        return this.superProperty.compareTo(other.getSuperProperty());
    }
}

