/*
 * Decompiled with CFR 0.152.
 */
package org.coode.mdock;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.coode.mdock.ComponentNode;
import org.coode.mdock.Node;
import org.coode.mdock.NodePanel;
import org.coode.mdock.Util;
import org.coode.mdock.VerticalSplitterNode;

public class ColumnPanel
extends JPanel {
    private NodePanel columns;
    private VerticalSplitterNode node;
    private int defaultColumnWidth = 180;
    private JPanel holderPanel;
    private JScrollPane sp;
    private LinkedHashMap<JComponent, Node> componentNodeMap = new LinkedHashMap();

    public ColumnPanel(JComponent initialComponent) {
        ComponentNode firstComponentNode = new ComponentNode();
        firstComponentNode.add(initialComponent, "Component");
        ArrayList<ComponentNode> nodes = new ArrayList<ComponentNode>();
        nodes.add(firstComponentNode);
        ArrayList<Double> splits = new ArrayList<Double>();
        splits.add(1.0);
        this.componentNodeMap.put(initialComponent, firstComponentNode);
        this.node = new VerticalSplitterNode(nodes, splits);
        this.columns = new NodePanel(this.node){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(ColumnPanel.this.node.getVisibleChildren().size() * ColumnPanel.this.defaultColumnWidth, 10);
            }
        };
        this.setLayout(new BorderLayout());
        this.holderPanel = new JPanel(new BorderLayout());
        this.holderPanel.add((Component)this.columns, "West");
        this.sp = new JScrollPane(this.holderPanel);
        this.add(this.sp);
    }

    public void ensureVisible(JComponent component) {
        component.scrollRectToVisible(new Rectangle(component.getSize().width, 10));
    }

    public void removeColumnsAfter(JComponent columnContent) {
        boolean remove = false;
        Iterator<JComponent> it = this.componentNodeMap.keySet().iterator();
        while (it.hasNext()) {
            JComponent comp = it.next();
            Node curNode = this.componentNodeMap.get(comp);
            if (comp.equals(columnContent)) {
                remove = true;
                continue;
            }
            if (!remove) continue;
            it.remove();
            this.node.removeChild(curNode);
        }
        this.columns.rebuild();
        this.columns.validate();
    }

    public void addColumn(JComponent content, JComponent after) {
        JComponent focusedComponent = null;
        for (JComponent c : this.componentNodeMap.keySet()) {
            if (!c.isFocusOwner()) continue;
            focusedComponent = c;
            break;
        }
        List<Node> visibleChildren = this.node.getVisibleChildren();
        ArrayList<Integer> widths = new ArrayList<Integer>();
        int total = 0;
        for (Node childNode : visibleChildren) {
            int childWidth = Util.getWidth(childNode, this.columns, false);
            widths.add(childWidth);
            total += childWidth;
        }
        widths.add(this.defaultColumnWidth);
        this.removeColumnsAfter(after);
        visibleChildren = this.node.getVisibleChildren();
        ComponentNode cn = new ComponentNode();
        cn.add(content, "");
        this.componentNodeMap.put(content, cn);
        if (!visibleChildren.isEmpty()) {
            this.node.insertNodeAfter((Node)cn, visibleChildren.get(visibleChildren.size() - 1), 1);
        } else {
            this.node.addChild(cn, 0, 1.0);
        }
        visibleChildren = this.node.getVisibleChildren();
        int currentIndex = 0;
        for (Node nn : visibleChildren) {
            this.node.setSplit(nn, (double)((Integer)widths.get(currentIndex)).intValue() * 1.0 / (double)total);
            ++currentIndex;
        }
        this.columns.rebuild();
        this.holderPanel.setPreferredSize(new Dimension(this.node.getVisibleChildren().size() * this.defaultColumnWidth, 10));
        this.sp.validate();
        this.sp.getHorizontalScrollBar().setValue(Integer.MAX_VALUE);
        if (focusedComponent != null) {
            System.out.println("Refocusing");
            focusedComponent.requestFocus();
        } else {
            content.requestFocus();
        }
    }

    public static void main(String[] args) {
        JButton button = new JButton("Test");
        ColumnPanel pan = new ColumnPanel(button);
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.setSize(new Dimension(300, 400));
        f.setContentPane(pan);
        f.setVisible(true);
    }
}

