/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.about;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.table.AbstractTableModel;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.ProtegeApplication;

public class PluginInfoTableModel
extends AbstractTableModel {
    private List<Bundle> bundles = Arrays.stream(ProtegeApplication.getContext().getBundles()).filter(ProtegeApplication::isPlugin).sorted(Comparator.comparing(b -> (String)b.getHeaders().get("Bundle-Name"), Comparator.nullsLast(String.CASE_INSENSITIVE_ORDER))).collect(Collectors.toList());

    @Override
    public int getRowCount() {
        return this.bundles.size();
    }

    @Override
    public int getColumnCount() {
        return Columns.values().length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Bundle bundle = this.bundles.get(rowIndex);
        String version_name = (String)bundle.getHeaders().get("Bundle-Version");
        Version v = null;
        if (version_name != null) {
            v = new Version(version_name);
        }
        switch (Columns.values()[columnIndex]) {
            case NAME: {
                String name = (String)bundle.getHeaders().get("Bundle-Name");
                if (name == null) {
                    name = bundle.getSymbolicName();
                }
                return name;
            }
            case VERSION: {
                return v == null ? "" : "" + v.getMajor() + "." + v.getMinor() + "." + v.getMicro();
            }
            case QUALIFIER: {
                return v.getQualifier();
            }
        }
        throw new RuntimeException("Programmer error - missed a case");
    }

    @Override
    public String getColumnName(int column) {
        return Columns.values()[column].getName();
    }

    public static enum Columns {
        NAME("Name/ID"),
        VERSION("Version"),
        QUALIFIER("Qualifier");

        private String name;

        private Columns(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

