/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Random;
import javax.swing.SwingUtilities;
import org.gjt.sp.jedit.BeanShell;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.PerspectiveManager;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.bsh.NameSpace;
import org.gjt.sp.jedit.bsh.UtilEvalError;
import org.gjt.sp.jedit.io.FileVFS;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.Log;

public class EditServer
extends Thread {
    private final String portFile;
    private ServerSocket socket;
    private int authKey;
    private boolean ok;
    private boolean abort;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EditServer(String string) {
        super("jEdit server daemon [" + string + "]");
        this.setDaemon(true);
        this.portFile = string;
        try {
            if (OperatingSystem.isUnix()) {
                new File(string).createNewFile();
                FileVFS.setPermissions(string, 384);
            }
            this.socket = new ServerSocket(0, 2, InetAddress.getByName(null));
            this.authKey = new Random().nextInt(Integer.MAX_VALUE);
            int n = this.socket.getLocalPort();
            try (FileWriter fileWriter = new FileWriter(string);){
                fileWriter.write("b\n");
                fileWriter.write(String.valueOf(n));
                fileWriter.write("\n");
                fileWriter.write(String.valueOf(this.authKey));
                fileWriter.write("\n");
            }
            this.ok = true;
            Log.log(1, this, "jEdit server started on port " + this.socket.getLocalPort());
            Log.log(1, this, "Authorization key is " + this.authKey);
        }
        catch (IOException iOException) {
            Log.log(5, this, iOException);
        }
    }

    @Override
    public void run() {
        while (!this.abort) {
            try {
                Socket socket = this.socket.accept();
                socket.setSoTimeout(1000);
                Log.log(3, this, socket + ": connected");
                DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                if (this.handleClient(socket, dataInputStream)) continue;
                this.abort = true;
                continue;
            }
            catch (Exception exception) {
                if (!this.abort) {
                    Log.log(9, this, exception);
                }
                this.abort = true;
                continue;
            }
            break;
        }
        return;
    }

    public static void handleClient(boolean bl, String string, String[] stringArray) {
        EditServer.handleClient(bl, false, false, string, stringArray);
    }

    public static Buffer handleClient(boolean bl, boolean bl2, boolean bl3, String string, String[] stringArray) {
        if (jEdit.getFirstView() == null) {
            boolean bl4 = false;
            for (String string2 : stringArray) {
                if (string2 == null) continue;
                bl4 = true;
                break;
            }
            boolean bl5 = bl && jEdit.getBooleanProperty("restore") && (!bl4 || jEdit.getBooleanProperty("restore.cli"));
            View view = PerspectiveManager.loadPerspective(bl5);
            Buffer buffer = jEdit.openFiles(view, string, stringArray);
            if (view == null) {
                if (buffer == null) {
                    buffer = jEdit.getFirstBuffer();
                }
                jEdit.newView(null, buffer);
            } else if (buffer != null) {
                view.setBuffer(buffer);
            }
            return buffer;
        }
        if (bl3) {
            Buffer buffer = jEdit.openFiles(null, string, stringArray);
            if (buffer == null) {
                buffer = jEdit.getFirstBuffer();
            }
            jEdit.newView(null, buffer, true);
            return buffer;
        }
        if (bl2) {
            Buffer buffer = jEdit.openFiles(null, string, stringArray);
            if (buffer == null) {
                buffer = jEdit.getFirstBuffer();
            }
            jEdit.newView(jEdit.getActiveView(), buffer, false);
            return buffer;
        }
        View view = jEdit.getActiveView();
        Buffer buffer = jEdit.openFiles(view, string, stringArray);
        if (jEdit.getBooleanProperty("server.brokenToFront")) {
            view.setState(1);
        }
        view.setState(0);
        view.requestFocus();
        view.toFront();
        if (!view.isAlwaysOnTop()) {
            view.setAlwaysOnTop(true);
            view.setAlwaysOnTop(false);
        }
        return buffer;
    }

    boolean isOK() {
        return this.ok;
    }

    public int getPort() {
        return this.socket.getLocalPort();
    }

    void stopServer() {
        this.abort = true;
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(this.portFile).delete();
    }

    private boolean handleClient(final Socket socket, DataInputStream dataInputStream) throws Exception {
        int n = dataInputStream.readInt();
        if (n != this.authKey) {
            Log.log(9, this, socket + ": wrong authorization key (got " + n + ", expected " + this.authKey + ")");
            dataInputStream.close();
            socket.close();
            return false;
        }
        socket.setSoTimeout(0);
        Log.log(1, this, socket + ": authenticated successfully");
        final String string = dataInputStream.readUTF();
        Log.log(1, this, string);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    NameSpace nameSpace = new NameSpace(BeanShell.getNameSpace(), "EditServer namespace");
                    nameSpace.setVariable("socket", socket);
                    BeanShell.eval(null, nameSpace, string);
                }
                catch (UtilEvalError utilEvalError) {
                    Log.log(9, this, utilEvalError);
                }
                finally {
                    try {
                        BeanShell.getNameSpace().setVariable("socket", null);
                    }
                    catch (UtilEvalError utilEvalError) {
                        Log.log(9, this, utilEvalError);
                    }
                }
            }
        });
        return true;
    }
}

