/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.gjt.sp.jedit.gui.EnhancedDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.pluginmgr.PluginManager;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.StandardUtilities;

public class ErrorListDialog
extends EnhancedDialog {
    public ErrorListDialog(Frame frame, String string, String string2, Vector<ErrorEntry> vector, boolean bl) {
        super(frame, string, !bl);
        JPanel jPanel = new JPanel(new BorderLayout(12, 12));
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.setContentPane(jPanel);
        Box box = new Box(1);
        box.add(new JLabel(UIManager.getIcon("OptionPane.errorIcon")));
        box.add(Box.createGlue());
        jPanel.add("West", box);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(string2);
        jLabel.setBorder(new EmptyBorder(0, 0, 6, 0));
        jPanel2.add("North", jLabel);
        JTextPaneSized jTextPaneSized = new JTextPaneSized();
        jTextPaneSized.setEditable(false);
        jTextPaneSized.setForeground(jEdit.getColorProperty("view.fgColor"));
        jTextPaneSized.setBackground(jEdit.getColorProperty("view.bgColor"));
        jTextPaneSized.setCaretColor(jEdit.getColorProperty("view.caretColor"));
        jTextPaneSized.setSelectionColor(jEdit.getColorProperty("view.selectionColor"));
        StyledDocument styledDocument = jTextPaneSized.getStyledDocument();
        Font font = new JLabel().getFont();
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setFontFamily(simpleAttributeSet, font.getFamily());
        SimpleAttributeSet simpleAttributeSet2 = (SimpleAttributeSet)simpleAttributeSet.clone();
        StyleConstants.setBold(simpleAttributeSet2, true);
        for (ErrorEntry object2 : vector) {
            try {
                styledDocument.insertString(styledDocument.getLength(), object2.path + ":\n", simpleAttributeSet2);
                for (String string3 : object2.messages) {
                    styledDocument.insertString(styledDocument.getLength(), string3 + "\n", simpleAttributeSet);
                }
            }
            catch (BadLocationException badLocationException) {
            }
        }
        JScrollPane jScrollPane = new JScrollPane(jTextPaneSized);
        jPanel2.add("Center", jScrollPane);
        jPanel.add("Center", jPanel2);
        Box box2 = new Box(0);
        box2.add(Box.createGlue());
        JButton badLocationException = new JButton(jEdit.getProperty("common.ok"));
        badLocationException.addActionListener(actionEvent -> this.dispose());
        if (bl) {
            JButton jButton = new JButton(jEdit.getProperty("error-list.plugin-manager"));
            jButton.addActionListener(actionEvent -> PluginManager.showPluginManager(JOptionPane.getFrameForComponent(this)));
            box2.add(jButton);
            box2.add(Box.createHorizontalStrut(6));
        }
        box2.add(badLocationException);
        box2.add(Box.createGlue());
        jPanel.add("South", box2);
        this.getRootPane().setDefaultButton(badLocationException);
        this.pack();
        this.setLocationRelativeTo(frame);
        this.setVisible(true);
    }

    @Override
    public void ok() {
        this.dispose();
    }

    @Override
    public void cancel() {
        this.dispose();
    }

    protected static class JTextPaneSized
    extends JTextPane {
        protected JTextPaneSized() {
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            int n = 80 * fontMetrics.charWidth('X');
            int n2 = 25 * fontMetrics.getHeight();
            return new Dimension(n, n2);
        }
    }

    public static class ErrorEntry {
        String path;
        String[] messages;

        public ErrorEntry(String string, String string2, Object[] objectArray) {
            this(string, string2, objectArray, 9);
        }

        public ErrorEntry(String string, String string2, Object[] objectArray, int n) {
            this.path = string;
            Object object = jEdit.getProperty(string2, objectArray);
            if (object == null) {
                object = "Undefined property: " + string2;
            }
            Log.log(n, this, string + ":");
            Log.log(n, this, object);
            ArrayList<String> arrayList = new ArrayList<String>();
            int n2 = -1;
            for (int i = 0; i < ((String)object).length(); ++i) {
                if (((String)object).charAt(i) != '\n') continue;
                arrayList.add(((String)object).substring(n2 + 1, i));
                n2 = i;
            }
            if (n2 != ((String)object).length()) {
                arrayList.add(((String)object).substring(n2 + 1));
            }
            this.messages = arrayList.toArray(StandardUtilities.EMPTY_STRING_ARRAY);
        }

        public boolean equals(Object object) {
            if (object instanceof ErrorEntry) {
                ErrorEntry errorEntry = (ErrorEntry)object;
                return errorEntry.path.equals(this.path);
            }
            return false;
        }

        public String toString() {
            return this.path + ":\n" + String.join((CharSequence)"\n", this.messages);
        }
    }
}

