/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.menu;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.menu.DynamicMenuProvider;

public class MarkersProvider
implements DynamicMenuProvider {
    @Override
    public boolean updateEveryTime() {
        return true;
    }

    @Override
    public void update(JMenu jMenu) {
        View view = GUIUtilities.getView(jMenu);
        Buffer buffer = view.getBuffer();
        Vector<Marker> vector = buffer.getMarkers();
        if (vector.isEmpty()) {
            JMenuItem jMenuItem = new JMenuItem(jEdit.getProperty("no-markers.label"));
            jMenuItem.setEnabled(false);
            jMenu.add(jMenuItem);
            return;
        }
        int n = jEdit.getIntegerProperty("menu.spillover", 20);
        JMenuItem jMenuItem = jMenu;
        for (int i = 0; i < vector.size(); ++i) {
            JMenuItem jMenuItem2;
            Marker marker = (Marker)vector.get(i);
            int n2 = buffer.getLineOfOffset(marker.getPosition());
            if (jMenuItem.getItemCount() >= n && i != vector.size() - 1) {
                jMenuItem2 = new JMenu(jEdit.getProperty("common.more"));
                jMenuItem.add(jMenuItem2);
                jMenuItem = jMenuItem2;
            }
            jMenuItem2 = new MarkersMenuItem(buffer, n2, marker.getShortcut());
            jMenuItem2.addActionListener(actionEvent -> view.getTextArea().setCaretPosition(marker.getPosition()));
            jMenuItem.add(jMenuItem2);
        }
    }

    private static class MarkersMenuItem
    extends JMenuItem {
        private final String shortcutProp;
        private final char shortcut;
        private static final Font acceleratorFont = GUIUtilities.menuAcceleratorFont();
        private static final Color acceleratorForeground = UIManager.getColor("MenuItem.acceleratorForeground");
        private static final Color acceleratorSelectionForeground = UIManager.getColor("MenuItem.acceleratorSelectionForeground");

        MarkersMenuItem(Buffer buffer, int n, char c) {
            String string = buffer.getLineText(n).trim();
            if (string.isEmpty()) {
                string = jEdit.getProperty("markers.blank-line");
            }
            this.setText(n + 1 + ": " + string);
            this.shortcutProp = "goto-marker.shortcut";
            this.shortcut = c;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            String string = this.getShortcut();
            if (string != null) {
                FontMetrics fontMetrics = this.getFontMetrics(acceleratorFont);
                dimension.width += fontMetrics.stringWidth(string) + fontMetrics.stringWidth("AAAA");
            }
            return dimension;
        }

        @Override
        public void paint(Graphics graphics) {
            super.paint(graphics);
            String string = this.getShortcut();
            if (string != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics.setFont(acceleratorFont);
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.setColor(this.getModel().isArmed() ? acceleratorSelectionForeground : acceleratorForeground);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                Insets insets = this.getInsets();
                graphics.drawString(string, this.getWidth() - (fontMetrics.stringWidth(string) + insets.right + insets.left + 5), fontMetrics.getAscent() + insets.top);
            }
        }

        private String getShortcut() {
            if (this.shortcut == '\u0000') {
                return null;
            }
            String string = jEdit.getProperty(this.shortcutProp);
            if (string == null) {
                return null;
            }
            return string + " " + this.shortcut;
        }
    }
}

