/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.keymap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.JOptionPane;
import org.gjt.sp.jedit.IPropertyManager;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapFileFilter;
import org.jedit.keymap.KeymapImpl;
import org.jedit.keymap.KeymapManager;

public class KeymapManagerImpl
implements KeymapManager {
    private Keymap currentKeymap;
    private final IPropertyManager propertyManager;
    private static File userKeymapFolder;
    private final File systemKeymapFolder;

    public KeymapManagerImpl(IPropertyManager iPropertyManager, File file, File file2) {
        this.propertyManager = iPropertyManager;
        this.systemKeymapFolder = file;
        if (!file.isDirectory()) {
            Log.log(9, this, "System keymap folder do not exist, your installation is broken. Install keymaps in " + file.getAbsolutePath());
            JOptionPane.showMessageDialog(null, "System keymap folder do not exist, your installation is broken. Install keymaps in " + file.getAbsolutePath(), "Fatal Error", 0);
            System.exit(10);
        }
        userKeymapFolder = file2;
    }

    @Override
    public Keymap getKeymap() {
        return this.currentKeymap;
    }

    @Override
    public Collection<String> getKeymapNames() {
        Collection<String> collection = KeymapManagerImpl.getKeymapsFromFolder(this.systemKeymapFolder);
        Collection<String> collection2 = KeymapManagerImpl.getKeymapsFromFolder(userKeymapFolder);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(collection);
        hashSet.addAll(collection2);
        return hashSet;
    }

    @Override
    public Keymap getKeymap(String string) {
        File file = this.getKeymapFile(string);
        KeymapImpl keymapImpl = null;
        if (file.isFile()) {
            keymapImpl = new KeymapImpl(string, file);
        }
        return keymapImpl;
    }

    @Override
    public KeymapManager.State getKeymapState(String string) {
        File file = this.getSystemKeymapFile(string);
        File file2 = KeymapManagerImpl.getUserKeymapFile(string);
        if (file2.isFile()) {
            if (file.isFile()) {
                return KeymapManager.State.SystemModified;
            }
            return KeymapManager.State.User;
        }
        if (file.isFile()) {
            return KeymapManager.State.System;
        }
        return KeymapManager.State.Unknown;
    }

    @Override
    public void resetKeymap(String string) {
        KeymapManager.State state = this.getKeymapState(string);
        if (state == KeymapManager.State.SystemModified) {
            File file = KeymapManagerImpl.getUserKeymapFile(string);
            file.delete();
        }
    }

    @Override
    public void deleteUserKeymap(String string) {
        KeymapManager.State state = this.getKeymapState(string);
        if (state == KeymapManager.State.User) {
            File file = KeymapManagerImpl.getUserKeymapFile(string);
            file.delete();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean copyKeymap(String string, String string2) {
        Log.log(1, this, "copyKeymap(" + string + "," + string2 + ")");
        File file = KeymapManagerImpl.getUserKeymapFile(string2);
        if (file.exists()) {
            throw new IllegalArgumentException("Keymap " + string2 + " already exists");
        }
        File file2 = this.getKeymapFile(string);
        if (!file2.isFile()) {
            throw new IllegalArgumentException("Keymap " + string + " doesn't exist");
        }
        file.getParentFile().mkdirs();
        Log.log(1, this, "Copying " + file2.getAbsolutePath() + " to " + file.getAbsolutePath());
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));){
            boolean bl;
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));){
                IOUtilities.copyStream(null, bufferedInputStream, bufferedOutputStream, false);
                bl = true;
            }
            return bl;
        }
        catch (IOException iOException) {
            Log.log(9, this, iOException);
            return false;
        }
    }

    @Override
    public void reload() {
        String string = this.getCurrentKeymapName();
        this.currentKeymap = this.getKeymap(string);
        if (this.currentKeymap == null) {
            this.currentKeymap = this.getKeymap("jEdit");
        }
    }

    private File getKeymapFile(String string) {
        File file = KeymapManagerImpl.getUserKeymapFile(string);
        if (!file.isFile()) {
            file = this.getSystemKeymapFile(string);
        }
        return file;
    }

    static File getUserKeymapFile(String string) {
        return new File(userKeymapFolder, string + "_keys.props");
    }

    private File getSystemKeymapFile(String string) {
        return new File(this.systemKeymapFolder, string + "_keys.props");
    }

    private static Collection<String> getKeymapsFromFolder(File file) {
        if (file == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = file.listFiles(new KeymapFileFilter());
        if (fileArray != null) {
            for (File file2 : fileArray) {
                String string = file2.getName();
                String string2 = string.substring(0, string.length() - 11);
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    private String getCurrentKeymapName() {
        return this.propertyManager.getProperty("keymap.current");
    }
}

