/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.util.List;
import java.util.Vector;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.ui.IContextMenuProvider;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

public class OffRoadPopupMenuListener
implements PopupMenuListener {
    private JPopupMenu mMenu;
    private Vector<JMenuItem> items = new Vector();
    private OsmWindow mContext;

    public OffRoadPopupMenuListener(OsmWindow pContext, JPopupMenu pMenu) {
        this.mContext = pContext;
        this.mMenu = pMenu;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent pE) {
        this.items.clear();
        RotatedTileBox tileBox = this.getDrawPanel().copyCurrentTileBox();
        List<OsmandMapLayer> layers = this.getDrawPanel().getLayers();
        for (OsmandMapLayer layer : layers) {
            if (!(layer instanceof IContextMenuProvider)) continue;
            IContextMenuProvider provider = (IContextMenuProvider)((Object)layer);
            Vector<Object> res = new Vector<Object>();
            provider.collectObjectsFromPoint(this.getDrawPanel().getMousePosition(), tileBox, res);
            for (Object e : res) {
                List<JMenuItem> actionsForObject = this.mContext.getContextActionsForObject(provider, e);
                for (JMenuItem item : actionsForObject) {
                    this.items.add(item);
                    this.mMenu.add(item);
                }
            }
        }
    }

    OsmBitmapPanel getDrawPanel() {
        return this.mContext.getDrawPanel();
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent pE) {
        for (JMenuItem jMenuItem : this.items) {
            this.mMenu.remove(jMenuItem);
        }
        this.items.clear();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent pE) {
        this.popupMenuWillBecomeInvisible(pE);
    }
}

