/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology;

import java.awt.BorderLayout;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.view.AbstractOWLViewComponent;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveOntologyView
extends AbstractOWLViewComponent {
    private final Logger logger = LoggerFactory.getLogger(ActiveOntologyView.class);
    private JComboBox ontologiesList;
    private OWLModelManagerListener owlModelManagerListener = event -> {
        if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
            this.updateList();
        }
    };
    private final OWLOntologyChangeListener ontologyChangedListener = owlOntologyChanges -> this.handleOntologyChanges(owlOntologyChanges);

    private void updateList() {
        this.ontologiesList.setSelectedItem(this.getOWLModelManager().getActiveOntology());
        this.ontologiesList.setRenderer(this.ontologiesList.getRenderer());
    }

    @Override
    public void disposeOWLView() {
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
    }

    @Override
    public void initialiseOWLView() throws Exception {
        this.setLayout(new BorderLayout());
        this.ontologiesList = new JComboBox();
        this.ontologiesList.addActionListener(e -> {
            OWLOntology ont = (OWLOntology)this.ontologiesList.getSelectedItem();
            if (ont != null) {
                this.getOWLModelManager().setActiveOntology(ont);
            }
        });
        this.add(this.ontologiesList);
        this.getOWLModelManager().addListener(this.owlModelManagerListener);
        this.getOWLModelManager().addOntologyChangeListener(this.ontologyChangedListener);
        this.rebuildList();
    }

    private void handleOntologyChanges(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof SetOntologyID)) continue;
            this.updateList();
            break;
        }
    }

    private void rebuildList() {
        try {
            this.ontologiesList.setModel(new DefaultComboBoxModel<Object>(this.getOWLModelManager().getOntologies().toArray()));
            this.updateList();
        }
        catch (Exception e) {
            this.logger.error("An error occurred when rebuilding the list of active ontologies.", (Throwable)e);
        }
    }
}

