/* This file is part of the libopencm3 project.
 *
 * It was generated by the irq2nvic_h script from ./include/libopencm3/stm32/g4/irq.json
 */

#ifndef LIBOPENCM3_STM32_G4_NVIC_H
#define LIBOPENCM3_STM32_G4_NVIC_H

#include <libopencm3/cm3/nvic.h>

/** @defgroup CM3_nvic_defines_irqs User interrupts for STM32 G4 series
    @ingroup CM3_nvic_defines

    @{*/

#define NVIC_WWDG_IRQ 0
#define NVIC_PVD_IRQ 1
#define NVIC_RTC_TAMP_CSS_IRQ 2
#define NVIC_RTC_WKUP_IRQ 3
#define NVIC_FLASH_IRQ 4
#define NVIC_RCC_IRQ 5
#define NVIC_EXTI0_IRQ 6
#define NVIC_EXTI1_IRQ 7
#define NVIC_EXTI2_IRQ 8
#define NVIC_EXTI3_IRQ 9
#define NVIC_EXTI4_IRQ 10
#define NVIC_DMA1_CHANNEL1_IRQ 11
#define NVIC_DMA1_CHANNEL2_IRQ 12
#define NVIC_DMA1_CHANNEL3_IRQ 13
#define NVIC_DMA1_CHANNEL4_IRQ 14
#define NVIC_DMA1_CHANNEL5_IRQ 15
#define NVIC_DMA1_CHANNEL6_IRQ 16
#define NVIC_DMA1_CHANNEL7_IRQ 17
#define NVIC_ADC12_IRQ 18
#define NVIC_USB_HP_IRQ 19
#define NVIC_USB_LP_IRQ 20
#define NVIC_FDCAN1_INTR1_IRQ 21
#define NVIC_FDCAN1_INTR0_IRQ 22
#define NVIC_EXTI9_5_IRQ 23
#define NVIC_TIM1_BRK_TIM15_IRQ 24
#define NVIC_TIM1_UP_TIM16_IRQ 25
#define NVIC_TIM1_TRG_TIM17_IRQ 26
#define NVIC_TIM1_CC_IRQ 27
#define NVIC_TIM2_IRQ 28
#define NVIC_TIM3_IRQ 29
#define NVIC_TIM4_IRQ 30
#define NVIC_I2C1_EV_IRQ 31
#define NVIC_I2C1_ER_IRQ 32
#define NVIC_I2C2_EV_IRQ 33
#define NVIC_I2C2_ER_IRQ 34
#define NVIC_SPI1_IRQ 35
#define NVIC_SPI2_IRQ 36
#define NVIC_USART1_IRQ 37
#define NVIC_USART2_IRQ 38
#define NVIC_USART3_IRQ 39
#define NVIC_EXTI15_10_IRQ 40
#define NVIC_RTC_ALARM_IRQ 41
#define NVIC_USB_WAKEUP_IRQ 42
#define NVIC_TIM8_BRK_IRQ 43
#define NVIC_TIM8_UP_IRQ 44
#define NVIC_TIM8_TRG_IRQ 45
#define NVIC_TIM8_CC_IRQ 46
#define NVIC_ADC3_IRQ 47
#define NVIC_FSMC_IRQ 48
#define NVIC_LPTIM1_IRQ 49
#define NVIC_TIM5_IRQ 50
#define NVIC_SPI3_IRQ 51
#define NVIC_UART4_IRQ 52
#define NVIC_UART5_IRQ 53
#define NVIC_TIM6_DAC13UNDER_IRQ 54
#define NVIC_TIM7_DAC24UNDER_IRQ 55
#define NVIC_DMA2_CHANNEL1_IRQ 56
#define NVIC_DMA2_CHANNEL2_IRQ 57
#define NVIC_DMA2_CHANNEL3_IRQ 58
#define NVIC_DMA2_CHANNEL4_IRQ 59
#define NVIC_DMA2_CHANNEL5_IRQ 60
#define NVIC_ADC4_IRQ 61
#define NVIC_ADC5_IRQ 62
#define NVIC_UCPD1_IRQ 63
#define NVIC_COMP123_IRQ 64
#define NVIC_COMP456_IRQ 65
#define NVIC_COMP7_IRQ 66
#define NVIC_HRTIM_MASTER_IRQ 67
#define NVIC_HRTIM_TIMA_IRQ 68
#define NVIC_HRTIM_TIMB_IRQ 69
#define NVIC_HRTIM_TIMC_IRQ 70
#define NVIC_HRTIM_TIMD_IRQ 71
#define NVIC_HRTIM_TIME_IRQ 72
#define NVIC_HRTIM_FAULT_IRQ 73
#define NVIC_HRTIM_TIMF_IRQ 74
#define NVIC_CRS_IRQ 75
#define NVIC_SAI_IRQ 76
#define NVIC_TIM20_BRK_IRQ 77
#define NVIC_TIM20_UP_IRQ 78
#define NVIC_TIM20_TRG_IRQ 79
#define NVIC_TIM20_CC_IRQ 80
#define NVIC_FPU_IRQ 81
#define NVIC_I2C4_EV_IRQ 82
#define NVIC_I2C4_ER_IRQ 83
#define NVIC_SPI4_IRQ 84
#define NVIC_AES_IRQ 85
#define NVIC_FDCAN2_INTR0_IRQ 86
#define NVIC_FDCAN2_INTR1_IRQ 87
#define NVIC_FDCAN3_INTR0_IRQ 88
#define NVIC_FDCAN3_INTR1_IRQ 89
#define NVIC_RNG_IRQ 90
#define NVIC_LPUART_IRQ 91
#define NVIC_I2C3_EV_IRQ 92
#define NVIC_I2C3_ER_IRQ 93
#define NVIC_DMAMUX_OVR_IRQ 94
#define NVIC_QUADSPI_IRQ 95
#define NVIC_DMA1_CHANNEL8_IRQ 96
#define NVIC_DMA2_CHANNEL6_IRQ 97
#define NVIC_DMA2_CHANNEL7_IRQ 98
#define NVIC_DMA2_CHANNEL8_IRQ 99
#define NVIC_CORDIC_IRQ 100
#define NVIC_FMAC_IRQ 101

#define NVIC_IRQ_COUNT 102

/**@}*/

/** @defgroup CM3_nvic_isrprototypes_STM32G4 User interrupt service routines (ISR) prototypes for STM32 G4 series
    @ingroup CM3_nvic_isrprototypes

    @{*/

BEGIN_DECLS

void wwdg_isr(void);
void pvd_isr(void);
void rtc_tamp_css_isr(void);
void rtc_wkup_isr(void);
void flash_isr(void);
void rcc_isr(void);
void exti0_isr(void);
void exti1_isr(void);
void exti2_isr(void);
void exti3_isr(void);
void exti4_isr(void);
void dma1_channel1_isr(void);
void dma1_channel2_isr(void);
void dma1_channel3_isr(void);
void dma1_channel4_isr(void);
void dma1_channel5_isr(void);
void dma1_channel6_isr(void);
void dma1_channel7_isr(void);
void adc12_isr(void);
void usb_hp_isr(void);
void usb_lp_isr(void);
void fdcan1_intr1_isr(void);
void fdcan1_intr0_isr(void);
void exti9_5_isr(void);
void tim1_brk_tim15_isr(void);
void tim1_up_tim16_isr(void);
void tim1_trg_tim17_isr(void);
void tim1_cc_isr(void);
void tim2_isr(void);
void tim3_isr(void);
void tim4_isr(void);
void i2c1_ev_isr(void);
void i2c1_er_isr(void);
void i2c2_ev_isr(void);
void i2c2_er_isr(void);
void spi1_isr(void);
void spi2_isr(void);
void usart1_isr(void);
void usart2_isr(void);
void usart3_isr(void);
void exti15_10_isr(void);
void rtc_alarm_isr(void);
void usb_wakeup_isr(void);
void tim8_brk_isr(void);
void tim8_up_isr(void);
void tim8_trg_isr(void);
void tim8_cc_isr(void);
void adc3_isr(void);
void fsmc_isr(void);
void lptim1_isr(void);
void tim5_isr(void);
void spi3_isr(void);
void uart4_isr(void);
void uart5_isr(void);
void tim6_dac13under_isr(void);
void tim7_dac24under_isr(void);
void dma2_channel1_isr(void);
void dma2_channel2_isr(void);
void dma2_channel3_isr(void);
void dma2_channel4_isr(void);
void dma2_channel5_isr(void);
void adc4_isr(void);
void adc5_isr(void);
void ucpd1_isr(void);
void comp123_isr(void);
void comp456_isr(void);
void comp7_isr(void);
void hrtim_master_isr(void);
void hrtim_tima_isr(void);
void hrtim_timb_isr(void);
void hrtim_timc_isr(void);
void hrtim_timd_isr(void);
void hrtim_time_isr(void);
void hrtim_fault_isr(void);
void hrtim_timf_isr(void);
void crs_isr(void);
void sai_isr(void);
void tim20_brk_isr(void);
void tim20_up_isr(void);
void tim20_trg_isr(void);
void tim20_cc_isr(void);
void fpu_isr(void);
void i2c4_ev_isr(void);
void i2c4_er_isr(void);
void spi4_isr(void);
void aes_isr(void);
void fdcan2_intr0_isr(void);
void fdcan2_intr1_isr(void);
void fdcan3_intr0_isr(void);
void fdcan3_intr1_isr(void);
void rng_isr(void);
void lpuart_isr(void);
void i2c3_ev_isr(void);
void i2c3_er_isr(void);
void dmamux_ovr_isr(void);
void quadspi_isr(void);
void dma1_channel8_isr(void);
void dma2_channel6_isr(void);
void dma2_channel7_isr(void);
void dma2_channel8_isr(void);
void cordic_isr(void);
void fmac_isr(void);

END_DECLS

/**@}*/

#endif /* LIBOPENCM3_STM32_G4_NVIC_H */
