# Copyright (C) 2002,2004 Stichting LogReport Foundation logreport@logreport.org

# This file is part of Lire.

# Lire is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program (see COPYING); if not, check with
# http://www.gnu.org/copyleft/gpl.html.

# Authors:
#     Wessel Dankers <wsl@logreport.org>
#     Francis J. Lacoste <flacoste@logreport.org>

package Lire::DlfAnalysers::SheetsCategoriser;

use strict;

use base qw/Lire::DlfCategoriser/;

use Carp;

sub new {
    return bless {}, shift;
}

sub name {
    return "sheets";
}

sub title {
    return "Print Sheets DlfAnalyser";
}

sub description {
    return '<para>This categoriser computes the <structfield>num_sheets</structfield> field from the <structfield>ncopies</structfield> 
and <structfield>npages</structfield> fields.</para>';
}

sub src_schema {
    return "print";
}

sub dst_schema {
    return "print-sheets";
}

sub initialise {
    my ( $self, $config ) = @_;

    return;
}

sub categorise {
    my ( $self, $dlf ) = @_;

    return unless defined $dlf->{'num_pages'};
    my $copies = $dlf->{'num_copies'} || 1;

    $dlf->{'num_sheets'} = $copies * $dlf->{'num_pages'};

    return;
}

# keep perl happy
1;
