/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.krss2.renderer;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.krss2.renderer.KRSS2Vocabulary;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.search.EntitySearcher;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.search.Searcher;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class KRSS2OWLObjectRenderer
extends OWLObjectVisitorAdapter {
    @Nonnull
    private final Writer writer;

    public KRSS2OWLObjectRenderer(@Nonnull Writer writer) {
        this.writer = OWLAPIPreconditions.checkNotNull(writer);
    }

    private void writeOpenBracket() {
        try {
            this.writer.write("(");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void writeCloseBracket() {
        try {
            this.writer.write(")");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(int i) {
        try {
            this.writer.write(" " + i);
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(@Nonnull IRI iri) {
        try {
            this.writer.write(iri.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void writeAttribute(KRSS2Vocabulary v) {
        try {
            this.writeSpace();
            this.writer.write(":");
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(KRSS2Vocabulary v) {
        try {
            this.writer.write(v.toString());
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void writeSpace() {
        try {
            this.writer.write(" ");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void writeln() {
        try {
            this.writer.write("\n");
        }
        catch (IOException e) {
            throw new OWLRuntimeException(e);
        }
    }

    private void write(OWLClassExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    private void write(OWLIndividual ind) {
        this.writeSpace();
        ind.accept(this);
    }

    private void write(OWLPropertyExpression obj) {
        this.writeSpace();
        obj.accept(this);
    }

    private void write(OWLDataRange obj) {
        this.writeSpace();
        obj.accept(this);
    }

    private void flatten(Collection<OWLClassExpression> inputClassExpressions) {
        ArrayList<OWLClassExpression> classExpressions = inputClassExpressions instanceof List ? (ArrayList<OWLClassExpression>)inputClassExpressions : new ArrayList<OWLClassExpression>(inputClassExpressions);
        if (classExpressions.isEmpty()) {
            return;
        }
        OWLClassExpression desc = (OWLClassExpression)classExpressions.iterator().next();
        if (classExpressions.size() == 1) {
            this.write(desc);
            return;
        }
        classExpressions.remove(0);
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        this.write(desc);
        this.flatten(classExpressions);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLOntology ontology) {
        for (OWLClass eachClass : ontology.getClassesInSignature()) {
            boolean primitive;
            assert (eachClass != null);
            boolean bl = primitive = !EntitySearcher.isDefined(eachClass, ontology);
            if (primitive) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_CONCEPT);
                this.write(eachClass);
                this.writeSpace();
                Collection axioms = ontology.filterAxioms(Filters.subClassWithSub, eachClass, Imports.INCLUDED);
                Collection<OWLClassExpression> superClasses = Searcher.sup(axioms, OWLClassExpression.class);
                this.flatten(superClasses);
                this.writeCloseBracket();
                this.writeln();
                Collection<OWLClassExpression> classes = Searcher.equivalent(ontology.getEquivalentClassesAxioms(eachClass), OWLClassExpression.class);
                for (OWLClassExpression classExpression : classes) {
                    this.writeOpenBracket();
                    this.write(eachClass);
                    this.write(KRSS2Vocabulary.EQUIVALENT);
                    this.writeSpace();
                    classExpression.accept(this);
                    this.writeCloseBracket();
                    this.writeln();
                }
                continue;
            }
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_CONCEPT);
            this.write(eachClass);
            Collection<OWLClassExpression> classes = Searcher.equivalent(ontology.getEquivalentClassesAxioms(eachClass), OWLClassExpression.class);
            if (classes.isEmpty()) {
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            if (classes.size() == 1) {
                this.write(classes.iterator().next());
                this.writeCloseBracket();
                this.writeln();
                continue;
            }
            Iterator<OWLClassExpression> iter = classes.iterator();
            this.write(iter.next());
            this.writeCloseBracket();
            this.writeln();
            while (iter.hasNext()) {
                this.writeOpenBracket();
                this.write(KRSS2Vocabulary.EQUIVALENT);
                this.write(eachClass);
                this.writeSpace();
                iter.next().accept(this);
                this.writeCloseBracket();
                this.writeln();
            }
        }
        for (OWLClassAxiom axiom : ontology.getGeneralClassAxioms()) {
            axiom.accept(this);
        }
        for (OWLObjectProperty property : ontology.getObjectPropertiesInSignature()) {
            Collection axioms;
            Collection<OWLObjectPropertyExpression> superProperties;
            Collection<OWLClassExpression> ranges;
            Collection<OWLClassExpression> domains;
            assert (property != null);
            this.writeOpenBracket();
            this.write(KRSS2Vocabulary.DEFINE_PRIMITIVE_ROLE);
            this.write(property);
            if (EntitySearcher.isTransitive((OWLObjectPropertyExpression)property, ontology)) {
                this.writeAttribute(KRSS2Vocabulary.TRANSITIVE_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (EntitySearcher.isSymmetric((OWLObjectPropertyExpression)property, ontology)) {
                this.writeAttribute(KRSS2Vocabulary.SYMMETRIC_ATTR);
                this.writeSpace();
                this.write(KRSS2Vocabulary.TRUE);
            }
            if (!(domains = Searcher.domain(ontology.getObjectPropertyDomainAxioms(property))).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.DOMAIN);
                this.flatten(domains);
            }
            if (!(ranges = Searcher.range(ontology.getObjectPropertyRangeAxioms(property))).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.RANGE_ATTR);
                this.flatten(ranges);
            }
            if (!(superProperties = Searcher.sup(axioms = ontology.filterAxioms(Filters.subObjectPropertyWithSub, property, Imports.INCLUDED), OWLObjectPropertyExpression.class)).isEmpty()) {
                this.writeAttribute(KRSS2Vocabulary.PARENTS_ATTR);
                this.writeOpenBracket();
                for (OWLObjectPropertyExpression express : superProperties) {
                    this.write(express);
                }
                this.writeCloseBracket();
            }
            this.writeCloseBracket();
        }
        try {
            this.writer.flush();
        }
        catch (IOException io) {
            throw new OWLRuntimeException(io);
        }
    }

    @Override
    public void visit(OWLSubClassOfAxiom axiom) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.IMPLIES);
        this.write(axiom.getSubClass());
        this.write(axiom.getSuperClass());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDisjointClassesAxiom axiom) {
        this.writeOpenBracket();
        for (OWLClassExpression desc : axiom.getClassExpressions()) {
            this.write(desc);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.RELATED);
        this.write(axiom.getSubject());
        this.write((OWLIndividual)axiom.getObject());
        this.write((OWLPropertyExpression)axiom.getProperty());
        this.writeln();
    }

    @Override
    public void visit(OWLClassAssertionAxiom axiom) {
        this.write(KRSS2Vocabulary.INSTANCE);
        this.write(axiom.getIndividual());
        this.write(axiom.getClassExpression());
        this.writeln();
    }

    @Override
    public void visit(OWLClass ce) {
        this.write(ce.getIRI());
    }

    @Override
    public void visit(OWLObjectIntersectionOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AND);
        for (OWLClassExpression des : ce.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectUnionOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.OR);
        for (OWLClassExpression des : ce.getOperands()) {
            this.write(des);
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectComplementOf ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.NOT);
        this.write(ce.getOperand());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write(ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write(ce.getProperty());
        this.write((OWLClassExpression)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLClassExpression)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataSomeValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.SOME);
        this.write(ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataAllValuesFrom ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.ALL);
        this.write(ce.getProperty());
        this.write((OWLDataRange)ce.getFiller());
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataMinCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_LEAST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataExactCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.EXACTLY);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataMaxCardinality ce) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.AT_MOST);
        this.write(ce.getCardinality());
        this.write(ce.getProperty());
        if (ce.isQualified()) {
            this.write((OWLDataRange)ce.getFiller());
        }
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLObjectProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(OWLObjectInverseOf property) {
        this.writeOpenBracket();
        this.write(KRSS2Vocabulary.INVERSE);
        this.writeSpace();
        property.getInverse().accept(this);
        this.writeCloseBracket();
    }

    @Override
    public void visit(OWLDataProperty property) {
        this.write(property.getIRI());
    }

    @Override
    public void visit(OWLNamedIndividual individual) {
        this.write(individual.getIRI());
    }
}

