/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.server.control.ChangeSet;

public class ServerRegion
extends Region {
    public static final int PACIFIC_SCORE_VALUE = 100;
    private int size = 0;
    private Rectangle bounds = new Rectangle();

    public ServerRegion(Game game, String id) {
        super(game, id);
    }

    public ServerRegion(Game game, Region region) {
        super(game);
        this.name = region.getName();
        this.key = region.getKey();
        this.type = region.getType();
        this.parent = null;
        this.claimable = region.getClaimable();
        this.discoverable = region.getDiscoverable();
        this.discoveredIn = region.getDiscoveredIn();
        this.discoveredBy = region.getDiscoveredBy();
        this.scoreValue = region.getScoreValue();
    }

    public ServerRegion(Game game, Region.RegionType type) {
        this(game, null, type, null);
        this.setClaimable(type.getClaimable());
        this.setDiscoverable(true);
    }

    private ServerRegion(net.sf.freecol.common.model.Map map, String key, Region.RegionType type, Region parent) {
        this(map.getGame(), key, type, parent);
        map.addRegion(this);
    }

    private ServerRegion(Game game, String key, Region.RegionType type, Region parent) {
        super(game);
        this.key = key;
        this.name = null;
        this.type = type;
        this.parent = parent;
        if (this.parent != null) {
            this.parent.addChild(this);
        }
        this.claimable = false;
        this.discoverable = false;
        this.discoveredIn = null;
        this.discoveredBy = null;
        this.scoreValue = 0;
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int size) {
        this.size = size;
    }

    public final Rectangle getBounds() {
        return this.bounds;
    }

    public final boolean isGeographic() {
        return this.key != null && this.type == Region.RegionType.LAND;
    }

    public int[] getCenter() {
        return new int[]{this.bounds.x + this.bounds.width / 2, this.bounds.y + this.bounds.height / 2};
    }

    public boolean containsCenter(ServerRegion other) {
        int[] xy = other.getCenter();
        return this.bounds.contains(xy[0], xy[1]);
    }

    public void addTile(Tile tile) {
        tile.setRegion(this);
        ++this.size;
        if (this.bounds.x == 0 && this.bounds.width == 0 || this.bounds.y == 0 && this.bounds.height == 0) {
            this.bounds.setBounds(tile.getX(), tile.getY(), 0, 0);
        } else {
            this.bounds.add(tile.getX(), tile.getY());
        }
    }

    public void csDiscover(Player player, Turn turn, String newName, ChangeSet cs) {
        int score;
        if (!this.getDiscoverable()) {
            return;
        }
        int n = score = this.getSpecification().getBoolean("model.option.explorationPoints") ? this.scoreValue : 0;
        if (!this.hasName()) {
            this.name = newName;
        }
        for (Region r : this.discover(player, turn)) {
            cs.add(ChangeSet.See.all(), r);
        }
        HistoryEvent h = new HistoryEvent(turn, HistoryEvent.HistoryEventType.DISCOVER_REGION, player).addStringTemplate("%nation%", player.getNationLabel()).addName("%region%", newName);
        h.setScore(score);
        cs.addGlobalHistory(this.getGame(), h);
        this.setDiscoverer(null);
    }

    public static List<ServerRegion> requireFixedRegions(net.sf.freecol.common.model.Map map, LogBuilder lb) {
        Game game = map.getGame();
        Map<String, Region> fixed = map.getFixedRegions();
        ArrayList<ServerRegion> result = new ArrayList<ServerRegion>();
        lb.add("Add regions ");
        int arcticHeight = 2;
        ServerRegion arctic = (ServerRegion)fixed.get("model.region.arctic");
        if (arctic == null) {
            arctic = new ServerRegion(map, "model.region.arctic", Region.RegionType.LAND, null);
            for (int x = 0; x < map.getWidth(); ++x) {
                for (int y = 0; y < 2; ++y) {
                    Tile tile;
                    if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                    arctic.addTile(tile);
                }
            }
            lb.add("+arctic");
        }
        result.add(arctic);
        int antarcticHeight = map.getHeight() - 2 - 1;
        ServerRegion antarctic = (ServerRegion)fixed.get("model.region.antarctic");
        if (antarctic == null) {
            antarctic = new ServerRegion(map, "model.region.antarctic", Region.RegionType.LAND, null);
            for (int x = 0; x < map.getWidth(); ++x) {
                for (int y = antarcticHeight; y < map.getHeight(); ++y) {
                    Tile tile;
                    if (!map.isValid(x, y) || !(tile = map.getTile(x, y)).isLand()) continue;
                    antarctic.addTile(tile);
                }
            }
            lb.add("+antarctic");
        }
        result.add(antarctic);
        int thirdWidth = map.getWidth() / 3;
        int twoThirdWidth = 2 * thirdWidth;
        int thirdHeight = map.getHeight() / 3;
        int twoThirdHeight = 2 * thirdHeight;
        ServerRegion northWest = (ServerRegion)fixed.get("model.region.northWest");
        if (northWest == null) {
            northWest = new ServerRegion(map, "model.region.northWest", Region.RegionType.LAND, null);
            northWest.bounds.setBounds(new Rectangle(0, 0, thirdWidth, thirdHeight));
            lb.add("+NW");
        }
        result.add(northWest);
        ServerRegion north = (ServerRegion)fixed.get("model.region.north");
        if (north == null) {
            north = new ServerRegion(map, "model.region.north", Region.RegionType.LAND, null);
            north.bounds.setBounds(new Rectangle(thirdWidth, 0, thirdWidth, thirdHeight));
            lb.add("+N");
        }
        result.add(north);
        ServerRegion northEast = (ServerRegion)fixed.get("model.region.northEast");
        if (northEast == null) {
            northEast = new ServerRegion(map, "model.region.northEast", Region.RegionType.LAND, null);
            northEast.bounds.setBounds(new Rectangle(twoThirdWidth, 0, thirdWidth, thirdHeight));
            lb.add("+NE");
        }
        result.add(northEast);
        ServerRegion west = (ServerRegion)fixed.get("model.region.west");
        if (west == null) {
            west = new ServerRegion(map, "model.region.west", Region.RegionType.LAND, null);
            west.bounds.setBounds(new Rectangle(0, thirdHeight, thirdWidth, thirdHeight));
            lb.add("+W");
        }
        result.add(west);
        ServerRegion center = (ServerRegion)fixed.get("model.region.center");
        if (center == null) {
            center = new ServerRegion(map, "model.region.center", Region.RegionType.LAND, null);
            center.bounds.setBounds(new Rectangle(thirdWidth, thirdHeight, thirdWidth, thirdHeight));
            lb.add("+center");
        }
        result.add(center);
        ServerRegion east = (ServerRegion)fixed.get("model.region.east");
        if (east == null) {
            east = new ServerRegion(map, "model.region.east", Region.RegionType.LAND, null);
            east.bounds.setBounds(new Rectangle(twoThirdWidth, thirdHeight, thirdWidth, thirdHeight));
            lb.add("+E");
        }
        result.add(east);
        ServerRegion southWest = (ServerRegion)fixed.get("model.region.southWest");
        if (southWest == null) {
            southWest = new ServerRegion(map, "model.region.southWest", Region.RegionType.LAND, null);
            southWest.bounds.setBounds(new Rectangle(0, twoThirdHeight, thirdWidth, thirdHeight));
            lb.add("+SW");
        }
        result.add(southWest);
        ServerRegion south = (ServerRegion)fixed.get("model.region.south");
        if (south == null) {
            south = new ServerRegion(map, "model.region.south", Region.RegionType.LAND, null);
            south.bounds.setBounds(new Rectangle(thirdWidth, twoThirdHeight, thirdWidth, thirdHeight));
            lb.add("+S");
        }
        result.add(south);
        ServerRegion southEast = (ServerRegion)fixed.get("model.region.southEast");
        if (southEast == null) {
            southEast = new ServerRegion(map, "model.region.southEast", Region.RegionType.LAND, null);
            southEast.bounds.setBounds(new Rectangle(twoThirdWidth, twoThirdHeight, thirdWidth, thirdHeight));
            lb.add("+SE");
        }
        result.add(southEast);
        boolean allOceans = true;
        ServerRegion pacific = (ServerRegion)fixed.get("model.region.pacific");
        if (pacific == null) {
            pacific = new ServerRegion(map, "model.region.pacific", Region.RegionType.OCEAN, null);
            pacific.setDiscoverable(true);
            pacific.setScoreValue(100);
            allOceans = false;
            lb.add("+pacific");
        }
        result.add(pacific);
        ServerRegion northPacific = (ServerRegion)fixed.get("model.region.northPacific");
        if (northPacific == null) {
            northPacific = new ServerRegion(map, "model.region.northPacific", Region.RegionType.OCEAN, (Region)pacific);
            northPacific.setDiscoverable(false);
            allOceans = false;
            lb.add("+northPacific");
        }
        result.add(northPacific);
        ServerRegion southPacific = (ServerRegion)fixed.get("model.region.southPacific");
        if (southPacific == null) {
            southPacific = new ServerRegion(map, "model.region.southPacific", Region.RegionType.OCEAN, (Region)pacific);
            southPacific.setDiscoverable(false);
            allOceans = false;
            lb.add("+southPacific");
        }
        result.add(southPacific);
        ServerRegion atlantic = (ServerRegion)fixed.get("model.region.atlantic");
        if (atlantic == null) {
            atlantic = new ServerRegion(map, "model.region.atlantic", Region.RegionType.OCEAN, null);
            atlantic.setDiscoverable(false);
            allOceans = false;
            lb.add("+atlantic");
        }
        result.add(atlantic);
        ServerRegion northAtlantic = (ServerRegion)fixed.get("model.region.northAtlantic");
        if (northAtlantic == null) {
            northAtlantic = new ServerRegion(map, "model.region.northAtlantic", Region.RegionType.OCEAN, (Region)atlantic);
            northAtlantic.setDiscoverable(false);
            allOceans = false;
            lb.add("+northAtlantic");
        }
        result.add(northAtlantic);
        ServerRegion southAtlantic = (ServerRegion)fixed.get("model.region.southAtlantic");
        if (southAtlantic == null) {
            southAtlantic = new ServerRegion(map, "model.region.southAtlantic", Region.RegionType.OCEAN, (Region)atlantic);
            southAtlantic.setDiscoverable(false);
            allOceans = false;
            lb.add("+southAtlantic");
        }
        result.add(southAtlantic);
        if (!allOceans) {
            Tile t;
            int y;
            int maxx = map.getWidth();
            int midx = maxx / 2;
            int maxy = map.getHeight();
            int midy = maxy / 2;
            Tile tNP = null;
            Tile tSP = null;
            Tile tNA = null;
            Tile tSA = null;
            for (y = midy - 1; y >= 0; --y) {
                if (tNP == null && !(t = map.getTile(0, y)).isLand()) {
                    tNP = t;
                }
                if (tNA == null && !(t = map.getTile(maxx - 1, y)).isLand()) {
                    tNA = t;
                }
                if (tNP != null && tNA != null) break;
            }
            for (y = midy; y < maxy; ++y) {
                if (tSP == null && !(t = map.getTile(0, y)).isLand()) {
                    tSP = t;
                }
                if (tSA == null && !(t = map.getTile(maxx - 1, y)).isLand()) {
                    tSA = t;
                }
                if (tSP != null && tSA != null) break;
            }
            int nNP = 0;
            int nSP = 0;
            int nNA = 0;
            int nSA = 0;
            Rectangle rNP = new Rectangle(0, 0, midx, midy);
            Rectangle rSP = new Rectangle(0, midy, midx, maxy - midy);
            Rectangle rNA = new Rectangle(midx, 0, maxx - midx, midy);
            Rectangle rSA = new Rectangle(midx, midy, maxx - midx, maxy - midy);
            if (tNP != null) {
                nNP += ServerRegion.fillOcean(map, tNP, northPacific, rNP);
            }
            if (tSP != null) {
                nSP += ServerRegion.fillOcean(map, tSP, southPacific, rSP);
            }
            if (tNA != null) {
                nNA += ServerRegion.fillOcean(map, tNA, northAtlantic, rNA);
            }
            if (tSA != null) {
                nSA += ServerRegion.fillOcean(map, tSA, southAtlantic, rSA);
            }
            Rectangle rN = new Rectangle(0, 0, maxx, midy);
            Rectangle rS = new Rectangle(0, midy, maxx, maxy - midy);
            if (tNP != null) {
                nNP += ServerRegion.fillOcean(map, tNP, northPacific, rN);
            }
            if (tSP != null) {
                nSP += ServerRegion.fillOcean(map, tSP, southPacific, rS);
            }
            if (tNA != null) {
                nNA += ServerRegion.fillOcean(map, tNA, northAtlantic, rN);
            }
            if (tSA != null) {
                nSA += ServerRegion.fillOcean(map, tSA, southAtlantic, rS);
            }
            Rectangle rAll = new Rectangle(0, 0, maxx, maxy);
            if (tNP != null) {
                nNP += ServerRegion.fillOcean(map, tNP, northPacific, rAll);
            }
            if (tSP != null) {
                nSP += ServerRegion.fillOcean(map, tSP, southPacific, rAll);
            }
            if (tNA != null) {
                nNA += ServerRegion.fillOcean(map, tNA, northAtlantic, rAll);
            }
            if (tSA != null) {
                nSA += ServerRegion.fillOcean(map, tSA, southAtlantic, rAll);
            }
            lb.add(" filled ocean regions ", nNP, " North Pacific, ", nSP, " South Pacific, ", nNA, " North Atlantic, ", nSP, " South Atlantic.\n");
        }
        return result;
    }

    private static int fillOcean(net.sf.freecol.common.model.Map map, Tile tile, ServerRegion region, Rectangle bounds) {
        LinkedList<Tile> q = new LinkedList<Tile>();
        int n = 0;
        boolean[][] visited = new boolean[map.getWidth()][map.getHeight()];
        visited[tile.getX()][tile.getY()] = true;
        q.add(tile);
        while ((tile = (Tile)q.poll()) != null) {
            region.addTile(tile);
            ++n;
            for (Direction direction : Direction.values()) {
                Tile t = map.getAdjacentTile(tile, direction);
                if (t == null || visited[t.getX()][t.getY()] || !bounds.contains(t.getX(), t.getY())) continue;
                visited[t.getX()][t.getY()] = true;
                if (t.getRegion() != null && t.getRegion() != region || t.isLand()) continue;
                q.add(t);
            }
        }
        return n;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(super.toString());
        sb.setLength(sb.length() - 1);
        sb.append(" ").append(this.size).append(" ").append(this.bounds).append("]");
        return sb.toString();
    }
}

