/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.core.codegen.CodeWriter;
import jadx.core.dex.nodes.RootNode;
import jadx.core.dex.visitors.RenameVisitor;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.IndexJob;
import jadx.gui.settings.JadxSettings;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JPackage;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.TabbedPane;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.CodePanel;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameDialog
extends JDialog {
    private static final long serialVersionUID = -3269715644416902410L;
    private static final Logger LOG = LoggerFactory.getLogger(RenameDialog.class);
    private final transient MainWindow mainWindow;
    private final transient CacheObject cache;
    private final transient JNode node;
    private transient JTextField renameField;

    public RenameDialog(MainWindow mainWindow, JNode node) {
        super(mainWindow);
        this.mainWindow = mainWindow;
        this.cache = mainWindow.getCacheObject();
        this.node = node;
        if (this.checkSettings()) {
            this.initUI();
        }
    }

    private boolean checkSettings() {
        StringBuilder errorMessage = new StringBuilder();
        errorMessage.append(NLS.str("msg.rename_disabled")).append(CodeWriter.NL);
        JadxSettings settings = this.mainWindow.getSettings();
        boolean valid = true;
        if (!settings.isDeobfuscationOn()) {
            errorMessage.append(" - ").append(NLS.str("msg.rename_disabled_deobfuscation_disabled")).append(CodeWriter.NL);
            valid = false;
        }
        if (settings.isDeobfuscationForceSave()) {
            errorMessage.append(" - ").append(NLS.str("msg.rename_disabled_force_rewrite_enabled")).append(CodeWriter.NL);
            valid = false;
        }
        if (valid) {
            return true;
        }
        int result = JOptionPane.showConfirmDialog(this.mainWindow, errorMessage.toString(), NLS.str("msg.rename_disabled_title"), 2);
        if (result != 0) {
            return false;
        }
        settings.setDeobfuscationOn(true);
        settings.setDeobfuscationForceSave(false);
        settings.sync();
        this.mainWindow.reOpenFile();
        return false;
    }

    private Path getDeobfMapPath(RootNode root) {
        List<File> inputFiles = root.getArgs().getInputFiles();
        if (inputFiles.isEmpty()) {
            return null;
        }
        File firstInputFile = inputFiles.get(0);
        Path inputFilePath = firstInputFile.getAbsoluteFile().toPath();
        String inputName = inputFilePath.getFileName().toString();
        String baseName = inputName.substring(0, inputName.lastIndexOf(46));
        return inputFilePath.getParent().resolve(baseName + ".jobf");
    }

    private String getNodeAlias(String renameText) {
        String type = "";
        String id = "";
        if (this.node instanceof JMethod) {
            JavaMethod javaMethod = (JavaMethod)this.node.getJavaNode();
            type = "m";
            id = javaMethod.getMethodNode().getMethodInfo().getRawFullId();
        } else if (this.node instanceof JField) {
            JavaField javaField = (JavaField)this.node.getJavaNode();
            type = "f";
            id = javaField.getFieldNode().getFieldInfo().getRawFullId();
        } else if (this.node instanceof JClass) {
            JavaClass javaClass = (JavaClass)this.node.getJavaNode();
            type = "c";
            id = javaClass.getRawName();
        } else if (this.node instanceof JPackage) {
            type = "p";
            id = ((JPackage)this.node).getFullName();
        }
        return String.format("%s %s = %s", type, id, renameText);
    }

    private void writeDeobfMapFile(Path deobfMapPath, List<String> deobfMap) throws IOException {
        if (deobfMapPath == null) {
            LOG.error("updateDeobfMapFile(): deobfMapPath is null!");
            return;
        }
        File tmpFile = File.createTempFile("deobf_tmp_", ".txt");
        try (FileOutputStream fileOut = new FileOutputStream(tmpFile);){
            for (String entry : deobfMap) {
                fileOut.write(entry.getBytes(StandardCharsets.UTF_8));
                fileOut.write(System.lineSeparator().getBytes(StandardCharsets.UTF_8));
            }
        }
        File oldMap = File.createTempFile("deobf_bak_", ".txt");
        Files.copy(deobfMapPath, oldMap.toPath(), StandardCopyOption.REPLACE_EXISTING);
        LOG.trace("Copying " + tmpFile.toPath() + " to " + deobfMapPath);
        Files.copy(tmpFile.toPath(), deobfMapPath, StandardCopyOption.REPLACE_EXISTING);
        Files.delete(oldMap.toPath());
        Files.delete(tmpFile.toPath());
    }

    @NotNull
    private List<String> readDeobfMap(Path deobfMapPath) throws IOException {
        return Files.readAllLines(deobfMapPath, StandardCharsets.UTF_8);
    }

    private List<String> updateDeobfMap(List<String> deobfMap, String alias) {
        String id = alias.substring(0, alias.indexOf(61) + 1);
        int i = 0;
        while (i < deobfMap.size()) {
            if (deobfMap.get(i).startsWith(id)) {
                LOG.debug("updateDeobfMap(): Removing entry {}", (Object)deobfMap.get(i));
                deobfMap.remove(i);
                continue;
            }
            ++i;
        }
        LOG.debug("updateDeobfMap(): Placing alias = {}", (Object)alias);
        deobfMap.add(alias);
        return deobfMap;
    }

    private void rename() {
        try {
            String renameText = this.renameField.getText();
            if (renameText == null || renameText.length() == 0) {
                return;
            }
            RootNode root = this.mainWindow.getWrapper().getDecompiler().getRoot();
            if (this.node == null) {
                LOG.error("rename(): rootNode is null!");
                this.dispose();
                return;
            }
            if (!this.refreshDeobfMapFile(renameText, root)) {
                LOG.error("rename(): refreshDeobfMapFile() failed!");
                this.dispose();
                return;
            }
            this.refreshState(root);
        }
        catch (Exception e) {
            LOG.error("Rename failed", (Throwable)e);
        }
        this.dispose();
    }

    private boolean refreshDeobfMapFile(String renameText, RootNode root) {
        List<String> deobfMap;
        Path deobfMapPath = this.getDeobfMapPath(root);
        try {
            deobfMap = this.readDeobfMap(deobfMapPath);
        }
        catch (IOException e) {
            LOG.error("rename(): readDeobfMap() failed");
            return false;
        }
        this.updateDeobfMap(deobfMap, this.getNodeAlias(renameText));
        try {
            this.writeDeobfMapFile(deobfMapPath, deobfMap);
        }
        catch (IOException e) {
            LOG.error("rename(): writeDeobfMap() failed");
            return false;
        }
        return true;
    }

    private void refreshState(RootNode rootNode) {
        RenameVisitor renameVisitor = new RenameVisitor();
        renameVisitor.init(rootNode);
        JNodeCache nodeCache = this.cache.getNodeCache();
        JavaNode javaNode = this.node.getJavaNode();
        ArrayList<JavaNode> toUpdate = new ArrayList<JavaNode>();
        if (javaNode != null) {
            toUpdate.add(javaNode);
            toUpdate.addAll(javaNode.getUseIn());
        } else if (this.node instanceof JPackage) {
            this.processPackage(toUpdate);
        } else {
            throw new JadxRuntimeException("Unexpected node type: " + this.node);
        }
        Set<JClass> updatedTopClasses = toUpdate.stream().map(nodeCache::makeFrom).map(JNode::getRootClass).filter(Objects::nonNull).collect(Collectors.toSet());
        LOG.debug("Classes to update: {}", updatedTopClasses);
        this.refreshTabs(this.mainWindow.getTabbedPane(), updatedTopClasses);
        if (!updatedTopClasses.isEmpty()) {
            this.mainWindow.getBackgroundExecutor().execute("Refreshing", Utils.collectionMap(updatedTopClasses, cls -> () -> this.refreshJClass((JClass)cls)), () -> {
                if (this.node instanceof JPackage) {
                    this.mainWindow.initTree();
                } else {
                    this.mainWindow.reloadTree();
                }
            });
        }
    }

    private void processPackage(List<JavaNode> toUpdate) {
        String rawFullPkg = ((JPackage)this.node).getFullName();
        String rawFullPkgDot = rawFullPkg + ".";
        for (JavaClass cls : this.mainWindow.getWrapper().getClasses()) {
            String clsPkg = cls.getClassNode().getClassInfo().getPackage();
            if (!clsPkg.equals(rawFullPkg) && !clsPkg.startsWith(rawFullPkgDot)) continue;
            toUpdate.add(cls);
            toUpdate.addAll(cls.getUseIn());
        }
    }

    private void refreshJClass(JClass cls) {
        try {
            cls.reload();
            IndexJob.refreshIndex(this.cache, cls.getCls());
        }
        catch (Exception e) {
            LOG.error("Failed to reload class: {}", (Object)cls, (Object)e);
        }
    }

    private void refreshTabs(TabbedPane tabbedPane, Set<JClass> updatedClasses) {
        for (Map.Entry<JNode, ContentPanel> entry : tabbedPane.getOpenTabs().entrySet()) {
            JNode node;
            JClass rootClass;
            ContentPanel contentPanel = entry.getValue();
            if (!(contentPanel instanceof ClassCodeContentPanel) || !updatedClasses.contains(rootClass = (node = entry.getKey()).getRootClass())) continue;
            this.refreshJClass(rootClass);
            ClassCodeContentPanel codePanel = (ClassCodeContentPanel)contentPanel;
            CodePanel javaPanel = codePanel.getJavaCodePanel();
            javaPanel.refresh();
            tabbedPane.refresh(rootClass);
        }
    }

    @NotNull
    protected JPanel initButtonsPanel() {
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        JButton renameBtn = new JButton(NLS.str("popup.rename"));
        renameBtn.addActionListener(event -> this.rename());
        this.getRootPane().setDefaultButton(renameBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(renameBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    private void initUI() {
        JLabel lbl = new JLabel(NLS.str("popup.rename"));
        JLabel nodeLabel = new JLabel(this.node.makeLongStringHtml(), this.node.getIcon(), 2);
        lbl.setLabelFor(nodeLabel);
        this.renameField = new JTextField(40);
        this.renameField.addActionListener(e -> this.rename());
        this.renameField.setText(this.node.getName());
        this.renameField.selectAll();
        new TextStandardActions(this.renameField);
        JPanel renamePane = new JPanel();
        renamePane.setLayout(new FlowLayout(0));
        renamePane.add(lbl);
        renamePane.add(nodeLabel);
        renamePane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel textPane = new JPanel();
        textPane.setLayout(new BoxLayout(textPane, 3));
        textPane.add(Box.createRigidArea(new Dimension(0, 5)));
        textPane.add(this.renameField);
        textPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel buttonPane = this.initButtonsPanel();
        Container contentPane = this.getContentPane();
        contentPane.add((Component)renamePane, "First");
        contentPane.add((Component)textPane, "Center");
        contentPane.add((Component)buttonPane, "Last");
        this.setTitle(NLS.str("popup.rename"));
        if (!this.mainWindow.getSettings().loadWindowPos(this)) {
            this.setSize(800, 80);
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    @Override
    public void dispose() {
        this.mainWindow.getSettings().saveWindowPos(this);
        super.dispose();
    }
}

