/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.Marker;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.RolloverButton;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.msg.EditPaneUpdate;
import org.gjt.sp.jedit.msg.ViewUpdate;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.GenericGUIUtilities;

public class MarkerViewer
extends JPanel
implements ActionListener {
    private final JList<Marker> markerList;
    private final JScrollPane markerListScroller;
    private final View view;
    private final RolloverButton previous;
    private final RolloverButton next;
    private final RolloverButton clear;

    public MarkerViewer(View view) {
        super(new BorderLayout());
        this.view = view;
        Box box = new Box(0);
        box.add(new JLabel(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("markers.label"))));
        box.add(Box.createGlue());
        RolloverButton rolloverButton = new RolloverButton(GUIUtilities.loadIcon("Plus.png"));
        rolloverButton.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("add-marker.label")));
        rolloverButton.addActionListener(this);
        rolloverButton.setActionCommand("add-marker");
        box.add(rolloverButton);
        this.previous = new RolloverButton(GUIUtilities.loadIcon("ArrowL.png"));
        this.previous.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("prev-marker.label")));
        this.previous.addActionListener(this);
        this.previous.setActionCommand("prev-marker");
        box.add(this.previous);
        this.next = new RolloverButton(GUIUtilities.loadIcon("ArrowR.png"));
        this.next.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("next-marker.label")));
        this.next.addActionListener(this);
        this.next.setActionCommand("next-marker");
        box.add(this.next);
        this.clear = new RolloverButton(GUIUtilities.loadIcon("Clear.png"));
        this.clear.setToolTipText(GenericGUIUtilities.prettifyMenuLabel(jEdit.getProperty("remove-all-markers.label")));
        this.clear.addActionListener(this);
        this.clear.setActionCommand("clear");
        box.add(this.clear);
        this.add("North", box);
        this.markerList = new JList();
        this.markerList.setSelectionMode(0);
        this.markerList.setCellRenderer(new Renderer());
        this.markerList.addMouseListener(new MouseHandler());
        this.markerList.addKeyListener(new KeyHandler());
        this.markerListScroller = new JScrollPane(this.markerList);
        this.add("Center", this.markerListScroller);
        this.refreshList();
    }

    @Override
    public boolean requestDefaultFocus() {
        this.markerList.requestFocus();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("clear")) {
            this.view.getBuffer().removeAllMarkers();
        } else if (string.equals("add-marker")) {
            this.view.getEditPane().addMarker();
        } else if (string.equals("next-marker")) {
            this.view.getEditPane().goToNextMarker(false);
            this.updateSelection();
        } else if (string.equals("prev-marker")) {
            this.view.getEditPane().goToPrevMarker(false);
            this.updateSelection();
        }
    }

    @EditBus.EBHandler
    public void handleEditPaneUpdate(EditPaneUpdate editPaneUpdate) {
        if (editPaneUpdate.getEditPane().getView().equals(this.view) && editPaneUpdate.getWhat().equals(EditPaneUpdate.BUFFER_CHANGED)) {
            this.refreshList();
        }
    }

    @EditBus.EBHandler
    public void handleViewUpdate(ViewUpdate viewUpdate) {
        if (viewUpdate.getView().equals(this.view) && viewUpdate.getWhat().equals(ViewUpdate.EDIT_PANE_CHANGED)) {
            this.refreshList();
        }
    }

    @EditBus.EBHandler
    public void handleBufferUpdate(BufferUpdate bufferUpdate) {
        if (this.view.getBuffer().equals(bufferUpdate.getBuffer()) && (bufferUpdate.getWhat().equals(BufferUpdate.MARKERS_CHANGED) || bufferUpdate.getWhat().equals(BufferUpdate.LOADED))) {
            this.refreshList();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        EditBus.addToBus(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        EditBus.removeFromBus(this);
    }

    private void refreshList() {
        Vector<Marker> vector = this.view.getBuffer().getMarkers();
        if (!vector.isEmpty()) {
            this.markerListScroller.setViewportView(this.markerList);
            this.markerList.setListData(vector);
            this.markerList.setEnabled(true);
            this.next.setEnabled(true);
            this.previous.setEnabled(true);
            this.clear.setEnabled(true);
        } else {
            this.markerListScroller.setViewportView(new JLabel(jEdit.getProperty("no-markers.label")));
            this.next.setEnabled(false);
            this.previous.setEnabled(false);
            this.clear.setEnabled(false);
        }
    }

    private void goToSelectedMarker() {
        Marker marker = this.markerList.getSelectedValue();
        if (marker == null) {
            return;
        }
        this.view.getTextArea().setCaretPosition(marker.getPosition());
        this.view.toFront();
        this.view.requestFocus();
        this.view.getTextArea().requestFocus();
    }

    private void updateSelection() {
        ListModel<Marker> listModel = this.markerList.getModel();
        int n = this.view.getTextArea().getCaretLine();
        Buffer buffer = this.view.getBuffer();
        for (int i = 0; i < listModel.getSize(); ++i) {
            Marker marker = listModel.getElementAt(i);
            if (buffer.getLineOfOffset(marker.getPosition()) != n) continue;
            this.markerList.setSelectedIndex(i);
            break;
        }
    }

    class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 32 || keyEvent.getKeyCode() == 10) {
                keyEvent.consume();
                MarkerViewer.this.goToSelectedMarker();
            }
        }
    }

    class MouseHandler
    extends MouseAdapter {
        MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            int n = MarkerViewer.this.markerList.locationToIndex(mouseEvent.getPoint());
            MarkerViewer.this.markerList.setSelectedIndex(n);
            MarkerViewer.this.goToSelectedMarker();
        }
    }

    class Renderer
    extends DefaultListCellRenderer {
        Renderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object instanceof Marker) {
                Marker marker = (Marker)object;
                JEditTextArea jEditTextArea = MarkerViewer.this.view.getTextArea();
                int n2 = jEditTextArea.getLineOfOffset(marker.getPosition());
                String string = MarkerViewer.this.view.getTextArea().getLineText(n2);
                if (string.isEmpty()) {
                    string = jEdit.getProperty("markers.blank-line");
                }
                char c = marker.getShortcut();
                Object object2 = "";
                if (c > '\u0000') {
                    object2 = "[" + c + "]";
                }
                this.setText(n2 + 1 + " " + (String)object2 + ": " + string);
            }
            return this;
        }
    }
}

