/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SpinnerNumberModel;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.JSPrefs;

public class JSVolumeEditorPopup {
    private final JComponent owner;
    private Popup popup = null;
    private final JSpinner spinner = new JSpinner();
    private boolean decibels = false;
    private boolean shouldCommit = true;
    private final Vector<ActionListener> listeners = new Vector();
    private VolumeType volumeType;
    private FocusAdapter focusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (focusEvent.getOppositeComponent() == JSVolumeEditorPopup.this.owner) {
                return;
            }
            JSVolumeEditorPopup.this.commit();
            JSVolumeEditorPopup.this.hide();
        }
    };
    private ActionListener actionListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JSVolumeEditorPopup.this.commit();
            JSVolumeEditorPopup.this.hide();
        }
    };

    public JSVolumeEditorPopup(JComponent jComponent, VolumeType volumeType) {
        String string;
        if (jComponent == null) {
            throw new IllegalArgumentException("owner should be non-null");
        }
        this.owner = jComponent;
        this.volumeType = volumeType;
        Dimension dimension = this.spinner.getPreferredSize();
        dimension.width = 55;
        this.spinner.setPreferredSize(dimension);
        this.setNumberModel();
        switch (volumeType) {
            case MASTER: {
                string = "maximumMasterVolume";
                break;
            }
            case CHANNEL: {
                string = "maximumChannelVolume";
                break;
            }
            default: {
                string = "maximumChannelVolume";
            }
        }
        JSVolumeEditorPopup.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSVolumeEditorPopup.this.setNumberModel();
            }
        });
        string = "volMeasurementUnitDecibel";
        JSVolumeEditorPopup.preferences().addPropertyChangeListener(string, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JSVolumeEditorPopup.this.setNumberModel();
            }
        });
    }

    public void show() {
        if (this.popup != null) {
            this.popup.hide();
        }
        this.shouldCommit = true;
        Point point = this.owner.getLocationOnScreen();
        int n = this.owner.getHeight();
        this.popup = PopupFactory.getSharedInstance().getPopup(this.owner, this.spinner, point.x, point.y + n);
        this.popup.show();
        JComponent jComponent = this.spinner.getEditor();
        ((JSpinner.DefaultEditor)jComponent).getTextField().requestFocus();
    }

    public void hide() {
        if (this.popup == null) {
            return;
        }
        this.shouldCommit = false;
        this.popup.hide();
        this.popup = null;
    }

    public boolean isVisible() {
        return this.popup != null;
    }

    public void commit() {
        try {
            this.spinner.commitEdit();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.shouldCommit) {
            this.fireActionEvent();
        }
    }

    public void setCurrentVolume(float f) {
        int n = (int)(f * 100.0f);
        if (this.decibels) {
            double d = HF.percentsToDecibels(n);
            if (d == Double.NEGATIVE_INFINITY) {
                d = -100.0;
            }
            this.spinner.setValue(d);
        } else {
            this.spinner.setValue(n);
        }
    }

    public float getVolumeFactor() {
        if (this.decibels) {
            double d = (Double)this.spinner.getValue();
            return HF.decibelsToFactor(d);
        }
        int n = (Integer)this.spinner.getValue();
        return HF.percentsToFactor(n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    private void setNumberModel() {
        String string;
        int n = this.decibels ? HF.decibelsToPercents((Double)this.spinner.getValue()) : (Integer)this.spinner.getValue();
        switch (this.volumeType) {
            case MASTER: {
                string = "maximumMasterVolume";
                break;
            }
            case CHANNEL: {
                string = "maximumChannelVolume";
                break;
            }
            default: {
                string = "maximumChannelVolume";
            }
        }
        int n2 = JSVolumeEditorPopup.preferences().getIntProperty(string);
        this.decibels = JSVolumeEditorPopup.preferences().getBoolProperty("volMeasurementUnitDecibel");
        if (this.decibels) {
            double d = HF.percentsToDecibels(n);
            if (d == Double.NEGATIVE_INFINITY) {
                d = -100.0;
            }
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(d, -100.0, HF.percentsToDecibels(n2), 1.0);
            this.spinner.setModel(spinnerNumberModel);
        } else {
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, 0, n2, 1);
            this.spinner.setModel(spinnerNumberModel);
        }
        this.reinstallEditorListeners();
    }

    private void reinstallEditorListeners() {
        JComponent jComponent = this.spinner.getEditor();
        JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
        jFormattedTextField.removeFocusListener(this.focusListener);
        jFormattedTextField.addFocusListener(this.focusListener);
        jFormattedTextField.removeActionListener(this.actionListener);
        jFormattedTextField.addActionListener(this.actionListener);
        jFormattedTextField.getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
        jFormattedTextField.getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "cancelOp");
        jFormattedTextField.getActionMap().remove("cancelOp");
        jFormattedTextField.getActionMap().put("cancelOp", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSVolumeEditorPopup.this.hide();
            }
        });
        jFormattedTextField.getInputMap(1).remove(KeyStroke.getKeyStroke(10, 0));
        jFormattedTextField.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "commitVolume");
        jFormattedTextField.getActionMap().remove("commitVolume");
        jFormattedTextField.getActionMap().put("commitVolume", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSVolumeEditorPopup.this.commit();
                JSVolumeEditorPopup.this.hide();
            }
        });
    }

    private void fireActionEvent() {
        for (ActionListener actionListener : this.listeners) {
            actionListener.actionPerformed(null);
        }
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public static enum VolumeType {
        MASTER,
        CHANNEL;

    }
}

