/*
 * Decompiled with CFR 0.152.
 */
package org.linuxsampler.lscp;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.linuxsampler.lscp.AbstractInstrument;
import org.linuxsampler.lscp.Client;
import org.linuxsampler.lscp.LscpException;
import org.linuxsampler.lscp.LscpI18n;
import org.linuxsampler.lscp.Parseable;
import org.linuxsampler.lscp.Parser;

public class DbInstrumentInfo
extends AbstractInstrument
implements Parseable {
    private String directoryPath = null;
    private final Date dateCreated = new EnhancedDate();
    private final Date dateModified = new EnhancedDate();
    private long size = 0L;
    private boolean drum = false;
    private String product = "";
    private String artists = "";
    private String keywords = "";
    private boolean showAbsolutePath = false;
    private static DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static DateFormat dateFormat2 = DateFormat.getInstance();
    private static NumberFormat numberFormat = NumberFormat.getInstance();

    public DbInstrumentInfo(String[] stringArray) throws LscpException {
        for (String string : stringArray) {
            if (this.parse(string)) continue;
            Client.getLogger().info(LscpI18n.getLogMsg("unknownLine", string));
        }
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String string) {
        this.directoryPath = string;
    }

    public String getInstrumentPath() {
        if (this.getDirectoryPath() == null) {
            return null;
        }
        if (this.getDirectoryPath().length() == 1) {
            if (!this.getDirectoryPath().equals("/")) {
                return null;
            }
            return this.getDirectoryPath() + Parser.toEscapedFileName(this.getName());
        }
        return this.getDirectoryPath() + "/" + Parser.toEscapedFileName(this.getName());
    }

    public Date getDateCreated() {
        return this.dateCreated;
    }

    public Date getDateModified() {
        return this.dateModified;
    }

    public long getSize() {
        return this.size;
    }

    public String getFormatedSize() {
        String string;
        long l = this.getSize();
        if (l > 0x40000000L) {
            double d = l;
            string = numberFormat.format(d /= 1.073741824E9) + " GB";
        } else if (l > 0x100000L) {
            double d = l;
            string = numberFormat.format(d /= 1048576.0) + " MB";
        } else if (l > 1024L) {
            double d = l;
            string = numberFormat.format(d /= 1024.0) + " KB";
        } else {
            string = numberFormat.format(l) + " bytes";
        }
        return string;
    }

    public boolean isDrum() {
        return this.drum;
    }

    public String getProduct() {
        return this.product;
    }

    public String getArtists() {
        return this.artists;
    }

    public String getKeywords() {
        return this.keywords;
    }

    @Override
    public String getEngine() {
        return this.getFormatFamily();
    }

    @Override
    public boolean parse(String string) throws LscpException {
        if (super.parse(string)) {
            return true;
        }
        if (string.startsWith("CREATED: ")) {
            string = string.substring("CREATED: ".length());
            try {
                this.dateCreated.setTime(dateFormat.parse(string).getTime());
            }
            catch (ParseException parseException) {
                throw new LscpException(parseException.getMessage());
            }
        } else if (string.startsWith("MODIFIED: ")) {
            string = string.substring("MODIFIED: ".length());
            try {
                this.dateModified.setTime(dateFormat.parse(string).getTime());
            }
            catch (ParseException parseException) {
                throw new LscpException(parseException.getMessage());
            }
        } else if (string.startsWith("SIZE: ")) {
            try {
                this.size = Long.parseLong(string.substring("SIZE: ".length()));
            }
            catch (NumberFormatException numberFormatException) {
                throw new LscpException(LscpI18n.getLogMsg("CommandFailed!"), numberFormatException);
            }
        } else if (string.startsWith("IS_DRUM: ")) {
            this.drum = Boolean.parseBoolean(string.substring("IS_DRUM: ".length()));
        } else if (string.startsWith("PRODUCT: ")) {
            this.product = string.substring("PRODUCT: ".length());
            this.product = Parser.toNonEscapedString(this.product);
        } else if (string.startsWith("ARTISTS: ")) {
            this.artists = string.substring("ARTISTS: ".length());
            this.artists = Parser.toNonEscapedString(this.artists);
        } else if (string.startsWith("KEYWORDS: ")) {
            this.keywords = string.substring("KEYWORDS: ".length());
            this.keywords = Parser.toNonEscapedString(this.keywords);
        } else {
            return false;
        }
        return true;
    }

    public boolean getShowAbsolutePath() {
        return this.showAbsolutePath;
    }

    public void setShowAbsolutePath(boolean bl) {
        this.showAbsolutePath = bl;
    }

    public String toString() {
        if (this.getShowAbsolutePath()) {
            return this.getInstrumentPath();
        }
        return this.getName();
    }

    static {
        numberFormat.setMinimumFractionDigits(0);
        numberFormat.setMaximumFractionDigits(1);
    }

    private class EnhancedDate
    extends Date {
        private EnhancedDate() {
        }

        @Override
        public String toString() {
            return dateFormat2.format(this);
        }
    }
}

