# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class ExtractSelection(DataObjectAlgorithm):
    """
    ExtractSelection - extract a subset from a DataSet.
    
    Superclass: DataObjectAlgorithm
    
    ExtractSelection extracts some subset of cells and points from its
    input dataobject. The dataobject is given on its first input port.
    The subset is described by the contents of the Selection on its
    second input port.  Depending on the contents of the Selection
    this will create various Selectors to identify the selected
    elements.
    
    This filter supports CompositeDataSet (output is
    MultiBlockDataSet), Table and DataSet (output is
    UnstructuredGrid). Other types of input are not processed and the
    corresponding output is a default constructed object of the input
    type.
    
    @sa
    Selection Selector SelectionNode
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkExtractSelection, obj, update, **traits)
    
    preserve_topology = tvtk_base.false_bool_trait(desc=\
        """
        This flag tells the extraction filter not to extract a subset of
        the data, but instead to produce a Insidedness array and add
        it to the input dataset. Default value is false(0).
        """
    )

    def _preserve_topology_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetPreserveTopology,
                        self.preserve_topology_)

    show_bounds = tvtk_base.false_bool_trait(desc=\
        """
        These functions is provided for compile-time compatibility with
        the old ExtractSelection which is now renamed to
        ExtractSelectionLegacy and deprecated. These functions do not
        have any effect on the behavior or ExtractSelection.
        """
    )

    def _show_bounds_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetShowBounds,
                        self.show_bounds_)

    use_probe_for_locations = tvtk_base.false_bool_trait(desc=\
        """
        These functions is provided for compile-time compatibility with
        the old ExtractSelection which is now renamed to
        ExtractSelectionLegacy and deprecated. These functions do not
        have any effect on the behavior or ExtractSelection.
        """
    )

    def _use_probe_for_locations_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUseProbeForLocations,
                        self.use_probe_for_locations_)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        V.get_input() -> DataObject
        C++: DataObject *GetInput()
        V.get_input(int) -> DataObject
        C++: DataObject *GetInput(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_selection_connection(self, *args):
        """
        V.set_selection_connection(AlgorithmOutput)
        C++: void SetSelectionConnection(AlgorithmOutput *algOutput)
        Convenience method to specify the selection connection (2nd input
        port)
        """
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.SetSelectionConnection, *my_args)
        return ret

    _updateable_traits_ = \
    (('preserve_topology', 'GetPreserveTopology'), ('show_bounds',
    'GetShowBounds'), ('use_probe_for_locations',
    'GetUseProbeForLocations'), ('abort_execute', 'GetAbortExecute'),
    ('release_data_flag', 'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'preserve_topology', 'release_data_flag', 'show_bounds',
    'use_probe_for_locations', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(ExtractSelection, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit ExtractSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['preserve_topology', 'show_bounds', 'use_probe_for_locations'],
            [], []),
            title='Edit ExtractSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit ExtractSelection properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

