# _MapCollisions\[K: [Any](builtin-Any.md) #share, V: [Any](builtin-Any.md) #share, H: [HashFunction](collections-HashFunction.md)\[K\] val\]
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L14)</span>
```pony
class val _MapCollisions[K: Any #share, V: Any #share, H: HashFunction[K] val]
```

## Constructors

### create
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L19)</span>


```pony
new iso create()
: _MapCollisions[K, V, H] iso^
```

#### Returns

* [_MapCollisions](collections-persistent-_MapCollisions.md)\[K, V, H\] iso^

---

## Public fields

### embed bins: [Array](builtin-Array.md)\[[Array](builtin-Array.md)\[[_MapEntry](collections-persistent-_MapEntry.md)\[K, V, H\] val\] iso\] iso
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L17)</span>



---

## Public Functions

### clone
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L23)</span>


```pony
fun val clone()
: _MapCollisions[K, V, H] iso^
```

#### Returns

* [_MapCollisions](collections-persistent-_MapCollisions.md)\[K, V, H\] iso^

---

### apply
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L34)</span>


```pony
fun val apply(
  hash: U32 val,
  k: K)
: (V | None val) ?
```
#### Parameters

*   hash: [U32](builtin-U32.md) val
*   k: K

#### Returns

* (V | [None](builtin-None.md) val) ?

---

### remove
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L41)</span>


```pony
fun val remove(
  hash: U32 val,
  k: K)
: _MapCollisions[K, V, H] val ?
```
#### Parameters

*   hash: [U32](builtin-U32.md) val
*   k: K

#### Returns

* [_MapCollisions](collections-persistent-_MapCollisions.md)\[K, V, H\] val ?

---

### pull_last
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L55)</span>


```pony
fun val pull_last()
: _MapEntry[K, V, H] val ?
```

#### Returns

* [_MapEntry](collections-persistent-_MapEntry.md)\[K, V, H\] val ?

---

### update_mut
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L61)</span>


```pony
fun ref update_mut(
  hash: U32 val,
  entry: _MapEntry[K, V, H] val)
: Bool val ?
```
#### Parameters

*   hash: [U32](builtin-U32.md) val
*   entry: [_MapEntry](collections-persistent-_MapEntry.md)\[K, V, H\] val

#### Returns

* [Bool](builtin-Bool.md) val ?

---

### iter
<span class="source-link">[[Source]](src/collections-persistent/_map_node.md#L73)</span>


```pony
fun val iter()
: _MapIter[K, V, H] ref
```

#### Returns

* [_MapIter](collections-persistent-_MapIter.md)\[K, V, H\] ref

---

