/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitVcs;
import git4idea.changes.GitChangeUtils;
import git4idea.commands.GitBinaryHandler;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandlerInputProcessorUtil;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitRevisionContentPreLoaderKt;
import git4idea.util.GitFileUtils;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.ranges.IntRange;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u001aB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J\u001c\u0010\u0012\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u0015J,\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u000f2\u0006\u0010\u0018\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001b"}, d2={"Lgit4idea/stash/GitRevisionContentPreLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "RECORD_SEPARATOR", "", "getProject", "()Lcom/intellij/openapi/project/Project;", "calcBlobHashesWithPaths", "", "Lgit4idea/stash/GitRevisionContentPreLoader$HashAndPath;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "toPreload", "", "Lcom/intellij/openapi/vcs/FilePath;", "Lcom/intellij/openapi/vcs/changes/Change;", "preload", "", "changes", "", "splitOutput", "", "output", "hashes", "HashAndPath", "intellij.vcs.git"})
public final class GitRevisionContentPreLoader {
    private final String RECORD_SEPARATOR;
    @NotNull
    private final Project project;

    /*
     * WARNING - void declaration
     */
    public final void preload(@NotNull VirtualFile root, @NotNull Collection<? extends Change> changes) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object beforeRevision;
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
        boolean bl = false;
        Map toPreload = new LinkedHashMap();
        GitRevisionNumber gitRevisionNumber = GitChangeUtils.resolveReference(this.project, root, "HEAD");
        Intrinsics.checkExpressionValueIsNotNull((Object)gitRevisionNumber, (String)"GitChangeUtils.resolveRe\u2026ce(project, root, \"HEAD\")");
        GitRevisionNumber head = gitRevisionNumber;
        for (Change change : changes) {
            FilePath path;
            beforeRevision = change.getBeforeRevision();
            if (!(beforeRevision instanceof GitContentRevision) || Intrinsics.areEqual((Object)beforeRevision.getRevisionNumber(), (Object)head) ^ true) {
                ContentRevision contentRevision;
                GitRevisionContentPreLoaderKt.access$getLOG$p().info("Skipping change " + change + " because beforeRevision is '" + ((contentRevision = beforeRevision) != null && (contentRevision = contentRevision.getRevisionNumber()) != null ? contentRevision.toString() : null) + '\'');
                continue;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)beforeRevision.getFile(), (String)"beforeRevision.getFile()");
            toPreload.put(path, change);
        }
        if (toPreload.isEmpty()) {
            return;
        }
        List<HashAndPath> list = this.calcBlobHashesWithPaths(root, toPreload);
        if (list == null) {
            return;
        }
        List<HashAndPath> list2 = list;
        GitBinaryHandler h2 = new GitBinaryHandler(this.project, root, GitCommand.CAT_FILE);
        h2.setSilent(true);
        GitFileUtils.addTextConvParameters(this.project, h2, false);
        h2.addParameters("--batch=" + this.RECORD_SEPARATOR + "%(objectname)");
        h2.endOptions();
        beforeRevision = list2;
        GitBinaryHandler gitBinaryHandler = h2;
        boolean $i$f$map = false;
        void var9_15 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            HashAndPath hashAndPath = (HashAndPath)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            String string = it.getHash() + ' ' + it.getRelativePath();
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        gitBinaryHandler.setInputProcessor(GitHandlerInputProcessorUtil.writeLines(collection, CharsetToolkit.UTF8_CHARSET));
        byte[] output = null;
        try {
            byte[] byArray = h2.run();
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"h.run()");
            output = byArray;
        }
        catch (Exception e) {
            GitRevisionContentPreLoaderKt.access$getLOG$p().error("Couldn't get git cat-file for " + list2, (Throwable)e);
            return;
        }
        Map<FilePath, byte[]> map2 = this.splitOutput(output, list2);
        if (map2 == null) {
            return;
        }
        Map<FilePath, byte[]> split = map2;
        Map $this$forEach$iv = toPreload;
        boolean $i$f$forEach = false;
        Map map3 = $this$forEach$iv;
        boolean bl2 = false;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            void path;
            Map.Entry element$iv;
            Map.Entry $dstr$path$change = element$iv = iterator.next();
            boolean bl4 = false;
            Map.Entry entry = $dstr$path$change;
            boolean bl3 = false;
            FilePath filePath = (FilePath)entry.getKey();
            entry = $dstr$path$change;
            bl3 = false;
            Change change = (Change)entry.getValue();
            ContentRevision contentRevision = change.getBeforeRevision();
            if (contentRevision == null) {
                throw new TypeCastException("null cannot be cast to non-null type git4idea.GitContentRevision");
            }
            GitContentRevision oldBeforeRevision = (GitContentRevision)contentRevision;
            byte[] content = split.get(path);
            ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
            Intrinsics.checkExpressionValueIsNotNull((Object)projectLevelVcsManager, (String)"ProjectLevelVcsManager.getInstance(project)");
            ContentRevisionCache cache2 = projectLevelVcsManager.getContentRevisionCache();
            cache2.putIntoConstantCache(oldBeforeRevision.getFile(), oldBeforeRevision.getRevisionNumber(), GitVcs.getKey(), content);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<HashAndPath> calcBlobHashesWithPaths(VirtualFile root, Map<FilePath, ? extends Change> toPreload) {
        void $this$mapTo$iv$iv;
        Repository repository = GitRepositoryManager.getInstance(this.project).getRepositoryForRoot(root);
        if (repository == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)repository, (String)"GitRepositoryManager.get\u2026RepositoryForRoot(root)!!");
        GitRepository repository2 = (GitRepository)repository;
        List<GitIndexUtil.StagedFileOrDirectory> trees = null;
        List<GitIndexUtil.StagedFileOrDirectory> list = GitIndexUtil.listTree(repository2, (Collection<? extends FilePath>)toPreload.keySet(), (VcsRevisionNumber)GitRevisionNumber.HEAD);
        Intrinsics.checkExpressionValueIsNotNull(list, (String)"GitIndexUtil.listTree(re\u2026ry, toPreload.keys, HEAD)");
        trees = list;
        if (trees.size() != toPreload.size()) {
            GitRevisionContentPreLoaderKt.access$getLOG$p().warn("Incorrect number of trees " + trees.size() + " != " + toPreload.size());
            return CollectionsKt.emptyList();
        }
        Iterable $this$map$iv = trees;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void tree;
            GitIndexUtil.StagedFileOrDirectory stagedFileOrDirectory = (GitIndexUtil.StagedFileOrDirectory)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (!(tree instanceof GitIndexUtil.StagedFile)) {
                GitRevisionContentPreLoaderKt.access$getLOG$p().warn("Unexpected tree: " + tree);
                return null;
            }
            String relativePath = VcsFileUtil.relativePath((VirtualFile)root, (FilePath)((GitIndexUtil.StagedFile)tree).getPath());
            if (relativePath == null) {
                GitRevisionContentPreLoaderKt.access$getLOG$p().error("Unexpected ls-tree output", new Attachment[]{new Attachment("trees.txt", CollectionsKt.joinToString$default((Iterable)trees, null, null, null, (int)0, null, null, (int)63, null))});
                return null;
            }
            String string = ((GitIndexUtil.StagedFile)tree).getBlobHash();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"tree.blobHash");
            FilePath filePath = ((GitIndexUtil.StagedFile)tree).getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)filePath, (String)"tree.path");
            HashAndPath hashAndPath = new HashAndPath(string, filePath, relativePath);
            collection.add(hashAndPath);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<FilePath, byte[]> splitOutput(byte[] output, List<HashAndPath> hashes2) {
        boolean bl = false;
        Map result2 = new LinkedHashMap();
        int currentPosition = 0;
        for (HashAndPath hashAndPath : hashes2) {
            int endIndex;
            byte[] plainSeparatorBytes;
            byte[] separatorBytes;
            void hash;
            String string = hashAndPath.component1();
            FilePath path = hashAndPath.component2();
            String string2 = this.RECORD_SEPARATOR + (String)hash + '\n';
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.getBytes(charset), (String)"(this as java.lang.String).getBytes(charset)");
            if (!ArrayUtil.startsWith((byte[])output, (int)currentPosition, (byte[])separatorBytes)) {
                String string4;
                Attachment[] attachmentArray;
                String string5 = "catfile.txt";
                int n = 0;
                Attachment[] attachmentArray2 = attachmentArray = new Attachment[1];
                String string6 = "Unexpected output for hash " + (String)hash + " at position " + currentPosition;
                Logger logger = GitRevisionContentPreLoaderKt.access$getLOG$p();
                boolean bl3 = false;
                String string7 = string4 = new String(output, Charsets.UTF_8);
                String string8 = string5;
                attachmentArray[n] = new Attachment(string8, string7);
                logger.error(string6, attachmentArray2);
                return null;
            }
            int startIndex = currentPosition + separatorBytes.length;
            String string9 = this.RECORD_SEPARATOR;
            Charset charset2 = Charsets.UTF_8;
            boolean bl4 = false;
            String string10 = string9;
            if (string10 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string10.getBytes(charset2), (String)"(this as java.lang.String).getBytes(charset)");
            int nextSeparator = ArrayUtil.indexOf((byte[])output, (byte[])plainSeparatorBytes, (int)startIndex);
            int n = endIndex = nextSeparator > 0 ? nextSeparator : output.length;
            if (endIndex > output.length) {
                String string11;
                Attachment[] attachmentArray;
                String string12 = "catfile.txt";
                int n2 = 0;
                Attachment[] attachmentArray3 = attachmentArray = new Attachment[1];
                String string13 = "Unexpected output for hash " + (String)hash + " at position " + currentPosition;
                Logger logger = GitRevisionContentPreLoaderKt.access$getLOG$p();
                bl4 = false;
                String string14 = string11 = new String(output, Charsets.UTF_8);
                String string15 = string12;
                attachmentArray[n2] = new Attachment(string15, string14);
                logger.error(string13, attachmentArray3);
                return null;
            }
            if (endIndex <= startIndex || output[endIndex - 1] != (byte)10) {
                String string16;
                Attachment[] attachmentArray;
                String string17 = "catfile.txt";
                int n3 = 0;
                Attachment[] attachmentArray4 = attachmentArray = new Attachment[1];
                String string18 = "Unexpected output for hash " + (String)hash + " at position " + endIndex;
                Logger logger = GitRevisionContentPreLoaderKt.access$getLOG$p();
                bl4 = false;
                String string19 = string16 = new String(output, Charsets.UTF_8);
                String string20 = string17;
                attachmentArray[n3] = new Attachment(string20, string19);
                logger.error(string18, attachmentArray4);
                return null;
            }
            byte[] byArray = output;
            int n4 = endIndex - 1;
            boolean bl5 = false;
            byte[] content = ArraysKt.copyOfRange((byte[])byArray, (int)startIndex, (int)n4);
            result2.put(path, content);
            currentPosition = endIndex;
        }
        if (result2.size() != hashes2.size()) {
            String string;
            Attachment[] attachmentArray;
            String string21 = "catfile.txt";
            int n = 0;
            Attachment[] attachmentArray5 = attachmentArray = new Attachment[1];
            String string22 = "Invalid git cat-file output for " + hashes2;
            Logger logger = GitRevisionContentPreLoaderKt.access$getLOG$p();
            boolean bl6 = false;
            String string23 = string = new String(output, Charsets.UTF_8);
            String string24 = string21;
            attachmentArray[n] = new Attachment(string24, string23);
            logger.error(string22, attachmentArray5);
            return null;
        }
        return result2;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public GitRevisionContentPreLoader(@NotNull Project project) {
        Collection<Character> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        int n = 1;
        Iterable iterable = (Iterable)new IntRange(n, 10);
        GitRevisionContentPreLoader gitRevisionContentPreLoader = this;
        boolean $i$f$map = false;
        void var4_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            int item$iv$iv;
            int n2 = item$iv$iv = ((IntIterator)iterator).nextInt();
            collection = destination$iv$iv;
            boolean bl = false;
            CharSequence charSequence = "\u0001\u0002\u0003";
            boolean bl2 = false;
            Character c = Character.valueOf(StringsKt.random((CharSequence)charSequence, (Random)((Random)Random.Default)));
            collection.add(c);
        }
        collection = (List)destination$iv$iv;
        gitRevisionContentPreLoader.RECORD_SEPARATOR = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u0017"}, d2={"Lgit4idea/stash/GitRevisionContentPreLoader$HashAndPath;", "", "hash", "", "path", "Lcom/intellij/openapi/vcs/FilePath;", "relativePath", "(Ljava/lang/String;Lcom/intellij/openapi/vcs/FilePath;Ljava/lang/String;)V", "getHash", "()Ljava/lang/String;", "getPath", "()Lcom/intellij/openapi/vcs/FilePath;", "getRelativePath", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.git"})
    private static final class HashAndPath {
        @NotNull
        private final String hash;
        @NotNull
        private final FilePath path;
        @NotNull
        private final String relativePath;

        @NotNull
        public final String getHash() {
            return this.hash;
        }

        @NotNull
        public final FilePath getPath() {
            return this.path;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }

        public HashAndPath(@NotNull String hash, @NotNull FilePath path, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            this.hash = hash;
            this.path = path;
            this.relativePath = relativePath;
        }

        @NotNull
        public final String component1() {
            return this.hash;
        }

        @NotNull
        public final FilePath component2() {
            return this.path;
        }

        @NotNull
        public final String component3() {
            return this.relativePath;
        }

        @NotNull
        public final HashAndPath copy(@NotNull String hash, @NotNull FilePath path, @NotNull String relativePath) {
            Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
            Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
            Intrinsics.checkParameterIsNotNull((Object)relativePath, (String)"relativePath");
            return new HashAndPath(hash, path, relativePath);
        }

        public static /* synthetic */ HashAndPath copy$default(HashAndPath hashAndPath, String string, FilePath filePath, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = hashAndPath.hash;
            }
            if ((n & 2) != 0) {
                filePath = hashAndPath.path;
            }
            if ((n & 4) != 0) {
                string2 = hashAndPath.relativePath;
            }
            return hashAndPath.copy(string, filePath, string2);
        }

        @NotNull
        public String toString() {
            return "HashAndPath(hash=" + this.hash + ", path=" + this.path + ", relativePath=" + this.relativePath + ")";
        }

        public int hashCode() {
            String string = this.hash;
            FilePath filePath = this.path;
            String string2 = this.relativePath;
            return ((string != null ? string.hashCode() : 0) * 31 + (filePath != null ? filePath.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof HashAndPath)) break block3;
                    HashAndPath hashAndPath = (HashAndPath)object;
                    if (!Intrinsics.areEqual((Object)this.hash, (Object)hashAndPath.hash) || !Intrinsics.areEqual((Object)this.path, (Object)hashAndPath.path) || !Intrinsics.areEqual((Object)this.relativePath, (Object)hashAndPath.relativePath)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

