/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.daemon.impl.quickfix.ManuallySetupExtResourceAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xml.XmlBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class BaseExtResourceAction
extends BaseIntentionAction {
    BaseExtResourceAction() {
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            BaseExtResourceAction.$$$reportNull$$$0(0);
        }
        if (!(file instanceof XmlFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        String uri = BaseExtResourceAction.findUri(file, offset);
        if (uri == null || !this.isAcceptableUri(uri)) {
            return false;
        }
        this.setText(XmlBundle.message((String)this.getQuickFixKeyId(), (Object[])new Object[0]));
        return true;
    }

    protected boolean isAcceptableUri(String uri) {
        return true;
    }

    protected abstract String getQuickFixKeyId();

    @NotNull
    public String getFamilyName() {
        String string = XmlBundle.message((String)this.getQuickFixKeyId(), (Object[])new Object[0]);
        if (string == null) {
            BaseExtResourceAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            BaseExtResourceAction.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        String uri = BaseExtResourceAction.findUri(file, offset);
        if (uri == null) {
            return;
        }
        this.doInvoke(file, offset, uri, editor);
    }

    protected abstract void doInvoke(@NotNull PsiFile var1, int var2, @NotNull String var3, Editor var4) throws IncorrectOperationException;

    @Nullable
    public static String findUri(PsiFile file, int offset) {
        PsiElement element = file.findElementAt(offset);
        if (element == null || element instanceof PsiWhiteSpace) {
            return null;
        }
        PsiReference currentRef = file.getViewProvider().findReferenceAt(offset, file.getLanguage());
        if (currentRef == null) {
            currentRef = file.getViewProvider().findReferenceAt(offset);
        }
        if (currentRef instanceof URLReference || currentRef instanceof DependentNSReference) {
            return currentRef.getCanonicalText();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof ManuallySetupExtResourceAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/quickfix/BaseExtResourceAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

