/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.MultiplePsiFilesPerDocumentFileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.analysis.XmlAnalysisBundle;
import com.intellij.xml.util.XmlDeclareIdInCommentAction;
import com.intellij.xml.util.XmlDuplicatedIdInspection;
import com.intellij.xml.util.XmlIdContributor;
import com.intellij.xml.util.XmlRefCountHolder;
import com.intellij.xml.util.XmlUtil;

public class XmlInvalidIdInspection
extends XmlDuplicatedIdInspection {
    @Override
    protected void checkValue(XmlAttributeValue value, XmlFile file, XmlRefCountHolder refHolder, XmlTag tag, ProblemsHolder holder) {
        String idRef = XmlHighlightVisitor.getUnquotedValue(value, tag);
        if (tag instanceof HtmlTag) {
            idRef = StringUtil.toLowerCase((String)idRef);
        }
        if (XmlUtil.isSimpleValue(idRef, (PsiElement)value) && refHolder.isIdReferenceValue(value)) {
            boolean hasIdDeclaration = refHolder.hasIdDeclaration(idRef);
            if (!hasIdDeclaration && tag instanceof HtmlTag) {
                hasIdDeclaration = refHolder.hasIdDeclaration(value.getValue());
            }
            if (!hasIdDeclaration) {
                for (XmlIdContributor contributor : XmlIdContributor.EP_NAME.getExtensionList()) {
                    if (!contributor.suppressExistingIdValidation(file)) continue;
                    return;
                }
                FileViewProvider viewProvider = tag.getContainingFile().getViewProvider();
                if (viewProvider instanceof MultiplePsiFilesPerDocumentFileViewProvider) {
                    holder.registerProblem((PsiElement)value, XmlAnalysisBundle.message((String)"invalid.id.reference", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[]{new XmlDeclareIdInCommentAction(idRef)});
                } else {
                    holder.registerProblem((PsiElement)value, XmlAnalysisBundle.message((String)"invalid.id.reference", (Object[])new Object[0]), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, new LocalQuickFix[0]);
                }
            }
        }
    }
}

