/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.util.io.PagePool;
import com.intellij.util.io.storage.AbstractRecordsTable;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.CapacityAllocationPolicy;
import com.intellij.util.io.storage.RecordsTable;
import java.io.File;
import java.io.IOException;

public class Storage
extends AbstractStorage {
    public Storage(String path) throws IOException {
        super(path, true);
    }

    public Storage(String path, CapacityAllocationPolicy capacityAllocationPolicy) throws IOException {
        super(path, capacityAllocationPolicy, true);
    }

    @Override
    protected AbstractRecordsTable createRecordsTable(PagePool pool, File recordsFile) throws IOException {
        return new RecordsTable(recordsFile, pool);
    }

    public int createNewRecord() throws IOException {
        return this.withWriteLock(() -> this.myRecordsTable.createNewRecord());
    }

    public void deleteRecord(int record) throws IOException {
        assert (record > 0);
        this.withWriteLock(() -> this.doDeleteRecord(record));
    }
}

