/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.actions;

import com.intellij.icons.AllIcons;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.statistic.StatisticsBundle;
import com.intellij.internal.statistic.StatisticsDevKitUtil;
import com.intellij.internal.statistic.eventLog.validator.persistence.BaseEventLogWhitelistPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.EventLogWhitelistSettingsPersistence;
import com.intellij.internal.statistic.eventLog.validator.persistence.WhitelistPathSettings;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/internal/statistic/actions/OpenEventsSchemeFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "myRecorderId", "", "(Ljava/lang/String;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.platform.statistics.devkit"})
public final class OpenEventsSchemeFileAction
extends DumbAwareAction {
    private final String myRecorderId;
    public static final Companion Companion = new Companion(null);

    public void actionPerformed(@NotNull AnActionEvent e) {
        File file;
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"e.project ?: return");
        Project project2 = project;
        WhitelistPathSettings settings2 = EventLogWhitelistSettingsPersistence.getInstance().getPathSettings(this.myRecorderId);
        File file2 = file = settings2 != null && settings2.isUseCustomPath() ? new File(settings2.getCustomPath()) : BaseEventLogWhitelistPersistence.getDefaultMetadataFile((String)this.myRecorderId, (String)"events-scheme.json", null);
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"file");
        Companion.openFileInEditor(file2, project2);
    }

    public OpenEventsSchemeFileAction(@NotNull String myRecorderId) {
        Intrinsics.checkParameterIsNotNull((Object)myRecorderId, (String)"myRecorderId");
        super(StatisticsBundle.message((String)"stats.open.0.scheme.file", (Object[])new Object[]{myRecorderId}), ActionsBundle.message((String)"group.OpenEventsSchemeFileAction.description", (Object[])new Object[0]), AllIcons.FileTypes.Config);
        this.myRecorderId = myRecorderId;
    }

    public /* synthetic */ OpenEventsSchemeFileAction(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "FUS";
        }
        this(string);
    }

    public OpenEventsSchemeFileAction() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/actions/OpenEventsSchemeFileAction$Companion;", "", "()V", "openFileInEditor", "", "file", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.statistics.devkit"})
    public static final class Companion {
        public final void openFileInEditor(@NotNull File file, @NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            if (virtualFile == null) {
                String string = StatisticsBundle.message((String)"stats.file.0.does.not.exist", (Object[])new Object[]{file.getAbsolutePath()});
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StatisticsBundle.message\u2026xist\", file.absolutePath)");
                StatisticsDevKitUtil.INSTANCE.showNotification(project, NotificationType.WARNING, string);
                return;
            }
            FileEditorManager.getInstance((Project)project).openFile(virtualFile, true);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

