/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl.lite;

import com.amazon.ion.IonBlob;
import com.amazon.ion.IonType;
import com.amazon.ion.IonWriter;
import com.amazon.ion.ValueVisitor;
import com.amazon.ion.impl._Private_IonValue;
import com.amazon.ion.impl._Private_Utils;
import com.amazon.ion.impl.lite.ContainerlessContext;
import com.amazon.ion.impl.lite.IonContext;
import com.amazon.ion.impl.lite.IonLobLite;
import java.io.IOException;
import java.io.InputStream;

final class IonBlobLite
extends IonLobLite
implements IonBlob {
    private static final int HASH_SIGNATURE = IonType.BLOB.toString().hashCode();

    IonBlobLite(ContainerlessContext context, boolean isNull) {
        super(context, isNull);
    }

    IonBlobLite(IonBlobLite existing, IonContext context) {
        super(existing, context);
    }

    @Override
    IonBlobLite clone(IonContext context) {
        return new IonBlobLite(this, context);
    }

    @Override
    public IonBlobLite clone() {
        return this.clone(ContainerlessContext.wrap(this.getSystem()));
    }

    @Override
    int hashCode(_Private_IonValue.SymbolTableProvider symbolTableProvider) {
        return this.lobHashCode(HASH_SIGNATURE, symbolTableProvider);
    }

    @Override
    public IonType getType() {
        return IonType.BLOB;
    }

    @Override
    public void printBase64(Appendable out) throws IOException {
        this.validateThisNotNull();
        try (InputStream byteStream = this.newInputStream();){
            _Private_Utils.writeAsBase64(byteStream, out);
        }
    }

    @Override
    final void writeBodyTo(IonWriter writer, _Private_IonValue.SymbolTableProvider symbolTableProvider) throws IOException {
        writer.writeBlob(this.getBytesNoCopy());
    }

    @Override
    public void accept(ValueVisitor visitor) throws Exception {
        visitor.visit(this);
    }
}

