/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.diagnostic.PluginException;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.FilterMixin;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Consumer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeFilter
implements Filter,
FilterMixin,
DumbAware {
    private static final Logger LOG = Logger.getInstance(CompositeFilter.class);
    private final List<Filter> myFilters;
    private boolean myIsAnyHeavy;
    private boolean forceUseAllFilters;
    private final DumbService myDumbService;

    public CompositeFilter(@NotNull Project project) {
        if (project == null) {
            CompositeFilter.$$$reportNull$$$0(0);
        }
        this(project, Collections.emptyList());
    }

    public CompositeFilter(@NotNull Project project, @NotNull List<? extends Filter> filters) {
        if (project == null) {
            CompositeFilter.$$$reportNull$$$0(1);
        }
        if (filters == null) {
            CompositeFilter.$$$reportNull$$$0(2);
        }
        this.myDumbService = DumbService.getInstance(project);
        this.myFilters = new ArrayList<Filter>(filters);
        this.myFilters.forEach(filter -> this.myIsAnyHeavy |= filter instanceof FilterMixin);
    }

    protected CompositeFilter(@NotNull DumbService dumbService) {
        if (dumbService == null) {
            CompositeFilter.$$$reportNull$$$0(3);
        }
        this.myDumbService = dumbService;
        this.myFilters = new ArrayList<Filter>();
    }

    @Override
    @Nullable
    public Filter.Result applyFilter(@NotNull String line, int entireLength) {
        if (line == null) {
            CompositeFilter.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        boolean dumb = this.myDumbService.isDumb();
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        List<Filter.ResultItem> resultItems = null;
        for (int i = 0; i < count; ++i) {
            Filter.Result result;
            ProgressManager.checkCanceled();
            Filter filter = filters.get(i);
            if (dumb && !DumbService.isDumbAware(filter)) continue;
            long t0 = System.currentTimeMillis();
            try {
                result = filter.applyFilter(line, entireLength);
            }
            catch (ProcessCanceledException ignore) {
                result = null;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while applying " + filter + " to '" + line + "'", t);
            }
            if (result != null) {
                resultItems = CompositeFilter.merge(resultItems, result, entireLength, filter);
            }
            if ((t0 = System.currentTimeMillis() - t0) > 1000L) {
                LOG.warn(filter.getClass().getSimpleName() + ".applyFilter() took " + t0 + " ms on '''" + line + "'''");
            }
            if (result != null && this.shouldStopFiltering(result)) break;
        }
        if (resultItems == null) {
            return null;
        }
        return CompositeFilter.createFinalResult(resultItems);
    }

    @NotNull
    private static Filter.Result createFinalResult(@NotNull List<? extends Filter.ResultItem> resultItems) {
        if (resultItems == null) {
            CompositeFilter.$$$reportNull$$$0(5);
        }
        if (resultItems.size() == 1) {
            final Filter.ResultItem resultItem = resultItems.get(0);
            return new Filter.Result(resultItem.getHighlightStartOffset(), resultItem.getHighlightEndOffset(), resultItem.getHyperlinkInfo(), resultItem.getHighlightAttributes(), resultItem.getFollowedHyperlinkAttributes()){

                @Override
                public int getHighlighterLayer() {
                    return resultItem.getHighlighterLayer();
                }
            };
        }
        return new Filter.Result(resultItems);
    }

    private boolean shouldStopFiltering(@NotNull Filter.Result result) {
        if (result == null) {
            CompositeFilter.$$$reportNull$$$0(6);
        }
        return result.getNextAction() == Filter.NextAction.EXIT && !this.forceUseAllFilters;
    }

    @NotNull
    private static List<Filter.ResultItem> merge(@Nullable List<Filter.ResultItem> resultItems, @NotNull Filter.Result newResult, int entireLength, @NotNull Filter filter) {
        if (newResult == null) {
            CompositeFilter.$$$reportNull$$$0(7);
        }
        if (filter == null) {
            CompositeFilter.$$$reportNull$$$0(8);
        }
        if (resultItems == null) {
            resultItems = new ArrayList<Filter.ResultItem>();
        }
        List<Filter.ResultItem> newItems = newResult.getResultItems();
        for (int i = 0; i < newItems.size(); ++i) {
            Filter.ResultItem item = newItems.get(i);
            if (item.getHyperlinkInfo() != null && CompositeFilter.intersects(resultItems, item) || !CompositeFilter.checkOffsetsCorrect(item, entireLength, filter)) continue;
            resultItems.add(item);
        }
        List<Filter.ResultItem> list = resultItems;
        if (list == null) {
            CompositeFilter.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean checkOffsetsCorrect(@NotNull Filter.ResultItem item, int entireLength, @NotNull Filter filter) {
        if (item == null) {
            CompositeFilter.$$$reportNull$$$0(10);
        }
        if (filter == null) {
            CompositeFilter.$$$reportNull$$$0(11);
        }
        int start = item.getHighlightStartOffset();
        int end = item.getHighlightEndOffset();
        if (end < start || end > entireLength) {
            String message = "Filter returned wrong range: start=" + start + "; end=" + end + "; length=" + entireLength + "; filter=" + filter;
            PluginException.logPluginError(LOG, message, null, filter.getClass());
            return false;
        }
        return true;
    }

    protected static boolean intersects(@NotNull List<? extends Filter.ResultItem> items, @NotNull Filter.ResultItem newItem) {
        if (items == null) {
            CompositeFilter.$$$reportNull$$$0(12);
        }
        if (newItem == null) {
            CompositeFilter.$$$reportNull$$$0(13);
        }
        TextRange newItemTextRange = null;
        for (int i = 0; i < items.size(); ++i) {
            Filter.ResultItem item = items.get(i);
            if (item.getHyperlinkInfo() == null) continue;
            if (newItemTextRange == null) {
                newItemTextRange = new TextRange(newItem.getHighlightStartOffset(), newItem.getHighlightEndOffset());
            }
            if (!newItemTextRange.intersectsStrict(item.getHighlightStartOffset(), item.getHighlightEndOffset())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldRunHeavy() {
        for (Filter filter : this.myFilters) {
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void applyHeavyFilter(@NotNull Document copiedFragment, int startOffset, int startLineNumber, @NotNull Consumer<? super FilterMixin.AdditionalHighlight> consumer) {
        if (copiedFragment == null) {
            CompositeFilter.$$$reportNull$$$0(14);
        }
        if (consumer == null) {
            CompositeFilter.$$$reportNull$$$0(15);
        }
        List<Filter> filters = this.myFilters;
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            ((FilterMixin)((Object)filter)).applyHeavyFilter(copiedFragment, startOffset, startLineNumber, consumer);
        }
    }

    @Override
    @NotNull
    public String getUpdateMessage() {
        List<Filter> filters = this.myFilters;
        ArrayList<String> updateMessage = new ArrayList<String>();
        int count = filters.size();
        for (int i = 0; i < count; ++i) {
            Filter filter = filters.get(i);
            if (!(filter instanceof FilterMixin) || !((FilterMixin)((Object)filter)).shouldRunHeavy()) continue;
            updateMessage.add(((FilterMixin)((Object)filter)).getUpdateMessage());
        }
        return updateMessage.size() == 1 ? (String)updateMessage.get(0) : "Updating...";
    }

    public boolean isEmpty() {
        return this.myFilters.isEmpty();
    }

    public boolean isAnyHeavy() {
        return this.myIsAnyHeavy;
    }

    public void addFilter(@NotNull Filter filter) {
        if (filter == null) {
            CompositeFilter.$$$reportNull$$$0(16);
        }
        this.myFilters.add(filter);
        this.myIsAnyHeavy |= filter instanceof FilterMixin;
    }

    @NotNull
    public List<Filter> getFilters() {
        List<Filter> list = Collections.unmodifiableList(this.myFilters);
        if (list == null) {
            CompositeFilter.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void setForceUseAllFilters(boolean forceUseAllFilters) {
        this.forceUseAllFilters = forceUseAllFilters;
    }

    public String toString() {
        return "CompositeFilter: " + this.myFilters;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumbService";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultItems";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newResult";
                break;
            }
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/filters/CompositeFilter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copiedFragment";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/filters/CompositeFilter";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "applyFilter";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createFinalResult";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "shouldStopFiltering";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 9: 
            case 17: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkOffsetsCorrect";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyHeavyFilter";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addFilter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

