/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actionSystem;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ReadOnlyFragmentModificationException;
import com.intellij.openapi.editor.actionSystem.ActionPlan;
import com.intellij.openapi.editor.actionSystem.EditorActionHandlerBean;
import com.intellij.openapi.editor.actionSystem.EditorActionManager;
import com.intellij.openapi.editor.actionSystem.EditorTypedHandlerBean;
import com.intellij.openapi.editor.actionSystem.TypedActionHandler;
import com.intellij.openapi.editor.actionSystem.TypedActionHandlerEx;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.reporting.FreezeLogger;
import com.intellij.util.pico.DefaultPicoContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TypedAction {
    private static final Logger LOG = Logger.getInstance(EditorActionHandlerBean.class);
    private static final ExtensionPointName<EditorTypedHandlerBean> EP_NAME = new ExtensionPointName("com.intellij.editorTypedHandler");
    private static final ExtensionPointName<EditorTypedHandlerBean> RAW_EP_NAME = new ExtensionPointName("com.intellij.rawEditorTypedHandler");
    private TypedActionHandler myRawHandler;
    private TypedActionHandler myHandler = new Handler();
    private boolean myHandlersLoaded;

    public static TypedAction getInstance() {
        return (TypedAction)ApplicationManager.getApplication().getService(TypedAction.class);
    }

    private void ensureHandlersLoaded() {
        if (this.myHandlersLoaded) {
            return;
        }
        this.myHandlersLoaded = true;
        DefaultPicoContainer container = new DefaultPicoContainer((DefaultPicoContainer)ApplicationManager.getApplication().getPicoContainer());
        EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            TypedActionHandler handler = TypedAction.getOrCreateHandler(bean, this.myHandler, container, pluginDescriptor);
            if (handler != null) {
                this.myHandler = handler;
            }
        });
    }

    @Nullable
    private static TypedActionHandler getOrCreateHandler(@NotNull EditorTypedHandlerBean bean, @NotNull TypedActionHandler originalHandler, @NotNull DefaultPicoContainer container, @NotNull PluginDescriptor pluginDescriptor) {
        TypedActionHandler handler;
        if (bean == null) {
            TypedAction.$$$reportNull$$$0(0);
        }
        if (originalHandler == null) {
            TypedAction.$$$reportNull$$$0(1);
        }
        if (container == null) {
            TypedAction.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            TypedAction.$$$reportNull$$$0(3);
        }
        try {
            container.unregisterComponent(TypedActionHandler.class);
            container.registerComponentInstance(TypedActionHandler.class, (Object)originalHandler);
            handler = bean.getHandler(container, pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (PluginException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (Exception e) {
            LOG.error((Throwable)new PluginException(e, pluginDescriptor.getPluginId()));
            return null;
        }
        return handler;
    }

    private void loadRawHandlers() {
        DefaultPicoContainer container = new DefaultPicoContainer((DefaultPicoContainer)ApplicationManager.getApplication().getPicoContainer());
        RAW_EP_NAME.processWithPluginDescriptor((bean, pluginDescriptor) -> {
            TypedActionHandler handler = TypedAction.getOrCreateHandler(bean, this.myRawHandler, container, pluginDescriptor);
            if (handler != null) {
                this.myRawHandler = handler;
            }
        });
    }

    public TypedActionHandler getHandler() {
        this.ensureHandlersLoaded();
        return this.myHandler;
    }

    @Deprecated
    public TypedActionHandler setupHandler(TypedActionHandler handler) {
        this.ensureHandlersLoaded();
        TypedActionHandler tmp = this.myHandler;
        this.myHandler = handler;
        return tmp;
    }

    @NotNull
    public TypedActionHandler getRawHandler() {
        TypedActionHandler typedActionHandler = this.myRawHandler;
        if (typedActionHandler == null) {
            TypedAction.$$$reportNull$$$0(4);
        }
        return typedActionHandler;
    }

    public TypedActionHandler setupRawHandler(@NotNull TypedActionHandler handler) {
        if (handler == null) {
            TypedAction.$$$reportNull$$$0(5);
        }
        TypedActionHandler tmp = this.myRawHandler;
        this.myRawHandler = handler;
        if (tmp == null) {
            this.loadRawHandlers();
        }
        return tmp;
    }

    public void beforeActionPerformed(@NotNull Editor editor, char c, @NotNull DataContext context, @NotNull ActionPlan plan) {
        if (editor == null) {
            TypedAction.$$$reportNull$$$0(6);
        }
        if (context == null) {
            TypedAction.$$$reportNull$$$0(7);
        }
        if (plan == null) {
            TypedAction.$$$reportNull$$$0(8);
        }
        if (this.myRawHandler instanceof TypedActionHandlerEx) {
            ((TypedActionHandlerEx)this.myRawHandler).beforeExecute(editor, c, context, plan);
        }
    }

    public final void actionPerformed(@Nullable Editor editor, char charTyped, DataContext dataContext) {
        if (editor == null) {
            return;
        }
        Project project = CommonDataKeys.PROJECT.getData(dataContext);
        FreezeLogger.getInstance().runUnderPerformanceMonitor(project, () -> this.myRawHandler.execute(editor, charTyped, dataContext));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalHandler";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/actionSystem/TypedAction";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plan";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/actionSystem/TypedAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateHandler";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setupRawHandler";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "beforeActionPerformed";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class Handler
    implements TypedActionHandler {
        private Handler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(@NotNull Editor editor, char charTyped, @NotNull DataContext dataContext) {
            if (editor == null) {
                Handler.$$$reportNull$$$0(0);
            }
            if (dataContext == null) {
                Handler.$$$reportNull$$$0(1);
            }
            if (editor.isViewer()) {
                return;
            }
            Document doc = editor.getDocument();
            doc.startGuardedBlockChecking();
            try {
                String str = String.valueOf(charTyped);
                CommandProcessor.getInstance().setCurrentCommandName(EditorBundle.message("typing.in.editor.command.name", new Object[0]));
                EditorModificationUtil.typeInStringAtCaretHonorMultipleCarets(editor, str, true);
            }
            catch (ReadOnlyFragmentModificationException e) {
                EditorActionManager.getInstance().getReadonlyFragmentModificationHandler(doc).handle(e);
            }
            finally {
                doc.stopGuardedBlockChecking();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "dataContext";
                    break;
                }
            }
            objectArray[1] = "com/intellij/openapi/editor/actionSystem/TypedAction$Handler";
            objectArray[2] = "execute";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

