/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDescriptor
implements Comparable<VcsDescriptor> {
    private final String myName;
    private final boolean myCrawlUpToCheckUnderVcs;
    private final boolean myAreChildrenValidMappings;
    private final String myDisplayName;
    private final List<String> myAdministrativePatterns;
    private boolean myIsNone;

    public VcsDescriptor(String administrativePattern, String displayName, String name, boolean crawlUpToCheckUnderVcs, boolean areChildrenValidMappings) {
        this.myAdministrativePatterns = VcsDescriptor.parseAdministrativePatterns(administrativePattern);
        this.myDisplayName = displayName;
        this.myName = name;
        this.myCrawlUpToCheckUnderVcs = crawlUpToCheckUnderVcs;
        this.myAreChildrenValidMappings = areChildrenValidMappings;
    }

    @NotNull
    private static List<String> parseAdministrativePatterns(@Nullable String administrativePattern) {
        if (administrativePattern == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                VcsDescriptor.$$$reportNull$$$0(0);
            }
            return list;
        }
        List list = ContainerUtil.map((Object[])administrativePattern.split(","), it -> it.trim());
        if (list == null) {
            VcsDescriptor.$$$reportNull$$$0(1);
        }
        return list;
    }

    public boolean areChildrenValidMappings() {
        return this.myAreChildrenValidMappings;
    }

    public boolean probablyUnderVcs(VirtualFile file) {
        return this.probablyUnderVcs(file, this.myCrawlUpToCheckUnderVcs);
    }

    public boolean probablyUnderVcs(VirtualFile file, boolean crawlUp) {
        if (file == null || !file.isDirectory() || !file.isValid()) {
            return false;
        }
        if (this.myAdministrativePatterns.isEmpty()) {
            return false;
        }
        if (crawlUp) {
            return (Boolean)ReadAction.compute(() -> {
                for (VirtualFile current = file; current != null; current = current.getParent()) {
                    if (!this.matchesVcsDirPattern(current)) continue;
                    return true;
                }
                return false;
            });
        }
        return (Boolean)ReadAction.compute(() -> this.matchesVcsDirPattern(file));
    }

    private boolean matchesVcsDirPattern(@NotNull VirtualFile file) {
        if (file == null) {
            VcsDescriptor.$$$reportNull$$$0(2);
        }
        for (String pattern : this.myAdministrativePatterns) {
            VirtualFile child = file.findChild(pattern);
            if (child == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasVcsDirPattern() {
        return !this.myAdministrativePatterns.isEmpty();
    }

    public boolean matchesVcsDirPattern(@NotNull String dirName) {
        if (dirName == null) {
            VcsDescriptor.$$$reportNull$$$0(3);
        }
        return this.myAdministrativePatterns.contains(dirName);
    }

    public String getDisplayName() {
        return this.myDisplayName == null ? this.myName : this.myDisplayName;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public int compareTo(VcsDescriptor o) {
        return Comparing.compare((Comparable)((Object)this.myDisplayName), (Comparable)((Object)o.myDisplayName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VcsDescriptor that = (VcsDescriptor)o;
        return Objects.equals(this.myName, that.myName);
    }

    public boolean isNone() {
        return this.myIsNone;
    }

    public static VcsDescriptor createFictive() {
        VcsDescriptor vcsDescriptor = new VcsDescriptor(null, VcsBundle.message("none.vcs.presentation", new Object[0]), null, false, false);
        vcsDescriptor.myIsNone = true;
        return vcsDescriptor;
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/VcsDescriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "parseAdministrativePatterns";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/VcsDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matchesVcsDirPattern";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

