/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.Magnificator;
import com.intellij.ui.components.ScrollSettings;
import com.intellij.ui.components.ZoomableViewport;
import com.intellij.ui.components.ZoomingDelegate;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListModel;
import javax.swing.RepaintManager;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.ViewportLayout;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBViewport
extends JViewport
implements ZoomableViewport {
    public static final Key<Boolean> FORCE_VISIBLE_ROW_COUNT_KEY = Key.create((String)"forceVisibleRowCount");
    private static final MethodInvocator ourCanUseWindowBlitterMethod = new MethodInvocator(JViewport.class, "canUseWindowBlitter", new Class[0]);
    private static final MethodInvocator ourGetPaintManagerMethod = new MethodInvocator(RepaintManager.class, "getPaintManager", new Class[0]);
    private static final MethodInvocator ourGetUseTrueDoubleBufferingMethod = new MethodInvocator(JRootPane.class, "getUseTrueDoubleBuffering", new Class[0]);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup("scrolling-capabilities-debug", PluginId.getId((String)"com.intellij"));
    private static final int NOTIFICATION_TIMEOUT = 1500;
    private Notification myPreviousNotification;
    private static final ViewportLayout ourLayoutManager = new ViewportLayout(){

        @Override
        public void layoutContainer(Container parent) {
            JViewport viewport;
            Component view;
            if (parent instanceof JViewport && (view = (viewport = (JViewport)parent).getView()) != null) {
                Container grand = viewport.getParent();
                if (grand instanceof JScrollPane) {
                    JBViewport.doLayout((JScrollPane)grand, viewport, view);
                } else {
                    super.layoutContainer(parent);
                }
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            JViewport viewport;
            Dimension size;
            if (parent instanceof JViewport && (size = JBViewport.getPreferredScrollableViewportSize((viewport = (JViewport)parent).getView())) != null) {
                return size;
            }
            return new Dimension();
        }
    };
    private StatusText myEmptyText;
    private boolean myPaintingNow;
    private ZoomingDelegate myZoomer;
    private volatile boolean myBackgroundRequested;

    public JBViewport() {
        this.addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    JBViewport.this.myEmptyText = ((ComponentWithEmptyText)((Object)child)).getEmptyText();
                    JBViewport.this.myEmptyText.attachTo(JBViewport.this, child);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component child = e.getChild();
                if (child instanceof JBTable) {
                    ((ComponentWithEmptyText)((Object)child)).getEmptyText().attachTo(child);
                    JBViewport.this.myEmptyText = null;
                }
            }
        });
    }

    @Override
    public void setViewPosition(Point p) {
        if (ScrollSettings.isDebugEnabled() && !p.equals(this.getViewPosition()) && !this.isInsideLogToolWindow()) {
            this.checkScrollingCapabilities();
        }
        super.setViewPosition(p);
    }

    private boolean isInsideLogToolWindow() {
        Container parent3;
        Container parent2;
        Container parent1 = this.getParent();
        if (parent1 instanceof JScrollPane && (parent2 = parent1.getParent()) instanceof JPanel && (parent3 = parent2.getParent()) instanceof JPanel) {
            return parent3.getClass().getName().startsWith("com.intellij.notification.EventLogToolWindowFactory");
        }
        return false;
    }

    private void checkScrollingCapabilities() {
        if (this.myPreviousNotification == null || this.myPreviousNotification.isExpired()) {
            if (!Boolean.TRUE.equals(JBViewport.isWindowBlitterAvailableFor(this))) {
                this.myPreviousNotification = JBViewport.notify("Scrolling: cannot use window blitter");
            } else if (!Boolean.TRUE.equals(JBViewport.isTrueDoubleBufferingAvailableFor(this))) {
                this.myPreviousNotification = JBViewport.notify("Scrolling: cannot use true double buffering");
            }
        }
    }

    @Nullable
    private static Boolean isWindowBlitterAvailableFor(JViewport viewport) {
        if (ourCanUseWindowBlitterMethod.isAvailable()) {
            return (Boolean)ourCanUseWindowBlitterMethod.invoke((Object)viewport, new Object[0]);
        }
        return null;
    }

    @Override
    public void setView(Component view) {
        super.setView(view);
        JBViewport.updateBorder(view);
    }

    @Nullable
    private static Boolean isTrueDoubleBufferingAvailableFor(JComponent component) {
        if (ourGetPaintManagerMethod.isAvailable()) {
            JRootPane rootPane;
            Object paintManager = ourGetPaintManagerMethod.invoke((Object)RepaintManager.currentManager(component), new Object[0]);
            if (!"javax.swing.BufferStrategyPaintManager".equals(paintManager.getClass().getName())) {
                return false;
            }
            if (ourGetUseTrueDoubleBufferingMethod.isAvailable() && (rootPane = component.getRootPane()) != null) {
                return (Boolean)ourGetUseTrueDoubleBufferingMethod.invoke((Object)rootPane, new Object[0]);
            }
        }
        return null;
    }

    private static Notification notify(String message) {
        Notification notification = NOTIFICATION_GROUP.createNotification(message, NotificationType.INFORMATION);
        notification.notify(null);
        Timer timer = new Timer(1500, event -> notification.expire());
        timer.setRepeats(false);
        timer.start();
        return notification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Color getBackground() {
        Component child;
        Color color = super.getBackground();
        if (!this.myBackgroundRequested && EventQueue.isDispatchThread() && ScrollSettings.isBackgroundFromView() && (!this.isBackgroundSet() || color instanceof UIResource) && (child = this.getView()) != null) {
            try {
                this.myBackgroundRequested = true;
                Color color2 = child.getBackground();
                return color2;
            }
            finally {
                this.myBackgroundRequested = false;
            }
        }
        return color;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return ourLayoutManager;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(graphics));
    }

    @Override
    public void paint(Graphics g) {
        this.myPaintingNow = true;
        if (this.myZoomer != null && this.myZoomer.isActive()) {
            this.myZoomer.paint(g);
        } else {
            super.paint(g);
            if (this.myEmptyText != null) {
                this.myEmptyText.paint(this, g);
            }
        }
        this.myPaintingNow = false;
    }

    @Override
    @Nullable
    public Magnificator getMagnificator() {
        return (Magnificator)UIUtil.getClientProperty((Object)this.getView(), Magnificator.CLIENT_PROPERTY_KEY);
    }

    @Override
    public void magnificationStarted(Point at) {
        this.myZoomer = new ZoomingDelegate((JComponent)this.getView(), this);
        this.myZoomer.magnificationStarted(at);
    }

    @Override
    public void magnificationFinished(double magnification) {
        this.myZoomer.magnificationFinished(magnification);
        this.myZoomer = null;
    }

    @Override
    public void magnify(double magnification) {
        this.myZoomer.magnify(magnification);
    }

    public boolean isPaintingNow() {
        return this.myPaintingNow;
    }

    @Override
    public void scrollRectToVisible(Rectangle bounds) {
        Component view = this.getView();
        if (view instanceof JComponent && !this.isAutoscroll(bounds)) {
            JBInsets.addTo((Rectangle)bounds, (Insets)JBViewport.getViewInsets((JComponent)view));
        }
        if (bounds.width > this.getWidth()) {
            bounds.width = this.getWidth();
        }
        if (bounds.height > this.getHeight()) {
            bounds.height = this.getHeight();
        }
        super.scrollRectToVisible(bounds);
    }

    private boolean isAutoscroll(Rectangle bounds) {
        if ((bounds.x == -bounds.width || bounds.x == this.getWidth()) && bounds.y + bounds.height + bounds.y == this.getHeight()) {
            return true;
        }
        return (bounds.y == -bounds.height || bounds.y == this.getHeight()) && bounds.x + bounds.width + bounds.x == this.getWidth();
    }

    private static boolean isAlignmentNeeded(JComponent view, boolean horizontal) {
        return (!SystemInfo.isMac || horizontal && ScrollSettings.isHorizontalGapNeededOnMac()) && (view instanceof JList || view instanceof JTree || !SystemInfo.isMac && ScrollSettings.isGapNeededForAnyComponent());
    }

    private static Insets getInnerInsets(JComponent view) {
        Border border = view.getBorder();
        if (border instanceof ViewBorder) {
            ViewBorder vb = (ViewBorder)border;
            border = vb.myBorder;
        }
        return border == null ? null : border.getBorderInsets(view);
    }

    static Insets getViewInsets(JComponent view) {
        Border border = view.getBorder();
        if (border instanceof ViewBorder) {
            ViewBorder vb = (ViewBorder)border;
            JBInsets insets = JBUI.emptyInsets();
            vb.addViewInsets(view, (Insets)insets);
            return insets;
        }
        return null;
    }

    private static void doLayout(JScrollPane pane, JViewport viewport, Component view) {
        int maxY;
        JBViewport.updateBorder(view);
        Dimension actualSize = viewport.getSize();
        Dimension extentSize = viewport.toViewCoordinates(actualSize);
        Dimension viewPreferredSize = view.getPreferredSize();
        Dimension viewSize = new Dimension(viewPreferredSize);
        Point viewPosition = viewport.getViewPosition();
        Scrollable scrollable = null;
        if (view instanceof Scrollable) {
            scrollable = (Scrollable)((Object)view);
            if (scrollable.getScrollableTracksViewportWidth()) {
                viewSize.width = actualSize.width;
            }
            if (scrollable.getScrollableTracksViewportHeight()) {
                viewSize.height = actualSize.height;
            }
        }
        int maxX = viewSize.width - extentSize.width;
        if (scrollable == null || pane.getComponentOrientation().isLeftToRight()) {
            if (viewPosition.x > maxX) {
                viewPosition.x = Math.max(0, maxX);
            }
        } else {
            int n = viewPosition.x = maxX < 0 ? maxX : Math.max(0, Math.min(maxX, viewPosition.x));
        }
        if (viewPosition.y > (maxY = viewSize.height - extentSize.height)) {
            viewPosition.y = Math.max(0, maxY);
        }
        if (scrollable == null) {
            if (viewPosition.x == 0 && actualSize.width > viewPreferredSize.width) {
                viewSize.width = actualSize.width;
            }
            if (viewPosition.y == 0 && actualSize.height > viewPreferredSize.height) {
                viewSize.height = actualSize.height;
            }
        }
        if (!(view instanceof TypingTarget)) {
            if (31 == pane.getHorizontalScrollBarPolicy()) {
                viewPosition.x = 0;
                viewSize.width = extentSize.width;
            }
            if (21 == pane.getVerticalScrollBarPolicy()) {
                viewPosition.y = 0;
                viewSize.height = extentSize.height;
            }
        }
        viewport.setViewPosition(viewPosition);
        viewport.setViewSize(viewSize);
    }

    private static void updateBorder(@Nullable Component view) {
        if (ScrollSettings.isNotSupportedYet(view)) {
            return;
        }
        if (view instanceof JComponent) {
            JComponent component = (JComponent)view;
            Border border = component.getBorder();
            if (border instanceof ViewBorder) {
                return;
            }
            component.setBorder(border == null || border instanceof UIResource ? new ResourceViewBorder(border) : new ViewBorder(border));
        }
    }

    private static Dimension getPreferredScrollableViewportSize(Component view) {
        if (view instanceof JList) {
            return JBViewport.getPreferredScrollableViewportSize((JList)view);
        }
        if (view instanceof JTree) {
            return JBViewport.getPreferredScrollableViewportSize((JTree)view);
        }
        if (view instanceof Scrollable) {
            return ((Scrollable)((Object)view)).getPreferredScrollableViewportSize();
        }
        if (view instanceof JComponent) {
            return JBViewport.getPreferredSizeWithoutScrollBars((JComponent)view);
        }
        return view == null ? null : view.getPreferredSize();
    }

    private static Dimension getPreferredSizeWithoutScrollBars(@NotNull JComponent view) {
        Dimension size;
        if (view == null) {
            JBViewport.$$$reportNull$$$0(0);
        }
        if ((size = view.getPreferredSize()) == null) {
            return new Dimension();
        }
        JBInsets.removeFrom((Dimension)size, (Insets)JBViewport.getViewInsets(view));
        return size;
    }

    private static Class<?> getPreferredScrollableViewportSizeDeclaringClass(@NotNull Scrollable scrollable) {
        if (scrollable == null) {
            JBViewport.$$$reportNull$$$0(1);
        }
        try {
            return scrollable.getClass().getMethod("getPreferredScrollableViewportSize", new Class[0]).getDeclaringClass();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Dimension getPreferredScrollableViewportSize(@NotNull JList<?> list) {
        if (list == null) {
            JBViewport.$$$reportNull$$$0(2);
        }
        if (JList.class != JBViewport.getPreferredScrollableViewportSizeDeclaringClass(list)) {
            return list.getPreferredScrollableViewportSize();
        }
        Dimension size = JBViewport.getPreferredSizeWithoutScrollBars(list);
        if (0 != list.getLayoutOrientation()) {
            return size;
        }
        ListModel<?> model = list.getModel();
        int modelRows = model == null ? 0 : model.getSize();
        int visibleRows = list.getVisibleRowCount();
        boolean forceVisibleRowCount = Boolean.TRUE.equals(UIUtil.getClientProperty(list, FORCE_VISIBLE_ROW_COUNT_KEY));
        if (!forceVisibleRowCount && visibleRows > 0) {
            visibleRows = Math.min(modelRows, visibleRows);
        }
        if (visibleRows <= 0) {
            visibleRows = Registry.intValue((String)"ide.preferred.scrollable.viewport.visible.rows", (int)10);
        }
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space", (boolean)true);
        Insets insets = JBViewport.getInnerInsets(list);
        int n = size.height = insets != null ? insets.top + insets.bottom : 0;
        if (modelRows == 0) {
            int fixedWidth = list.getFixedCellWidth();
            int fixedHeight = list.getFixedCellHeight();
            if (fixedWidth <= 0) {
                fixedWidth = Registry.intValue((String)"ide.preferred.scrollable.viewport.fixed.width", (int)256);
            }
            if (fixedWidth <= 0) {
                fixedWidth = JBUIScale.scale((int)256);
            }
            if (fixedHeight <= 0) {
                fixedHeight = Registry.intValue((String)"ide.preferred.scrollable.viewport.fixed.height", (int)0);
            }
            if (fixedHeight <= 0) {
                fixedHeight = UIManager.getInt("List.rowHeight");
            }
            if (fixedHeight <= 0) {
                fixedHeight = JBUIScale.scale((int)16);
            }
            size.width = insets != null ? insets.left + insets.right + fixedWidth : fixedWidth;
            size.height += fixedHeight * visibleRows;
            if (addExtraSpace) {
                size.height += fixedHeight / 2;
            }
        } else if (visibleRows > 0) {
            int lastRow = Math.min(visibleRows, modelRows) - 1;
            Rectangle bounds = list.getCellBounds(lastRow, lastRow);
            if (bounds == null) {
                return size;
            }
            size.height = bounds.y + bounds.height;
            if (insets != null) {
                size.height += insets.bottom;
            }
            if (modelRows < visibleRows) {
                size.height += (visibleRows - modelRows) * bounds.height;
            } else if (modelRows > visibleRows && addExtraSpace) {
                size.height += bounds.height / 2;
            }
        }
        return size;
    }

    private static Dimension getPreferredScrollableViewportSize(@NotNull JTree tree) {
        int lastRow;
        Rectangle bounds;
        int visibleRows;
        if (tree == null) {
            JBViewport.$$$reportNull$$$0(3);
        }
        if (JTree.class != JBViewport.getPreferredScrollableViewportSizeDeclaringClass(tree)) {
            return tree.getPreferredScrollableViewportSize();
        }
        Dimension size = JBViewport.getPreferredSizeWithoutScrollBars(tree);
        int fixedHeight = tree.getRowHeight();
        int modelRows = tree.getRowCount();
        if (modelRows <= 0) {
            if (fixedHeight <= 0) {
                fixedHeight = Registry.intValue((String)"ide.preferred.scrollable.viewport.fixed.height", (int)0);
            }
            if (fixedHeight <= 0) {
                fixedHeight = UIManager.getInt("Tree.rowHeight");
            }
            if (fixedHeight <= 0) {
                fixedHeight = JBUIScale.scale((int)16);
            }
        }
        if ((visibleRows = tree.getVisibleRowCount()) <= 0) {
            visibleRows = Registry.intValue((String)"ide.preferred.scrollable.viewport.visible.rows", (int)10);
        }
        boolean addExtraSpace = Registry.is((String)"ide.preferred.scrollable.viewport.extra.space", (boolean)true);
        Insets insets = JBViewport.getInnerInsets(tree);
        int n = size.height = insets != null ? insets.top + insets.bottom : 0;
        if (0 < fixedHeight) {
            size.height += fixedHeight * visibleRows;
            if (addExtraSpace) {
                size.height += fixedHeight / 2;
            }
        } else if (visibleRows > 0 && (bounds = tree.getRowBounds(lastRow = Math.min(visibleRows, modelRows - 1))) != null) {
            size.height = bounds.y + bounds.height * (visibleRows - lastRow);
            if (addExtraSpace) {
                size.height += bounds.height / 2;
            } else if (insets != null) {
                size.height += insets.bottom;
            }
        }
        return size;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scrollable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ui/components/JBViewport";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredSizeWithoutScrollBars";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredScrollableViewportSizeDeclaringClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredScrollableViewportSize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ViewBorder
    extends AbstractBorder {
        private final Insets myInsets = JBUI.emptyInsets();
        private final Border myBorder;

        ViewBorder(Border border) {
            this.myBorder = border;
        }

        @Override
        public Insets getBorderInsets(Component view, Insets insets) {
            Insets inner;
            if (insets == null) {
                insets = JBUI.emptyInsets();
            } else {
                insets.set(0, 0, 0, 0);
            }
            if (this.myBorder != null && (inner = this.myBorder.getBorderInsets(view)) != null) {
                insets.set(inner.top, inner.left, inner.bottom, inner.right);
            }
            if (view instanceof JComponent) {
                this.addViewInsets((JComponent)view, insets);
            }
            if (!this.myInsets.equals(insets)) {
                this.myInsets.set(insets.top, insets.left, insets.bottom, insets.right);
                if (view instanceof JComponent) {
                    JComponent component = (JComponent)view;
                    if (component instanceof JTree) {
                        JTree tree = (JTree)component;
                        TreeUtil.invalidateCacheAndRepaint(tree.getUI());
                    }
                    component.revalidate();
                } else {
                    view.invalidate();
                    view.repaint();
                }
            }
            return insets;
        }

        @Override
        public void paintBorder(Component view, Graphics g, int x, int y, int width, int height) {
            if (this.myBorder != null) {
                this.myBorder.paintBorder(view, g, x, y, width, height);
            }
        }

        private void addViewInsets(JComponent view, Insets insets) {
            JViewport viewport;
            Container grand;
            Container parent;
            if (this == view.getBorder() && (parent = view.getParent()) instanceof JViewport && (grand = (viewport = (JViewport)parent).getParent()) instanceof JScrollPane) {
                JScrollBar hsb;
                JScrollPane pane = (JScrollPane)grand;
                JScrollBar vsb = pane.getVerticalScrollBar();
                if (vsb != null && vsb.isVisible()) {
                    boolean opaque = vsb.isOpaque();
                    if (viewport == pane.getColumnHeader() ? !opaque || ScrollSettings.isHeaderOverCorner(pane.getViewport()) : !opaque && viewport == pane.getViewport() && !UIUtil.isClientPropertyTrue((Object)vsb, JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS)) {
                        JBScrollPane.Alignment va = JBScrollPane.Alignment.get(vsb);
                        if (va == JBScrollPane.Alignment.LEFT) {
                            insets.left += vsb.getWidth();
                        } else if (va == JBScrollPane.Alignment.RIGHT && (opaque || JBViewport.isAlignmentNeeded(view, false))) {
                            insets.right += vsb.getWidth();
                        }
                    }
                }
                if ((hsb = pane.getHorizontalScrollBar()) != null && hsb.isVisible()) {
                    boolean opaque = hsb.isOpaque();
                    if (viewport == pane.getRowHeader() ? !opaque || ScrollSettings.isHeaderOverCorner(pane.getViewport()) : !opaque && viewport == pane.getViewport() && !UIUtil.isClientPropertyTrue((Object)hsb, JBScrollPane.IGNORE_SCROLLBAR_IN_INSETS)) {
                        JBScrollPane.Alignment ha = JBScrollPane.Alignment.get(hsb);
                        if (ha == JBScrollPane.Alignment.TOP) {
                            insets.top += hsb.getHeight();
                        } else if (ha == JBScrollPane.Alignment.BOTTOM && (opaque || JBViewport.isAlignmentNeeded(view, true))) {
                            insets.bottom += hsb.getHeight();
                        }
                    }
                }
            }
        }
    }

    private static class ResourceViewBorder
    extends ViewBorder
    implements UIResource {
        ResourceViewBorder(Border border) {
            super(border);
        }
    }
}

