/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.impl.rules.DirectoryGroupingRule;
import com.intellij.usages.rules.UsageGroupingRuleEx;
import com.intellij.usages.rules.UsageInFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirectoryStructureGroupingRule
implements DumbAware,
UsageGroupingRuleEx {
    protected final Project myProject;
    private final DirectoryGroupingRule myDirectoryGroupingRule;

    DirectoryStructureGroupingRule(@NotNull Project project) {
        if (project == null) {
            DirectoryStructureGroupingRule.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDirectoryGroupingRule = new DirectoryGroupingRule(project, false);
    }

    @Override
    @NotNull
    public List<UsageGroup> getParentGroupsFor(@NotNull Usage usage, UsageTarget @NotNull [] targets) {
        if (usage == null) {
            DirectoryStructureGroupingRule.$$$reportNull$$$0(1);
        }
        if (targets == null) {
            DirectoryStructureGroupingRule.$$$reportNull$$$0(2);
        }
        if (!(usage instanceof UsageInFile)) {
            List<UsageGroup> list = Collections.emptyList();
            if (list == null) {
                DirectoryStructureGroupingRule.$$$reportNull$$$0(3);
            }
            return list;
        }
        ArrayList<UsageGroup> result = new ArrayList<UsageGroup>();
        UsageInFile usageInFile = (UsageInFile)usage;
        VirtualFile file = usageInFile.getFile();
        if (file == null) {
            List<UsageGroup> list = Collections.emptyList();
            if (list == null) {
                DirectoryStructureGroupingRule.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (file instanceof VirtualFileWindow) {
            file = ((VirtualFileWindow)((Object)file)).getDelegate();
        }
        VirtualFile baseDir = ProjectUtil.guessProjectDir(this.myProject);
        for (VirtualFile dir = file.getParent(); dir != null && !dir.equals(baseDir); dir = dir.getParent()) {
            UsageGroup group = this.myDirectoryGroupingRule.getGroupForFile(dir);
            result.add(group);
        }
        Collections.reverse(result);
        ArrayList<UsageGroup> arrayList = result;
        if (arrayList == null) {
            DirectoryStructureGroupingRule.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Override
    @Nullable
    public String getGroupingActionId() {
        return "UsageGrouping.DirectoryStructure";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/usages/impl/rules/DirectoryStructureGroupingRule";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/usages/impl/rules/DirectoryStructureGroupingRule";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentGroupsFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getParentGroupsFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

