/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.net.ssl;

import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CertificateWrapper {
    @NonNls
    public static final String NOT_AVAILABLE = "N/A";
    private final X509Certificate myCertificate;
    private final Map<String, String> myIssuerFields;
    private final Map<String, String> mySubjectFields;

    public CertificateWrapper(@NotNull X509Certificate certificate) {
        if (certificate == null) {
            CertificateWrapper.$$$reportNull$$$0(0);
        }
        this.myCertificate = certificate;
        this.myIssuerFields = CertificateWrapper.extractFields(certificate.getIssuerX500Principal());
        this.mySubjectFields = CertificateWrapper.extractFields(certificate.getSubjectX500Principal());
    }

    @NotNull
    public String getIssuerField(@NotNull CommonField name) {
        String field;
        if (name == null) {
            CertificateWrapper.$$$reportNull$$$0(1);
        }
        String string = (field = this.myIssuerFields.get(name.getShortName())) == null ? NOT_AVAILABLE : field;
        if (string == null) {
            CertificateWrapper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getSubjectField(@NotNull CommonField name) {
        String field;
        if (name == null) {
            CertificateWrapper.$$$reportNull$$$0(3);
        }
        String string = (field = this.mySubjectFields.get(name.getShortName())) == null ? NOT_AVAILABLE : field;
        if (string == null) {
            CertificateWrapper.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getSha256Fingerprint() {
        String string;
        try {
            string = DigestUtils.sha256Hex((byte[])this.myCertificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            return NOT_AVAILABLE;
        }
        if (string == null) {
            CertificateWrapper.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String getSha1Fingerprint() {
        try {
            return DigestUtils.sha1Hex((byte[])this.myCertificate.getEncoded());
        }
        catch (Exception e) {
            return NOT_AVAILABLE;
        }
    }

    public boolean isValid() {
        try {
            this.myCertificate.checkValidity();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isExpired() {
        return new Date().getTime() > this.myCertificate.getNotAfter().getTime();
    }

    public boolean isNotYetValid() {
        return new Date().getTime() < this.myCertificate.getNotBefore().getTime();
    }

    public boolean isSelfSigned() {
        return this.myCertificate.getIssuerX500Principal().equals(this.myCertificate.getSubjectX500Principal());
    }

    public int getVersion() {
        return this.myCertificate.getVersion();
    }

    @NotNull
    public String getSerialNumber() {
        String string = this.myCertificate.getSerialNumber().toString();
        if (string == null) {
            CertificateWrapper.$$$reportNull$$$0(6);
        }
        return string;
    }

    public X509Certificate getCertificate() {
        return this.myCertificate;
    }

    public X500Principal getIssuerX500Principal() {
        return this.myCertificate.getIssuerX500Principal();
    }

    public X500Principal getSubjectX500Principal() {
        return this.myCertificate.getSubjectX500Principal();
    }

    public Date getNotBefore() {
        return this.myCertificate.getNotBefore();
    }

    public Date getNotAfter() {
        return this.myCertificate.getNotAfter();
    }

    public Map<String, String> getIssuerFields() {
        return this.myIssuerFields;
    }

    public Map<String, String> getSubjectFields() {
        return this.mySubjectFields;
    }

    private static Map<String, String> extractFields(X500Principal principal) {
        HashMap<String, String> fields = new HashMap<String, String>();
        for (String field : principal.getName().split("(?<!\\\\),")) {
            String[] parts = field.trim().split("=", 2);
            if (parts.length != 2) continue;
            fields.put(parts[0], parts[1].replaceAll("\\\\,", ","));
        }
        return Collections.unmodifiableMap(fields);
    }

    public final boolean equals(Object other) {
        return other instanceof CertificateWrapper && this.myCertificate.equals(((CertificateWrapper)other).getCertificate());
    }

    public final int hashCode() {
        return this.myCertificate.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "certificate";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/net/ssl/CertificateWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/net/ssl/CertificateWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssuerField";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubjectField";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSha256Fingerprint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSerialNumber";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getIssuerField";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSubjectField";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum CommonField {
        COMMON_NAME("CN", "Common Name"),
        ORGANIZATION("O", "Organization"),
        ORGANIZATION_UNIT("OU", "Organizational Unit"),
        LOCATION("L", "Locality"),
        COUNTRY("C", "Country"),
        STATE("ST", "State or Province");

        private final String myShortName;
        private final String myLongName;

        private CommonField(String shortName, String longName) {
            if (shortName == null) {
                CommonField.$$$reportNull$$$0(0);
            }
            if (longName == null) {
                CommonField.$$$reportNull$$$0(1);
            }
            this.myShortName = shortName;
            this.myLongName = longName;
        }

        public String getShortName() {
            return this.myShortName;
        }

        public String getLongName() {
            return this.myLongName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "shortName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "longName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/util/net/ssl/CertificateWrapper$CommonField";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

