/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.actions;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum ShortNameType {
    INITIALS("initials", "annotations.short.name.type.initials"),
    LASTNAME("lastname", "annotations.short.name.type.last.name"),
    FIRSTNAME("firstname", "annotations.short.name.type.first.name"),
    NONE("full", "annotations.short.name.type.full.name");

    private static final String KEY = "annotate.short.names.type";
    private final String myId;
    private final String myDescriptionKey;

    private ShortNameType(String id, String descriptionKey) {
        if (id == null) {
            ShortNameType.$$$reportNull$$$0(0);
        }
        if (descriptionKey == null) {
            ShortNameType.$$$reportNull$$$0(1);
        }
        this.myId = id;
        this.myDescriptionKey = descriptionKey;
    }

    public String getDescription() {
        return VcsBundle.message((String)this.myDescriptionKey, (Object[])new Object[0]);
    }

    boolean isSet() {
        return this.myId.equals(PropertiesComponent.getInstance().getValue(KEY));
    }

    void set() {
        PropertiesComponent.getInstance().setValue(KEY, this.myId);
    }

    @Nullable
    public static String shorten(@Nullable String name, @NotNull ShortNameType type) {
        if (type == null) {
            ShortNameType.$$$reportNull$$$0(2);
        }
        if (name == null) {
            return null;
        }
        if (type == NONE) {
            return name;
        }
        int[] ind = new int[]{name.indexOf(60), name.indexOf(64), name.indexOf(62)};
        if (0 < ind[0] && ind[0] < ind[1] && ind[1] < ind[2]) {
            name = name.substring(0, ind[0]).trim();
        }
        if (!name.contains(" ") && name.contains("@")) {
            name = name.substring(0, name.indexOf(64));
        }
        name = name.replace('.', ' ').replace('_', ' ').replace('-', ' ');
        List strings = StringUtil.split((String)name, (String)" ");
        if (type == INITIALS) {
            return StringUtil.join((Collection)strings, it -> String.valueOf(StringUtil.toUpperCase((char)it.charAt(0))), (String)"");
        }
        if (strings.size() < 2) {
            return name;
        }
        String shortName = type == FIRSTNAME ? (String)strings.get(0) : (String)strings.get(strings.size() - 1);
        return StringUtil.capitalize((String)shortName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptionKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/actions/ShortNameType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "shorten";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

