/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.conflicts.ChangelistConflictTracker;
import com.intellij.openapi.vcs.ex.ExclusionState;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.PartialLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.ThreeStateCheckBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PartialChangesUtil {
    private static final Logger LOG = Logger.getInstance(PartialChangesUtil.class);

    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull Change change) {
        VirtualFile file;
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(0);
        }
        if (change == null) {
            PartialChangesUtil.$$$reportNull$$$0(1);
        }
        if ((file = PartialChangesUtil.getVirtualFile(change)) == null) {
            return null;
        }
        return PartialChangesUtil.getPartialTracker(project, file);
    }

    @Nullable
    public static PartialLocalLineStatusTracker getPartialTracker(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(2);
        }
        if (file == null) {
            PartialChangesUtil.$$$reportNull$$$0(3);
        }
        LineStatusTracker<?> tracker = LineStatusTrackerManager.getInstance(project).getLineStatusTracker(file);
        return (PartialLocalLineStatusTracker)ObjectUtils.tryCast(tracker, PartialLocalLineStatusTracker.class);
    }

    @Nullable
    public static VirtualFile getVirtualFile(@NotNull Change change) {
        ContentRevision revision;
        if (change == null) {
            PartialChangesUtil.$$$reportNull$$$0(4);
        }
        if (!((revision = change.getAfterRevision()) instanceof CurrentContentRevision)) {
            return null;
        }
        return ((CurrentContentRevision)revision).getVirtualFile();
    }

    @NotNull
    public static List<Change> processPartialChanges(@NotNull Project project, @NotNull Collection<? extends Change> changes, boolean executeOnEDT, @NotNull PairFunction<? super List<ChangeListChange>, ? super PartialLocalLineStatusTracker, Boolean> partialProcessor) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(5);
        }
        if (changes == null) {
            PartialChangesUtil.$$$reportNull$$$0(6);
        }
        if (partialProcessor == null) {
            PartialChangesUtil.$$$reportNull$$$0(7);
        }
        if (!ContainerUtil.exists(changes, it -> it instanceof ChangeListChange)) {
            return new ArrayList<Change>(changes);
        }
        ArrayList<Change> otherChanges = new ArrayList<Change>();
        Runnable task2 = () -> {
            VirtualFile virtualFile;
            MultiMap partialChangesMap = new MultiMap();
            for (Change change : changes) {
                if (change instanceof ChangeListChange) {
                    ChangeListChange changelistChange = (ChangeListChange)change;
                    virtualFile = PartialChangesUtil.getVirtualFile(change);
                    if (virtualFile != null) {
                        partialChangesMap.putValue((Object)virtualFile, (Object)changelistChange);
                        continue;
                    }
                    otherChanges.add(changelistChange.getChange());
                    continue;
                }
                otherChanges.add(change);
            }
            LineStatusTrackerManagerI lstManager = LineStatusTrackerManager.getInstance(project);
            for (Map.Entry entry : partialChangesMap.entrySet()) {
                virtualFile = (VirtualFile)entry.getKey();
                List partialChanges = (List)entry.getValue();
                Change actualChange = ((ChangeListChange)partialChanges.get(0)).getChange();
                PartialLocalLineStatusTracker tracker = (PartialLocalLineStatusTracker)ObjectUtils.tryCast(lstManager.getLineStatusTracker(virtualFile), PartialLocalLineStatusTracker.class);
                if (tracker == null) {
                    otherChanges.add(actualChange);
                    continue;
                }
                boolean success2 = (Boolean)partialProcessor.fun((Object)partialChanges, (Object)tracker);
                if (success2) continue;
                otherChanges.add(actualChange);
            }
        };
        if (executeOnEDT && !ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().invokeAndWait(task2);
        } else {
            task2.run();
        }
        ArrayList<Change> arrayList = otherChanges;
        if (arrayList == null) {
            PartialChangesUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static void runUnderChangeList(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @NotNull Runnable task2) {
        if (project == null) {
            PartialChangesUtil.$$$reportNull$$$0(9);
        }
        if (task2 == null) {
            PartialChangesUtil.$$$reportNull$$$0(10);
        }
        PartialChangesUtil.computeUnderChangeList(project, targetChangeList, null, () -> {
            task2.run();
            return null;
        }, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T computeUnderChangeList(@NotNull Project project, @Nullable LocalChangeList targetChangeList, @Nullable String title2, @NotNull Computable<T> task2, boolean shouldAwaitCLMRefresh) {
        Object object;
        block8: {
            LocalChangeList oldDefaultList;
            ChangeListManagerImpl clm;
            block7: {
                InvokeAfterUpdateMode mode;
                if (project == null) {
                    PartialChangesUtil.$$$reportNull$$$0(11);
                }
                if (task2 == null) {
                    PartialChangesUtil.$$$reportNull$$$0(12);
                }
                clm = ChangeListManagerImpl.getInstanceImpl(project);
                oldDefaultList = clm.getDefaultChangeList();
                if (targetChangeList == null || targetChangeList.equals(oldDefaultList)) {
                    return (T)task2.compute();
                }
                PartialChangesUtil.switchChangeList(clm, targetChangeList, oldDefaultList);
                ChangelistConflictTracker clmConflictTracker = clm.getConflictTracker();
                try {
                    clmConflictTracker.setIgnoreModifications(true);
                    object = task2.compute();
                    clmConflictTracker.setIgnoreModifications(false);
                    if (!shouldAwaitCLMRefresh) break block7;
                    mode = title2 != null ? InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE : InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED;
                }
                catch (Throwable throwable) {
                    clmConflictTracker.setIgnoreModifications(false);
                    if (shouldAwaitCLMRefresh) {
                        InvokeAfterUpdateMode mode2 = title2 != null ? InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE : InvokeAfterUpdateMode.SILENT_CALLBACK_POOLED;
                        clm.invokeAfterUpdate(() -> PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList), mode2, title2, ModalityState.NON_MODAL);
                    } else {
                        PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList);
                    }
                    throw throwable;
                }
                clm.invokeAfterUpdate(() -> PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList), mode, title2, ModalityState.NON_MODAL);
                break block8;
            }
            PartialChangesUtil.restoreChangeList(clm, targetChangeList, oldDefaultList);
        }
        return (T)object;
    }

    private static void switchChangeList(@NotNull ChangeListManagerEx clm, @NotNull LocalChangeList targetChangeList, @NotNull LocalChangeList oldDefaultList) {
        if (clm == null) {
            PartialChangesUtil.$$$reportNull$$$0(13);
        }
        if (targetChangeList == null) {
            PartialChangesUtil.$$$reportNull$$$0(14);
        }
        if (oldDefaultList == null) {
            PartialChangesUtil.$$$reportNull$$$0(15);
        }
        clm.setDefaultChangeList(targetChangeList, true);
        LOG.debug(String.format("Active changelist changed: %s -> %s", oldDefaultList.getName(), targetChangeList.getName()));
    }

    private static void restoreChangeList(@NotNull ChangeListManagerEx clm, @NotNull LocalChangeList targetChangeList, @NotNull LocalChangeList oldDefaultList) {
        LocalChangeList defaultChangeList;
        if (clm == null) {
            PartialChangesUtil.$$$reportNull$$$0(16);
        }
        if (targetChangeList == null) {
            PartialChangesUtil.$$$reportNull$$$0(17);
        }
        if (oldDefaultList == null) {
            PartialChangesUtil.$$$reportNull$$$0(18);
        }
        if (Objects.equals((defaultChangeList = clm.getDefaultChangeList()).getId(), targetChangeList.getId())) {
            clm.setDefaultChangeList(oldDefaultList, true);
            LOG.debug(String.format("Active changelist restored: %s -> %s", targetChangeList.getName(), oldDefaultList.getName()));
        } else {
            LOG.warn(new Throwable(String.format("Active changelist was changed during the operation. Expected: %s -> %s, actual default: %s", targetChangeList.getName(), oldDefaultList.getName(), defaultChangeList.getName())));
        }
    }

    @NotNull
    public static ThreeStateCheckBox.State convertExclusionState(@NotNull ExclusionState exclusionState) {
        if (exclusionState == null) {
            PartialChangesUtil.$$$reportNull$$$0(19);
        }
        if (exclusionState == ExclusionState.ALL_INCLUDED) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.SELECTED;
            if (state == null) {
                PartialChangesUtil.$$$reportNull$$$0(20);
            }
            return state;
        }
        if (exclusionState == ExclusionState.ALL_EXCLUDED) {
            ThreeStateCheckBox.State state = ThreeStateCheckBox.State.NOT_SELECTED;
            if (state == null) {
                PartialChangesUtil.$$$reportNull$$$0(21);
            }
            return state;
        }
        ThreeStateCheckBox.State state = ThreeStateCheckBox.State.DONT_CARE;
        if (state == null) {
            PartialChangesUtil.$$$reportNull$$$0(22);
        }
        return state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "partialProcessor";
                break;
            }
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/PartialChangesUtil";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clm";
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetChangeList";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldDefaultList";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exclusionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/PartialChangesUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "processPartialChanges";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "convertExclusionState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPartialTracker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getVirtualFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processPartialChanges";
                break;
            }
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "runUnderChangeList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeUnderChangeList";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "switchChangeList";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "restoreChangeList";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "convertExclusionState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

