/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.webcore.packaging.PackageVersionComparator;
import com.jetbrains.python.PyPsiPackageUtil;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.packaging.IndicatedProcessOutputListener;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PyLazySdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerImpl
extends PyPackageManager {
    private static final String SETUPTOOLS_VERSION = "44.1.1";
    private static final String PIP_VERSION = "20.1.1";
    private static final String SETUPTOOLS_WHEEL_NAME = "setuptools-44.1.1-py2.py3-none-any.whl";
    private static final String PIP_WHEEL_NAME = "pip-20.1.1-py2.py3-none-any.whl";
    private static final String VIRTUALENV_WHEEL_NAME = "virtualenv-16.7.10-py2.py3-none-any.whl";
    private static final int ERROR_NO_SETUPTOOLS = 3;
    private static final Logger LOG = Logger.getInstance(PyPackageManagerImpl.class);
    private static final String PACKAGING_TOOL = "packaging_tool.py";
    private static final int TIMEOUT = 600000;
    private static final String BUILD_DIR_OPTION = "--build-dir";
    private static final String INSTALL = "install";
    private static final String UNINSTALL = "uninstall";
    protected String mySeparator;
    @Nullable
    private volatile List<PyPackage> myPackagesCache;
    private final AtomicBoolean myUpdatingCache;
    @NotNull
    private final Sdk mySdk;

    @Override
    public void refresh() {
        LOG.debug("Refreshing SDK roots and packages cache");
        Application application = ApplicationManager.getApplication();
        application.invokeLater(() -> {
            Sdk sdk = this.getSdk();
            application.runWriteAction(() -> {
                VirtualFile[] files = sdk.getRootProvider().getFiles(OrderRootType.CLASSES);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)true, (boolean)true, (VirtualFile[])files);
            });
            PythonSdkType.getInstance().setupSdkPaths(sdk);
        });
    }

    @Override
    public void installManagement() throws ExecutionException {
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(this.getSdk());
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException("Package management for Python " + (Object)((Object)languageLevel) + " is not supported. Upgrade your project interpreter to Python " + (Object)((Object)LanguageLevel.PYTHON27) + " or newer");
        }
        boolean success = this.updatePackagingTools();
        if (success) {
            return;
        }
        PyPackage installedSetuptools = this.refreshAndCheckForSetuptools();
        PyPackage installedPip = PyPsiPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip");
        if (installedSetuptools == null || PackageVersionComparator.VERSION_COMPARATOR.compare(installedSetuptools.getVersion(), SETUPTOOLS_VERSION) < 0) {
            this.installManagement(Objects.requireNonNull(this.getHelperPath(SETUPTOOLS_WHEEL_NAME)));
        }
        if (installedPip == null || PackageVersionComparator.VERSION_COMPARATOR.compare(installedPip.getVersion(), PIP_VERSION) < 0) {
            this.installManagement(Objects.requireNonNull(this.getHelperPath(PIP_WHEEL_NAME)));
        }
    }

    private boolean updatePackagingTools() {
        try {
            this.installUsingPipWheel("--upgrade", "--force-reinstall", "setuptools", "pip");
            boolean bl = true;
            return bl;
        }
        catch (ExecutionException e) {
            LOG.info((Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    public boolean hasManagement() throws ExecutionException {
        return this.refreshAndCheckForSetuptools() != null && PyPsiPackageUtil.findPackage(this.refreshAndGetPackages(false), "pip") != null;
    }

    @Nullable
    private PyPackage refreshAndCheckForSetuptools() throws ExecutionException {
        try {
            List<PyPackage> packages = this.refreshAndGetPackages(false);
            PyPackage setuptoolsPackage = PyPsiPackageUtil.findPackage(packages, "setuptools");
            return setuptoolsPackage != null ? setuptoolsPackage : PyPsiPackageUtil.findPackage(packages, "distribute");
        }
        catch (PyExecutionException e) {
            if (e.getExitCode() == 3) {
                return null;
            }
            throw e;
        }
    }

    protected void installManagement(@NotNull String name) throws ExecutionException {
        if (name == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(0);
        }
        this.installUsingPipWheel("--no-index", name);
    }

    private void installUsingPipWheel(String ... pipArgs) throws ExecutionException {
        if (pipArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(1);
        }
        String pipWheel = this.getHelperPath(PIP_WHEEL_NAME);
        ArrayList args2 = Lists.newArrayList((Object[])new String[]{INSTALL});
        args2.addAll(Arrays.asList(pipArgs));
        this.getPythonProcessResult(pipWheel + this.mySeparator + "pip", args2, true, true, null);
    }

    @NotNull
    protected String toSystemDependentName(@NotNull String dirName) {
        if (dirName == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(2);
        }
        String string = FileUtil.toSystemDependentName((String)dirName);
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected PyPackageManagerImpl(@NotNull Sdk sdk) {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(4);
        }
        this.mySeparator = File.separator;
        this.myPackagesCache = null;
        this.myUpdatingCache = new AtomicBoolean(false);
        this.mySdk = sdk;
        this.subscribeToLocalChanges();
    }

    protected void subscribeToLocalChanges() {
        PyPackageUtil.runOnChangeUnderInterpreterPaths(this.getSdk(), () -> PythonSdkType.getInstance().setupSdkPaths(this.getSdk()));
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(5);
        }
        return sdk;
    }

    @Override
    public void install(@NotNull String requirementString) throws ExecutionException {
        if (requirementString == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(6);
        }
        this.install(Collections.singletonList(this.parseRequirement(requirementString)), Collections.emptyList());
    }

    @Override
    public void install(@Nullable List<PyRequirement> requirements2, @NotNull List<String> extraArgs) throws ExecutionException {
        File buildDir;
        if (extraArgs == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(7);
        }
        if (requirements2 == null) {
            return;
        }
        if (!this.hasManagement()) {
            this.installManagement();
        }
        ArrayList<String> args2 = new ArrayList<String>();
        args2.add(INSTALL);
        try {
            buildDir = FileUtil.createTempDirectory((String)"pycharm-packaging", null);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create temporary build directory");
        }
        if (!extraArgs.contains(BUILD_DIR_OPTION)) {
            args2.addAll(Arrays.asList(BUILD_DIR_OPTION, buildDir.getAbsolutePath()));
        }
        boolean useUserSite = extraArgs.contains("--user");
        String proxyString = PyPackageManagerImpl.getProxyString();
        if (proxyString != null) {
            args2.add("--proxy");
            args2.add(proxyString);
        }
        args2.addAll(extraArgs);
        for (PyRequirement req : requirements2) {
            args2.addAll(req.getInstallOptions());
        }
        try {
            this.getHelperResult(PACKAGING_TOOL, args2, !useUserSite, true, null);
        }
        catch (PyExecutionException e) {
            ArrayList<String> simplifiedArgs = new ArrayList<String>();
            simplifiedArgs.add(INSTALL);
            if (proxyString != null) {
                simplifiedArgs.add("--proxy");
                simplifiedArgs.add(proxyString);
            }
            simplifiedArgs.addAll(extraArgs);
            for (PyRequirement req : requirements2) {
                simplifiedArgs.addAll(req.getInstallOptions());
            }
            throw new PyExecutionException(e.getMessage(), "pip", PyPackageManagerImpl.makeSafeToDisplayCommand(simplifiedArgs), e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these requirements were installed: " + requirements2);
            this.refreshPackagesSynchronously();
            FileUtil.delete((File)buildDir);
        }
    }

    @Override
    public void uninstall(@NotNull List<PyPackage> packages) throws ExecutionException {
        if (packages == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(8);
        }
        ArrayList<String> args2 = new ArrayList<String>();
        try {
            args2.add(UNINSTALL);
            boolean canModify = true;
            for (PyPackage pkg : packages) {
                String location;
                if (canModify && (location = pkg.getLocation()) != null) {
                    canModify = Files.isWritable(Paths.get(location, new String[0]));
                }
                args2.add(pkg.getName());
            }
            this.getHelperResult(PACKAGING_TOOL, args2, !canModify, true, null);
        }
        catch (PyExecutionException e) {
            throw new PyExecutionException(e.getMessage(), "pip", args2, e.getStdout(), e.getStderr(), e.getExitCode(), e.getFixes());
        }
        finally {
            LOG.debug("Packages cache is about to be refreshed because these packages were uninstalled: " + packages);
            this.refreshPackagesSynchronously();
        }
    }

    @Override
    @Nullable
    public List<PyPackage> getPackages() {
        List<PyPackage> packages = this.myPackagesCache;
        return packages != null ? Collections.unmodifiableList(packages) : null;
    }

    @NotNull
    protected List<PyPackage> collectPackages() throws ExecutionException {
        String output;
        if (this.mySdk instanceof PyLazySdk) {
            List<PyPackage> list = Collections.emptyList();
            if (list == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(9);
            }
            return list;
        }
        try {
            LOG.debug("Collecting installed packages for the SDK " + this.mySdk.getName(), new Throwable());
            output = this.getHelperResult(PACKAGING_TOOL, Collections.singletonList("list"), false, false, null);
        }
        catch (ProcessNotCreatedException ex) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.info("Not-env unit test mode, will return mock packages");
                ArrayList arrayList = Lists.newArrayList((Object[])new PyPackage[]{new PyPackage("pip", PIP_VERSION, null, Collections.emptyList()), new PyPackage("setuptools", SETUPTOOLS_VERSION, null, Collections.emptyList())});
                if (arrayList == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(10);
                }
                return arrayList;
            }
            throw ex;
        }
        return this.parsePackagingToolOutput(output);
    }

    @Override
    @NotNull
    public Set<PyPackage> getDependents(@NotNull PyPackage pkg) throws ExecutionException {
        if (pkg == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(11);
        }
        List<PyPackage> packages = this.refreshAndGetPackages(false);
        HashSet<PyPackage> dependents = new HashSet<PyPackage>();
        for (PyPackage p : packages) {
            List<PyRequirement> requirements2 = p.getRequirements();
            for (PyRequirement requirement : requirements2) {
                if (!requirement.getName().equals(pkg.getName())) continue;
                dependents.add(p);
            }
        }
        HashSet<PyPackage> hashSet = dependents;
        if (hashSet == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public String createVirtualEnv(@NotNull String destinationDir, boolean useGlobalSite) throws ExecutionException {
        VirtualFile binaryFile;
        String path;
        if (destinationDir == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(13);
        }
        ArrayList<String> args2 = new ArrayList<String>();
        Sdk sdk = this.getSdk();
        LanguageLevel languageLevel = PyPackageManagerImpl.getOrRequestLanguageLevelForSdk(sdk);
        if (languageLevel.isOlderThan(LanguageLevel.PYTHON27)) {
            throw new ExecutionException("Creating virtual environment for Python " + (Object)((Object)languageLevel) + " is not supported. Upgrade your project interpreter to Python " + (Object)((Object)LanguageLevel.PYTHON27) + " or newer");
        }
        boolean usePyVenv = languageLevel.isAtLeast(LanguageLevel.PYTHON33);
        if (usePyVenv) {
            args2.add("pyvenv");
            if (useGlobalSite) {
                args2.add("--system-site-packages");
            }
            args2.add(destinationDir);
            this.getHelperResult(PACKAGING_TOOL, args2, false, true, null);
        } else {
            if (useGlobalSite) {
                args2.add("--system-site-packages");
            }
            args2.add(destinationDir);
            this.createVirtualEnvForPython2UsingVirtualenvLibrary(args2);
        }
        String binary = PythonSdkUtil.getPythonExecutable(destinationDir);
        String binaryFallback = destinationDir + this.mySeparator + "bin" + this.mySeparator + "python";
        String string = path = binary != null ? binary : binaryFallback;
        if (usePyVenv && (binaryFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(path)) != null) {
            ProjectJdkImpl tmpSdk = new ProjectJdkImpl("", (SdkTypeId)PythonSdkType.getInstance());
            tmpSdk.setHomePath(path);
            PyPackageManagerImpl manager = new PyPackageManagerImpl((Sdk)tmpSdk);
            ((PyPackageManager)manager).installManagement();
        }
        String string2 = path;
        if (string2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(14);
        }
        return string2;
    }

    private void createVirtualEnvForPython2UsingVirtualenvLibrary(List<String> args2) throws ExecutionException {
        File workingDirectory = null;
        try {
            workingDirectory = FileUtil.createTempDirectory((String)"tmp", (String)"pycharm-management");
            String workingDirectoryPath = workingDirectory.getPath();
            this.getPythonProcessResult("-mzipfile", Arrays.asList("-e", this.getHelperPath(VIRTUALENV_WHEEL_NAME), workingDirectoryPath), false, true, workingDirectoryPath);
            this.getPythonProcessResult(workingDirectoryPath + "/virtualenv.py", args2, false, true, workingDirectoryPath);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create temporary build directory", (Throwable)e);
        }
        finally {
            if (workingDirectory != null) {
                FileUtil.delete((File)workingDirectory);
            }
        }
    }

    @NotNull
    private static LanguageLevel getOrRequestLanguageLevelForSdk(@NotNull Sdk sdk) throws ExecutionException {
        if (sdk == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(15);
        }
        if (sdk instanceof PyDetectedSdk) {
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(sdk);
            if (flavor != null && sdk.getHomePath() != null) {
                LanguageLevel languageLevel = flavor.getLanguageLevel(sdk.getHomePath());
                if (languageLevel == null) {
                    PyPackageManagerImpl.$$$reportNull$$$0(16);
                }
                return languageLevel;
            }
            throw new ExecutionException("Cannot retrieve the version of the detected SDK: " + sdk.getHomePath());
        }
        LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
        if (languageLevel == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(17);
        }
        return languageLevel;
    }

    @Override
    @Nullable
    public List<PyRequirement> getRequirements(@NotNull Module module) {
        if (module == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(18);
        }
        return Optional.ofNullable(PyPackageUtil.getRequirementsFromTxt(module)).orElseGet(() -> PyPackageUtil.findSetupPyRequires(module));
    }

    @Override
    @Nullable
    public PyRequirement parseRequirement(@NotNull String line2) {
        if (line2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(19);
        }
        return PyRequirementParser.fromLine(line2);
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull String text2) {
        if (text2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(20);
        }
        List<PyRequirement> list = PyRequirementParser.fromText(text2);
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyRequirement> parseRequirements(@NotNull VirtualFile file) {
        if (file == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(22);
        }
        List<PyRequirement> list = PyRequirementParser.fromFile(file);
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(23);
        }
        return list;
    }

    @Override
    @NotNull
    public List<PyPackage> refreshAndGetPackages(boolean alwaysRefresh) throws ExecutionException {
        List<PyPackage> currentPackages = this.myPackagesCache;
        if (alwaysRefresh || currentPackages == null) {
            List<PyPackage> list;
            this.myPackagesCache = null;
            try {
                List<PyPackage> packages = this.collectPackages();
                LOG.debug("Packages installed in " + this.mySdk.getName() + ": " + packages);
                this.myPackagesCache = packages;
                ((PyPackageManager.Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(PACKAGE_MANAGER_TOPIC)).packagesRefreshed(this.mySdk);
                list = Collections.unmodifiableList(packages);
            }
            catch (ExecutionException e) {
                this.myPackagesCache = Collections.emptyList();
                throw e;
            }
            if (list == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(24);
            }
            return list;
        }
        List<PyPackage> list = Collections.unmodifiableList(currentPackages);
        if (list == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    private void refreshPackagesSynchronously() {
        PyPackageUtil.updatePackagesSynchronouslyWithGuard(this, this.myUpdatingCache);
    }

    @Nullable
    private static String getProxyString() {
        HttpConfigurable settings = HttpConfigurable.getInstance();
        if (settings != null && settings.USE_HTTP_PROXY) {
            String credentials = settings.PROXY_AUTHENTICATION ? String.format("%s:%s@", settings.getProxyLogin(), settings.getPlainProxyPassword()) : "";
            return "http://" + credentials + String.format("%s:%d", settings.PROXY_HOST, settings.PROXY_PORT);
        }
        return null;
    }

    @NotNull
    private String getHelperResult(@NotNull String helper, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String parentDir) throws ExecutionException {
        String helperPath;
        if (helper == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(26);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(27);
        }
        if ((helperPath = this.getHelperPath(helper)) == null) {
            throw new ExecutionException("Cannot find external tool: " + helper);
        }
        return this.getPythonProcessResult(helperPath, args2, askForSudo, showProgress, parentDir);
    }

    @Nullable
    protected String getHelperPath(@NotNull String helper) throws ExecutionException {
        if (helper == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(28);
        }
        return PythonHelpersLocator.getHelperPath(helper);
    }

    @NotNull
    private String getPythonProcessResult(@NotNull String path, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        if (path == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(29);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(30);
        }
        ProcessOutput output = this.getPythonProcessOutput(path, args2, askForSudo, showProgress, workingDir);
        int exitCode = output.getExitCode();
        if (output.isTimeout()) {
            throw new PyExecutionException("Timed out", path, args2, output);
        }
        if (exitCode != 0) {
            throw new PyExecutionException("Non-zero exit code (" + exitCode + ")", path, args2, output);
        }
        String string = output.getStdout();
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(31);
        }
        return string;
    }

    @NotNull
    protected ProcessOutput getPythonProcessOutput(@NotNull String helperPath, @NotNull List<String> args2, boolean askForSudo, boolean showProgress, @Nullable String workingDir) throws ExecutionException {
        ProcessOutput processOutput;
        String homePath;
        if (helperPath == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(32);
        }
        if (args2 == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(33);
        }
        if ((homePath = this.getSdk().getHomePath()) == null) {
            throw new ExecutionException("Cannot find Python interpreter for SDK " + this.mySdk.getName());
        }
        if (workingDir == null) {
            workingDir = new File(homePath).getParent();
        }
        ArrayList<String> cmdline = new ArrayList<String>();
        cmdline.add(homePath);
        cmdline.add(helperPath);
        cmdline.addAll(args2);
        LOG.info("Running packaging tool: " + StringUtil.join(PyPackageManagerImpl.makeSafeToDisplayCommand(cmdline), (String)" "));
        try {
            ProcessOutput result;
            GeneralCommandLine commandLine = new GeneralCommandLine(cmdline).withWorkDirectory(workingDir).withEnvironment(PySdkUtil.activateVirtualEnv(this.getSdk()));
            Map environment = commandLine.getEnvironment();
            PythonEnvUtil.setPythonUnbuffered(environment);
            PythonEnvUtil.setPythonDontWriteBytecode(environment);
            PythonEnvUtil.resetHomePathChanges(homePath, environment);
            PythonSdkFlavor flavor = PythonSdkFlavor.getFlavor(this.mySdk);
            if (flavor != null && flavor.commandLinePatcher() != null) {
                flavor.commandLinePatcher().patchCommandLine(commandLine);
            }
            boolean useSudo = askForSudo && PySdkExtKt.adminPermissionsNeeded(this.mySdk);
            Process process2 = useSudo ? ExecUtil.sudo((GeneralCommandLine)commandLine, (String)"Please enter your password to make changes in system packages: ") : commandLine.createProcess();
            CapturingProcessHandler handler = new CapturingProcessHandler(process2, commandLine.getCharset(), commandLine.getCommandLineString());
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (showProgress && indicator != null) {
                handler.addProcessListener((ProcessListener)new IndicatedProcessOutputListener(indicator));
                result = handler.runProcessWithProgressIndicator(indicator);
            } else {
                result = handler.runProcess(600000);
            }
            if (result.isCancelled()) {
                throw new RunCanceledByUserException();
            }
            result.checkSuccess(LOG);
            int exitCode = result.getExitCode();
            if (exitCode != 0) {
                String message = StringUtil.isEmptyOrSpaces((String)result.getStdout()) && StringUtil.isEmptyOrSpaces((String)result.getStderr()) ? "Permission denied" : "Non-zero exit code (" + exitCode + ")";
                throw new PyExecutionException(message, helperPath, args2, result);
            }
            processOutput = result;
        }
        catch (IOException e) {
            throw new PyExecutionException(e.getMessage(), helperPath, args2);
        }
        if (processOutput == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(34);
        }
        return processOutput;
    }

    @NotNull
    private static List<String> makeSafeToDisplayCommand(@NotNull List<String> cmdline) {
        if (cmdline == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(35);
        }
        ArrayList<String> safeCommand = new ArrayList<String>(cmdline);
        for (int i = 0; i < safeCommand.size(); ++i) {
            if (!cmdline.get(i).equals("--proxy") || i + 1 >= cmdline.size()) continue;
            safeCommand.set(i + 1, PyPackageManagerImpl.makeSafeProxyArgument(cmdline.get(i + 1)));
        }
        ArrayList<String> arrayList = safeCommand;
        if (arrayList == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    private static String makeSafeProxyArgument(@NotNull String proxyArgument) {
        block5: {
            String string;
            if (proxyArgument == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(37);
            }
            try {
                int colonIndex;
                URI proxyUri = new URI(proxyArgument);
                String credentials = proxyUri.getUserInfo();
                if (credentials == null || (colonIndex = credentials.indexOf(":")) < 0) break block5;
                String login = credentials.substring(0, colonIndex);
                String password = credentials.substring(colonIndex + 1);
                String maskedPassword = StringUtil.repeatSymbol((char)'*', (int)password.length());
                String maskedCredentials = login + ":" + maskedPassword;
                string = proxyArgument.replaceFirst(Pattern.quote(credentials), maskedCredentials);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (string == null) {
                PyPackageManagerImpl.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = proxyArgument;
        if (string == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    private List<PyPackage> parsePackagingToolOutput(@NotNull String s) throws ExecutionException {
        if (s == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(40);
        }
        String[] lines = StringUtil.splitByLines((String)s);
        ArrayList<PyPackage> packages = new ArrayList<PyPackage>();
        for (String line2 : lines) {
            List fields = StringUtil.split((String)line2, (String)"\t");
            if (fields.size() < 3) {
                throw new PyExecutionException("Invalid output format", PACKAGING_TOOL, Collections.emptyList());
            }
            String name = (String)fields.get(0);
            String version = (String)fields.get(1);
            String location = (String)fields.get(2);
            ArrayList<PyRequirement> requirements2 = new ArrayList<PyRequirement>();
            if (fields.size() >= 4) {
                String requiresLine = (String)fields.get(3);
                String requiresSpec = StringUtil.join((Collection)StringUtil.split((String)requiresLine, (String)":"), (String)"\n");
                requirements2.addAll(this.parseRequirements(requiresSpec));
            }
            if ("Python".equals(name)) continue;
            packages.add(new PyPackage(name, version, location, requirements2));
        }
        ArrayList<PyPackage> arrayList = packages;
        if (arrayList == null) {
            PyPackageManagerImpl.$$$reportNull$$$0(41);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipArgs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 4: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requirementString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destinationDir";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 27: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helperPath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdline";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "proxyArgument";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toSystemDependentName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackages";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependents";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createVirtualEnv";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRequirements";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "refreshAndGetPackages";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessResult";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getPythonProcessOutput";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeToDisplayCommand";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "makeSafeProxyArgument";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackagingToolOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "installManagement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installUsingPipWheel";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toSystemDependentName";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = INSTALL;
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = UNINSTALL;
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getDependents";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createVirtualEnv";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrRequestLanguageLevelForSdk";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRequirements";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirement";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseRequirements";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getHelperResult";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getHelperPath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessResult";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getPythonProcessOutput";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeToDisplayCommand";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "makeSafeProxyArgument";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "parsePackagingToolOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 16: 
            case 17: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 31: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

