/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.validation;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringReferenceProvider;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.EpydocString;
import com.jetbrains.python.documentation.docstrings.SphinxDocString;
import com.jetbrains.python.highlighting.PyHighlighter;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.validation.PyAnnotator;

public class DocStringAnnotator
extends PyAnnotator {
    @Override
    public void visitPyFile(PyFile node) {
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node));
    }

    @Override
    public void visitPyFunction(PyFunction node) {
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyClass(PyClass node) {
        this.annotateDocStringStmt(DocStringUtil.findDocStringExpression(node.getStatementList()));
    }

    @Override
    public void visitPyAssignmentStatement(PyAssignmentStatement node) {
        PyExpression right;
        if (node.isAssignmentTo("__doc__") && (right = node.getAssignedValue()) instanceof PyStringLiteralExpression) {
            this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range((PsiElement)right).textAttributes(PyHighlighter.PY_DOC_COMMENT).create();
            this.annotateDocStringStmt((PyStringLiteralExpression)right);
        }
    }

    @Override
    public void visitPyExpressionStatement(PyExpressionStatement node) {
        if (node.getExpression() instanceof PyStringLiteralExpression && DocStringUtil.isVariableDocString((PyStringLiteralExpression)node.getExpression())) {
            this.annotateDocStringStmt((PyStringLiteralExpression)node.getExpression());
        }
    }

    private void annotateDocStringStmt(PyStringLiteralExpression stmt) {
        if (stmt != null) {
            TextRange textRange;
            String[] tags;
            DocStringFormat format = DocStringUtil.getConfiguredDocStringFormat(stmt);
            if (format == DocStringFormat.EPYTEXT) {
                tags = EpydocString.ALL_TAGS;
            } else if (format == DocStringFormat.REST) {
                tags = SphinxDocString.ALL_TAGS;
            } else {
                return;
            }
            int pos = 0;
            while ((textRange = DocStringReferenceProvider.findNextTag(stmt.getText(), pos, tags)) != null) {
                this.getHolder().newSilentAnnotation(HighlightSeverity.INFORMATION).range(textRange.shiftRight(stmt.getTextRange().getStartOffset())).textAttributes(PyHighlighter.PY_DOC_COMMENT_TAG).create();
                pos = textRange.getEndOffset();
            }
        }
    }
}

