/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rest;

import com.google.common.collect.Maps;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.rest.RestTokenTypes;
import com.jetbrains.rest.lexer.RestFlexLexer;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RestSyntaxHighlighter
extends SyntaxHighlighterBase
implements RestTokenTypes {
    public static final TextAttributesKey REST_COMMENT = TextAttributesKey.createTextAttributesKey((String)"REST.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
    public static final TextAttributesKey REST_SECTION_HEADER = TextAttributesKey.createTextAttributesKey((String)"REST.SECTION.HEADER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
    public static final TextAttributesKey REST_BOLD = TextAttributesKey.createTextAttributesKey((String)"REST.BOLD", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey REST_ITALIC = TextAttributesKey.createTextAttributesKey((String)"REST.ITALIC", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey REST_FIXED = TextAttributesKey.createTextAttributesKey((String)"REST.FIXED", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey REST_INTERPRETED = TextAttributesKey.createTextAttributesKey((String)"REST.INTERPRETED", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    public static final TextAttributesKey REST_REF_NAME = TextAttributesKey.createTextAttributesKey((String)"REST.REF.NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
    public static final TextAttributesKey REST_EXPLICIT = TextAttributesKey.createTextAttributesKey((String)"REST.EXPLICIT", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey REST_FIELD = TextAttributesKey.createTextAttributesKey((String)"REST.FIELD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
    public static final TextAttributesKey REST_INLINE = TextAttributesKey.createTextAttributesKey((String)"REST.INLINE", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = Maps.newHashMap();

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = SyntaxHighlighterBase.pack((TextAttributesKey)ATTRIBUTES.get(tokenType));
        if (textAttributesKeyArray == null) {
            RestSyntaxHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new RestFlexLexer();
    }

    static {
        ATTRIBUTES.put(REFERENCE_NAME, REST_REF_NAME);
        ATTRIBUTES.put(DIRECT_HYPERLINK, REST_REF_NAME);
        ATTRIBUTES.put(TITLE, REST_SECTION_HEADER);
        ATTRIBUTES.put(TITLE_TEXT, REST_SECTION_HEADER);
        ATTRIBUTES.put(FOOTNOTE, REST_EXPLICIT);
        ATTRIBUTES.put(CITATION, REST_EXPLICIT);
        ATTRIBUTES.put(HYPERLINK, REST_REF_NAME);
        ATTRIBUTES.put(ANONYMOUS_HYPERLINK, REST_REF_NAME);
        ATTRIBUTES.put(DIRECTIVE, REST_EXPLICIT);
        ATTRIBUTES.put(CUSTOM_DIRECTIVE, REST_EXPLICIT);
        ATTRIBUTES.put(SUBSTITUTION, REST_EXPLICIT);
        ATTRIBUTES.put(COMMENT, REST_COMMENT);
        ATTRIBUTES.put(FIELD, REST_FIELD);
        ATTRIBUTES.put(BOLD, REST_BOLD);
        ATTRIBUTES.put(ITALIC, REST_ITALIC);
        ATTRIBUTES.put(FIXED, REST_FIXED);
        ATTRIBUTES.put(INTERPRETED, REST_INTERPRETED);
        ATTRIBUTES.put(INLINE_LINE, REST_INLINE);
        ATTRIBUTES.put(PYTHON_LINE, REST_INLINE);
        ATTRIBUTES.put(DJANGO_LINE, REST_INLINE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/rest/RestSyntaxHighlighter", "getTokenHighlights"));
    }
}

