/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleAsVirtualFile;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleUtil {
    private ResourceBundleUtil() {
    }

    @Nullable
    public static ResourceBundle getResourceBundleFromDataContext(@NotNull DataContext dataContext) {
        PsiFile psiFile;
        PsiElement element;
        if (dataContext == null) {
            ResourceBundleUtil.$$$reportNull$$$0(0);
        }
        if ((element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) instanceof IProperty) {
            return null;
        }
        ResourceBundle[] bundles = (ResourceBundle[])ResourceBundle.ARRAY_DATA_KEY.getData(dataContext);
        if (bundles != null && bundles.length == 1) {
            return bundles[0];
        }
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (virtualFile == null || !virtualFile.isValid()) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (virtualFile instanceof ResourceBundleAsVirtualFile && project != null) {
            return ((ResourceBundleAsVirtualFile)virtualFile).getResourceBundle();
        }
        if (project != null && (psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile)) instanceof PropertiesFile) {
            return ((PropertiesFile)psiFile).getResourceBundle();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/lang/properties/editor/ResourceBundleUtil", "getResourceBundleFromDataContext"));
    }
}

