/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.ide.actions.ContextHelpAction;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.JBColor;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.table.TableView;
import com.intellij.util.EventDispatcher;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.EmptyPane;
import com.intellij.util.xml.ui.StripeTableCellRenderer;
import com.intellij.util.xml.ui.TooltipUtils;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ToolTipManager;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTableView<T>
extends JPanel
implements TypeSafeDataProvider {
    private final MyTableView myTable = new MyTableView();
    private final String myHelpID;
    private final String myEmptyPaneText;
    private final JPanel myInnerPanel;
    private final Project myProject;
    private TableCellRenderer[][] myCachedRenderers;
    private EmptyPane myEmptyPane;
    @NonNls
    private static final String TREE = "Tree";
    @NonNls
    private static final String EMPTY_PANE = "EmptyPane";
    private final EventDispatcher<ChangeListener> myDispatcher = EventDispatcher.create(ChangeListener.class);
    private final MyListTableModel myTableModel = new MyListTableModel();

    public AbstractTableView(Project project) {
        this(project, null, null);
    }

    public AbstractTableView(Project project, String emptyPaneText, String helpID) {
        super(new BorderLayout());
        this.myProject = project;
        this.myTableModel.setSortable(false);
        this.myEmptyPaneText = emptyPaneText;
        this.myHelpID = helpID;
        JTableHeader header = this.myTable.getTableHeader();
        header.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                AbstractTableView.this.updateTooltip(e);
            }
        });
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                AbstractTableView.this.updateTooltip(e);
            }
        });
        header.setReorderingAllowed(false);
        this.myTable.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight());
        this.myTable.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)-1, (int)150));
        this.myTable.setSelectionMode(this.allowMultipleRowsSelection() ? 2 : 0);
        this.myInnerPanel = new JPanel(new CardLayout());
        this.myInnerPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTable)), TREE);
        if (this.getEmptyPaneText() != null) {
            this.myEmptyPane = new EmptyPane(XmlStringUtil.wrapInHtml((CharSequence)this.getEmptyPaneText()));
            JComponent emptyPanel = this.myEmptyPane.getComponent();
            this.myInnerPanel.add((Component)emptyPanel, EMPTY_PANE);
        }
        this.add((Component)this.myInnerPanel, "Center");
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTable));
    }

    protected TableCellRenderer getTableCellRenderer(int row, int column, TableCellRenderer superRenderer, Object value) {
        return this.getTableModel().getColumnInfos()[column].getCustomizedRenderer(value, (TableCellRenderer)new StripeTableCellRenderer(superRenderer));
    }

    protected final void installPopup(String place, DefaultActionGroup group) {
        PopupHandler.installPopupHandler((JComponent)((Object)this.myTable), (ActionGroup)group, (String)place, (ActionManager)ActionManager.getInstance());
    }

    public final void setToolbarActions(AnAction ... actions) {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        for (AnAction action : actions) {
            actionGroup.add(action);
        }
        if (this.getHelpId() != null) {
            actionGroup.add((AnAction)Separator.getInstance());
            actionGroup.add((AnAction)new ContextHelpAction(this.getHelpId()));
        }
        ActionManager actionManager = ActionManager.getInstance();
        ToolbarPosition position = this.getToolbarPosition();
        final ActionToolbar myActionToolbar = actionManager.createActionToolbar("ProjectViewToolbar", (ActionGroup)actionGroup, position == ToolbarPosition.TOP || position == ToolbarPosition.BOTTOM);
        myActionToolbar.setTargetComponent((JComponent)this.myInnerPanel);
        JComponent toolbarComponent = myActionToolbar.getComponent();
        MatteBorder matteBorder = BorderFactory.createMatteBorder(0, 0, position == ToolbarPosition.TOP ? 1 : 0, 0, (Color)JBColor.DARK_GRAY);
        toolbarComponent.setBorder(BorderFactory.createCompoundBorder(matteBorder, toolbarComponent.getBorder()));
        this.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                myActionToolbar.updateActionsImmediately();
            }
        });
        this.add((Component)toolbarComponent, position.getPosition());
    }

    protected final void setErrorMessages(String[] messages) {
        boolean empty = messages.length == 0;
        String tooltipText = TooltipUtils.getTooltipText(messages);
        if (this.myEmptyPane != null) {
            this.myEmptyPane.getComponent().setBackground(empty ? UIUtil.getTreeBackground() : BaseControl.ERROR_BACKGROUND);
            this.myEmptyPane.getComponent().setToolTipText(tooltipText);
        }
        JViewport viewport = (JViewport)this.myTable.getParent();
        Color tableBackground = empty ? UIUtil.getTableBackground() : BaseControl.ERROR_BACKGROUND;
        viewport.setBackground(tableBackground);
        viewport.setToolTipText(tooltipText);
        this.myTable.setBackground(tableBackground);
        this.myTable.setToolTipText(tooltipText);
        if (tooltipText == null) {
            ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this.myTable));
        }
    }

    protected final void initializeTable() {
        this.myTable.setModelAndUpdateColumns(this.myTableModel);
        if (this.getEmptyPaneText() != null) {
            final CardLayout cardLayout = (CardLayout)this.myInnerPanel.getLayout();
            this.myTable.getModel().addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    cardLayout.show(AbstractTableView.this.myInnerPanel, AbstractTableView.this.myTable.getRowCount() == 0 ? AbstractTableView.EMPTY_PANE : AbstractTableView.TREE);
                }
            });
        }
        this.tuneTable((JTable)((Object)this.myTable));
    }

    protected void adjustColumnWidths() {
        ColumnInfo[] columnInfos = this.myTableModel.getColumnInfos();
        for (int i = 0; i < columnInfos.length; ++i) {
            int width = this.getColumnPreferredWidth(i);
            if (width <= 0) continue;
            this.myTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }

    protected int getColumnPreferredWidth(int i) {
        ColumnInfo columnInfo = this.myTableModel.getColumnInfos()[i];
        List items = this.myTableModel.getItems();
        int width = -1;
        for (int j = 0; j < items.size(); ++j) {
            TableCellRenderer renderer = this.myTable.getCellRenderer(j, i);
            Component component = renderer.getTableCellRendererComponent((JTable)((Object)this.myTable), columnInfo.valueOf(items.get(j)), false, false, j, i);
            width = Math.max(width, component.getPreferredSize().width);
        }
        return width;
    }

    protected String getEmptyPaneText() {
        return this.myEmptyPaneText;
    }

    protected final void updateTooltip(MouseEvent e) {
        int i = this.myTable.columnAtPoint(e.getPoint());
        if (i >= 0) {
            this.myTable.getTableHeader().setToolTipText(this.myTableModel.getColumnInfos()[i].getTooltipText());
        }
    }

    protected void tuneTable(JTable table) {
    }

    protected boolean allowMultipleRowsSelection() {
        return true;
    }

    public final JTable getTable() {
        return this.myTable;
    }

    public final ListTableModel getTableModel() {
        return this.myTableModel;
    }

    public void calcData(@NotNull DataKey key, @NotNull DataSink sink) {
        if (key == null) {
            AbstractTableView.$$$reportNull$$$0(0);
        }
        if (sink == null) {
            AbstractTableView.$$$reportNull$$$0(1);
        }
        if (PlatformDataKeys.HELP_ID.equals(key)) {
            sink.put(PlatformDataKeys.HELP_ID, (Object)this.getHelpId());
        }
    }

    private String getHelpId() {
        return this.myHelpID;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    public final void reset(ColumnInfo[] columnInfos, List<? extends T> data) {
        boolean columnsChanged = this.myTableModel.setColumnInfos(columnInfos);
        boolean dataChanged = !data.equals(this.myTableModel.getItems());
        int oldRowCount = this.myTableModel.getRowCount();
        if ((dataChanged || columnsChanged) && this.myTable.isEditing()) {
            this.myTable.getCellEditor().cancelCellEditing();
        }
        if (dataChanged) {
            int selectedRow = this.myTable.getSelectedRow();
            this.myTableModel.setItems(new ArrayList<T>(data));
            if (selectedRow >= 0 && selectedRow < this.myTableModel.getRowCount()) {
                this.myTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            }
        }
        this.myTableModel.cacheValues();
        int rowCount = this.myTableModel.getRowCount();
        int columnCount = this.myTableModel.getColumnCount();
        this.myCachedRenderers = new TableCellRenderer[rowCount][columnCount];
        for (int row = 0; row < rowCount; ++row) {
            for (int column = 0; column < columnCount; ++column) {
                TableCellRenderer superRenderer = this.myTable.getSuperCellRenderer(row, column);
                this.myCachedRenderers[row][column] = this.getTableCellRenderer(row, column, superRenderer, this.myTableModel.getItems().get(row));
            }
        }
        if (columnsChanged || oldRowCount == 0 && rowCount != 0) {
            this.adjustColumnWidths();
        }
        this.myTable.revalidate();
        this.myTable.repaint();
    }

    protected abstract void wrapValueSetting(@NotNull T var1, Runnable var2);

    protected final void fireChanged() {
        ((ChangeListener)this.myDispatcher.getMulticaster()).changed();
    }

    protected void dispose() {
    }

    public final Project getProject() {
        return this.myProject;
    }

    protected ToolbarPosition getToolbarPosition() {
        return ToolbarPosition.TOP;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "key";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sink";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/xml/ui/AbstractTableView";
        objectArray[2] = "calcData";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class MyTableView
    extends TableView {
        protected MyTableView() {
        }

        public final TableCellRenderer getSuperCellRenderer(int row, int column) {
            return super.getCellRenderer(row, column);
        }

        public final TableCellRenderer getCellRenderer(int row, int column) {
            return AbstractTableView.this.myCachedRenderers[row][column];
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void changed();
    }

    protected static enum ToolbarPosition {
        TOP("North"),
        LEFT("West"),
        RIGHT("East"),
        BOTTOM("South");

        private final String myPosition;

        private ToolbarPosition(String position) {
            this.myPosition = position;
        }

        public String getPosition() {
            return this.myPosition;
        }
    }

    private class MyListTableModel
    extends ListTableModel<T> {
        private Object[][] myTableData;

        MyListTableModel() {
            super(ColumnInfo.EMPTY_ARRAY);
            this.setSortable(false);
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.myTableData[rowIndex][columnIndex];
        }

        void cacheValues() {
            int rowCount = this.getRowCount();
            int columnCount = this.getColumnCount();
            Object[][] objects = new Object[rowCount][columnCount];
            for (int i = 0; i < rowCount; ++i) {
                for (int j = 0; j < columnCount; ++j) {
                    objects[i][j] = super.getValueAt(i, j);
                }
            }
            this.myTableData = objects;
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            Object oldValue = this.getValueAt(rowIndex, columnIndex);
            if (!Comparing.equal((Object)oldValue, (Object)aValue)) {
                AbstractTableView.this.wrapValueSetting(this.getItems().get(rowIndex), () -> super.setValueAt("".equals(aValue) ? null : aValue, rowIndex, columnIndex));
            }
        }
    }
}

