/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement.editor;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.util.ConcurrencyUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

class DocumentChangeInactivityDetector
implements DocumentListener {
    private static final int CHECK_DELAY = 500;
    private final ScheduledExecutorService myExecutorService;
    private static final Logger LOG = Logger.getInstance(DocumentChangeInactivityDetector.class);
    private volatile long myLastChangeTime;
    private volatile long myLastDocStamp;
    private final Document myDocument;
    private final List<InactivityListener> myListeners;

    DocumentChangeInactivityDetector(@NotNull Document document) {
        if (document == null) {
            DocumentChangeInactivityDetector.$$$reportNull$$$0(0);
        }
        this.myListeners = new ArrayList<InactivityListener>();
        this.myDocument = document;
        this.myExecutorService = ConcurrencyUtil.newSingleScheduledThreadExecutor((String)"DocumentChangeInactivityDetector");
    }

    void addListener(@NotNull InactivityListener listener) {
        if (listener == null) {
            DocumentChangeInactivityDetector.$$$reportNull$$$0(1);
        }
        this.myListeners.add(listener);
    }

    void removeListener(@NotNull InactivityListener listener) {
        if (listener == null) {
            DocumentChangeInactivityDetector.$$$reportNull$$$0(2);
        }
        this.myListeners.remove(listener);
    }

    void start() {
        this.myLastChangeTime = System.currentTimeMillis();
        this.myExecutorService.scheduleAtFixedRate(() -> this.checkLastUpdate(), 500L, 500L, TimeUnit.MILLISECONDS);
    }

    void stop() {
        this.myExecutorService.shutdown();
    }

    private void checkLastUpdate() {
        if (System.currentTimeMillis() - this.myLastChangeTime > 500L && this.myDocument.getModificationStamp() != this.myLastDocStamp) {
            this.myLastDocStamp = this.myDocument.getModificationStamp();
            for (InactivityListener listener : this.myListeners) {
                try {
                    listener.onInactivity();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        }
    }

    public void documentChanged(@NotNull DocumentEvent event) {
        if (event == null) {
            DocumentChangeInactivityDetector.$$$reportNull$$$0(3);
        }
        this.myLastChangeTime = System.currentTimeMillis();
        this.myLastDocStamp = event.getOldTimeStamp();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "org/editorconfig/configmanagement/editor/DocumentChangeInactivityDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeListener";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "documentChanged";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface InactivityListener {
        public void onInactivity();
    }
}

