/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import com.intellij.grazie.speller.lists.TraversableWordList;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.grazie.dictionary.EditableAggregatedWordList;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0005J\u0006\u0010\u001b\u001a\u00020\u0012R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/EditableWordListAdapter;", "", "()V", "dictionaries", "Lgnu/trove/THashMap;", "", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "getDictionaries", "()Lgnu/trove/THashMap;", "names", "", "getNames", "()Ljava/util/Set;", "traversable", "Lcom/intellij/spellchecker/grazie/dictionary/EditableAggregatedWordList;", "getTraversable", "()Lcom/intellij/spellchecker/grazie/dictionary/EditableAggregatedWordList;", "addDictionary", "", "dictionary", "addList", "name", "list", "Lcom/intellij/grazie/speller/lists/TraversableWordList;", "containsSource", "", "removeSource", "reset", "intellij.spellchecker"})
public abstract class EditableWordListAdapter {
    @NotNull
    private final THashMap<String, Dictionary> dictionaries = new THashMap();
    @NotNull
    private final EditableAggregatedWordList traversable = new EditableAggregatedWordList();

    @NotNull
    protected final THashMap<String, Dictionary> getDictionaries() {
        return this.dictionaries;
    }

    @NotNull
    protected final EditableAggregatedWordList getTraversable() {
        return this.traversable;
    }

    @NotNull
    public final Set<String> getNames() {
        Set<String> set = this.traversable.getKeys();
        Set set2 = this.dictionaries.keySet();
        Intrinsics.checkExpressionValueIsNotNull((Object)set2, (String)"dictionaries.keys");
        return SetsKt.plus(set, (Iterable)set2);
    }

    public final void addDictionary(@NotNull Dictionary dictionary) {
        Intrinsics.checkParameterIsNotNull((Object)dictionary, (String)"dictionary");
        ((Map)this.dictionaries).put(dictionary.getName(), dictionary);
    }

    public final void addList(@NotNull String name, @NotNull TraversableWordList list) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)list, (String)"list");
        this.traversable.addList(name, list);
    }

    public final boolean containsSource(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return this.dictionaries.containsKey((Object)name) || this.traversable.containsList(name);
    }

    public final void removeSource(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.dictionaries.remove((Object)name);
        this.traversable.removeList(name);
    }

    public final void reset() {
        this.dictionaries.clear();
        this.traversable.clear();
    }
}

