/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.diagnostic.Activity;
import com.intellij.diagnostic.LoadingState;
import com.intellij.diagnostic.PluginException;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.ide.plugins.CachingSemiGraph;
import com.intellij.ide.plugins.ClassPathXmlPathResolver;
import com.intellij.ide.plugins.DescriptorListLoadingContext;
import com.intellij.ide.plugins.DescriptorLoadingContext;
import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.PathBasedJdomXIncluder;
import com.intellij.ide.plugins.PluginDependency;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginError;
import com.intellij.ide.plugins.PluginLoadingResult;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.plugins.PluginManagerState;
import com.intellij.ide.plugins.PluginXmlPathResolver;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionInstantiationException;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.LineSeparator;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphAlgorithms;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import com.intellij.util.lang.UrlClassLoader;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PluginManagerCore {
    public static final String META_INF = "META-INF/";
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";
    public static final PluginId CORE_ID = PluginId.getId((String)"com.intellij");
    public static final String CORE_PLUGIN_ID = "com.intellij";
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId((String)"com.intellij.java");
    private static final PluginId JAVA_MODULE_ID = PluginId.getId((String)"com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    private static final PluginId ALL_MODULES_MARKER = PluginId.getId((String)"com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    private static final String MODULE_DEPENDENCY_PREFIX = "com.intellij.module";
    private static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId((String)"IDEA CORE");
    static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String EDIT = "edit";
    private static Reference<Map<PluginId, Set<String>>> ourBrokenPluginVersions;
    private static volatile IdeaPluginDescriptorImpl[] ourPlugins;
    static volatile List<IdeaPluginDescriptorImpl> ourLoadedPlugins;
    private static List<PluginError> ourLoadingErrors;
    private static Map<String, String[]> ourAdditionalLayoutMap;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    static final boolean usePluginClassLoader;
    @ApiStatus.Internal
    public static String ourPluginError;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToDisable;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToEnable;
    @ApiStatus.Internal
    public static boolean ourDisableNonBundledPlugins;
    private static Set<PluginId> ourShadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<DescriptorListLoadingContext> descriptorListFuture;
    private static BuildNumber ourBuildNumber;

    @ApiStatus.Internal
    @Nullable
    public static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] result2 = ourPlugins;
        if (result2 == null) {
            PluginManagerCore.loadAndInitializePlugins(null, null);
            if (ourPlugins == null) {
                PluginManagerCore.$$$reportNull$$$0(0);
            }
            return ourPlugins;
        }
        if (result2 == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return result2;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        return PluginManagerCore.getLoadedPlugins(null);
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        List<IdeaPluginDescriptorImpl> result2 = ourLoadedPlugins;
        if (result2 == null) {
            PluginManagerCore.loadAndInitializePlugins(null, coreClassLoader);
            List<IdeaPluginDescriptorImpl> list2 = ourLoadedPlugins;
            if (list2 == null) {
                PluginManagerCore.$$$reportNull$$$0(2);
            }
            return list2;
        }
        List<IdeaPluginDescriptorImpl> list3 = result2;
        if (list3 == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return ourPlugins != null;
    }

    @ApiStatus.Internal
    static synchronized void doSetPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] value2) {
        if (value2 == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        ourPlugins = value2;
        ourLoadedPlugins = Collections.unmodifiableList(PluginManagerCore.getOnlyEnabledPlugins(value2));
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        return DisabledPluginsState.getDisabledIds().contains(pluginId);
    }

    @Deprecated
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return DisabledPluginsState.getDisabledIds().contains(PluginId.getId((String)pluginId));
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor2) {
        PluginId pluginId;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        if ((pluginId = descriptor2.getPluginId()) == null) {
            return true;
        }
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set != null && set.contains(descriptor2.getVersion());
    }

    @NotNull
    private static Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result2 = (Map<PluginId, Set<String>>)com.intellij.reference.SoftReference.dereference(ourBrokenPluginVersions);
        if (result2 != null) {
            Map<PluginId, Set<String>> map2 = result2;
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return map2;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            result2 = Collections.emptyMap();
            ourBrokenPluginVersions = new SoftReference(result2);
            Map<PluginId, Set<String>> map3 = result2;
            if (map3 == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return map3;
        }
        result2 = new HashMap();
        try (InputStream resource = PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt");
             BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String s;
            while ((s = br.readLine()) != null) {
                List tokens;
                if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse((String)s)).isEmpty()) continue;
                if (tokens.size() == 1) {
                    throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                }
                PluginId pluginId = PluginId.getId((String)((String)tokens.get(0)));
                List versions = tokens.subList(1, tokens.size());
                result2.computeIfAbsent(pluginId, k -> new HashSet()).addAll(versions);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
        }
        ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result2);
        Map<PluginId, Set<String>> map4 = result2;
        if (map4 == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        return map4;
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file2, boolean append) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = append ? Files.newBufferedWriter(file2, StandardOpenOption.APPEND, StandardOpenOption.CREATE) : Files.newBufferedWriter(file2, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer);
        }
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (PluginId id2 : sortedIds) {
            writer.write(id2.getIdString());
            writer.write(separator);
        }
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId((String)id2));
    }

    public static boolean disablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return DisabledPluginsState.disablePlugin(id2);
    }

    public static boolean enablePlugin(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return DisabledPluginsState.enablePlugin(id2);
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId((String)id2));
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginException createPluginException(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        ClassLoader classLoader;
        if (errorMessage == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        if (pluginClass == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        PluginId pluginId = (classLoader = pluginClass.getClassLoader()) instanceof PluginClassLoader ? ((PluginClassLoader)((Object)classLoader)).getPluginId() : PluginManagerCore.getPluginByClassName(pluginClass.getName());
        return new PluginException(errorMessage, cause, pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginId id2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return (id2 = PluginManagerCore.getPluginOrPlatformByClassName(className)) == null || CORE_ID == id2 ? null : id2;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result2;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        return (result2 = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result2.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull String className) {
        List<IdeaPluginDescriptorImpl> loadedPlugins;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if ((loadedPlugins = ourLoadedPlugins) == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.")) {
            return null;
        }
        IdeaPluginDescriptorImpl result2 = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (classLoader == null || !PluginManagerCore.hasLoadedClass(className, classLoader)) continue;
            result2 = o;
            break;
        }
        if (result2 == null) {
            return null;
        }
        if (result2.getPluginId() != CORE_ID || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result2;
        }
        String root = PathManager.getResourceRoot((ClassLoader)result2.getPluginClassLoader(), (String)("/" + className.replace('.', '/') + ".class"));
        if (root == null) {
            return null;
        }
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            Path path;
            if (!o.isUseIdeaClassLoader() || !root.startsWith(FileUtilRt.toSystemIndependentName((String)(path = o.getPluginPath()).toString()))) continue;
            result2 = o;
            break;
        }
        return result2;
    }

    private static boolean hasLoadedClass(@NotNull String className, @NotNull ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        Class<?> aClass = loader.getClass();
        if (PluginManagerCore.isInstanceofUrlClassLoader(aClass)) {
            try {
                return (Boolean)aClass.getMethod("hasLoadedClass", String.class).invoke((Object)loader, className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isInstanceofUrlClassLoader(Class<?> aClass) {
        String urlClassLoaderName = UrlClassLoader.class.getName();
        while (aClass != null) {
            if (aClass.getName().equals(urlClassLoaderName)) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl getImplicitDependency(@NotNull IdeaPluginDescriptorImpl descriptor2, @Nullable IdeaPluginDescriptorImpl javaDep, boolean hasAllModules) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (descriptor2.getPluginId() == CORE_ID || descriptor2.getPluginId() == JAVA_PLUGIN_ID || VENDOR_JETBRAINS.equals(descriptor2.getVendor()) || !hasAllModules || javaDep == null) {
            return null;
        }
        return PluginManagerCore.hasModuleDependencies(descriptor2) ? null : javaDep;
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptorImpl descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (descriptor2.pluginDependencies == null) {
            return false;
        }
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            PluginId depId = dependency.id;
            if (depId != JAVA_PLUGIN_ID && depId != JAVA_MODULE_ID && !PluginManagerCore.isModuleDependency(depId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ClassLoader createPluginClassLoader(ClassLoader @NotNull [] parentLoaders, @NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull UrlClassLoader.Builder urlLoaderBuilder, @NotNull ClassLoader coreLoader, @NotNull Map<String, String[]> additionalLayoutMap) {
        List<Path> classPath;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        if (urlLoaderBuilder == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (additionalLayoutMap == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if ((classPath = descriptor2.jarFiles) == null) {
            classPath = descriptor2.collectClassPath(additionalLayoutMap);
        } else {
            descriptor2.jarFiles = null;
        }
        if (descriptor2.isUseIdeaClassLoader()) {
            ClassLoader classLoader;
            PluginManagerCore.getLogger().warn(descriptor2.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
            ClassLoader loader = PluginManagerCore.class.getClassLoader();
            try {
                Class<?> loaderClass = loader.getClass();
                if (loaderClass.getName().endsWith(".BootstrapClassLoaderUtil$TransformingLoader")) {
                    loaderClass = loaderClass.getSuperclass();
                }
                MethodHandle addURL = MethodHandles.lookup().findVirtual(loaderClass, "addURL", MethodType.methodType(Void.TYPE, URL.class));
                for (Path pathElement : classPath) {
                    addURL.invoke(loader, PluginManagerCore.localFileToUrl(pathElement, descriptor2));
                }
                classLoader = loader;
            }
            catch (Throwable t) {
                throw new IllegalStateException("An unexpected core classloader: " + loader.getClass(), t);
            }
            if (classLoader == null) {
                PluginManagerCore.$$$reportNull$$$0(34);
            }
            return classLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (Path pathElement : classPath) {
            urls.add(PluginManagerCore.localFileToUrl(pathElement, descriptor2));
        }
        PluginClassLoader loader = new PluginClassLoader(urlLoaderBuilder.urls(urls), parentLoaders, (PluginDescriptor)descriptor2, descriptor2.getPluginPath());
        if (usePluginClassLoader) {
            loader.setCoreLoader(coreLoader);
        }
        PluginClassLoader pluginClassLoader = loader;
        if (pluginClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        return pluginClassLoader;
    }

    @NotNull
    private static URL localFileToUrl(@NotNull Path file2, @NotNull IdeaPluginDescriptor descriptor2) {
        URL uRL;
        if (file2 == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        try {
            uRL = file2.normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginException("Corrupted path element: `" + file2 + '`', (Throwable)e, descriptor2.getPluginId());
        }
        if (uRL == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        return uRL;
    }

    public static synchronized void invalidatePlugins() {
        ourPlugins = null;
        ourLoadedPlugins = null;
        DisabledPluginsState.invalidate();
        ourShadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] plugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        for (IdeaPluginDescriptorImpl descriptor2 : plugins) {
            StringBuilder target2 = !descriptor2.isEnabled() ? disabled : (descriptor2.isBundled() || descriptor2.getPluginId() == SPECIAL_IDEA_PLUGIN_ID ? bundled : custom);
            if (target2.length() > 0) {
                target2.append(", ");
            }
            target2.append(descriptor2.getName());
            String version2 = descriptor2.getVersion();
            if (version2 == null) continue;
            target2.append(" (").append(version2).append(')');
        }
        Logger logger = PluginManagerCore.getLogger();
        logger.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger.info("Disabled plugins: " + disabled);
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result2 = isRunningFromSources;
        if (result2 == null) {
            isRunningFromSources = result2 = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result2;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<PluginError> errors, @NotNull List<String> actions) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        if (actions == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        ourLoadingErrors = errors;
        ArrayList<PluginError> errorsToReport = new ArrayList<PluginError>();
        for (PluginError error : errors) {
            if (!error.isNotifyUser()) continue;
            errorsToReport.add(error);
        }
        String message = "Problems found loading plugins:\n  " + errors.stream().map(PluginError::toString).collect(Collectors.joining("\n  "));
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isHeadlessEnvironment() || isUnitTestMode) {
            if (!errorsToReport.isEmpty()) {
                String errorMessage = Stream.concat(errorsToReport.stream().map(o -> StringUtil.escapeXmlEntities((String)o.toUserError()) + "."), actions.stream()).collect(Collectors.joining("<p/>"));
                ourPluginError = ourPluginError == null ? errorMessage : ourPluginError + "<p/>\n" + errorMessage;
            }
            if (!errors.isEmpty()) {
                PluginManagerCore.getLogger().warn(message);
            }
        } else if (!errors.isEmpty()) {
            PluginManagerCore.getLogger().error(message);
        }
    }

    @Nullable
    public static String getLoadingError(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        if ((error = PluginManagerCore.findErrorForPlugin(ourLoadingErrors, pluginDescriptor.getPluginId())) != null) {
            String reason = error.getIncompatibleReason();
            if (reason != null) {
                return "Incompatible (" + reason + ")";
            }
            return error.getMessage();
        }
        return null;
    }

    @Nullable
    public static PluginId getFirstDisabledDependency(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if ((error = PluginManagerCore.findErrorForPlugin(ourLoadingErrors, pluginDescriptor.getPluginId())) != null) {
            return error.getDisabledDependency();
        }
        return null;
    }

    @Nullable
    private static PluginError findErrorForPlugin(@Nullable List<PluginError> errors, @NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (errors == null) {
            return null;
        }
        for (PluginError error : errors) {
            if (error.plugin == null || !error.plugin.getPluginId().equals(pluginId)) continue;
            return error;
        }
        return null;
    }

    @NotNull
    private static CachingSemiGraph<IdeaPluginDescriptorImpl> createPluginIdGraph(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Function<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, boolean withOptional, boolean hasAllModules) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        IdeaPluginDescriptorImpl javaDep = idToDescriptorMap.apply(JAVA_MODULE_ID);
        HashSet uniqueCheck = new HashSet();
        return new CachingSemiGraph<IdeaPluginDescriptorImpl>(descriptors, rootDescriptor -> {
            IdeaPluginDescriptorImpl dep;
            List<PluginDependency> dependencies = rootDescriptor.pluginDependencies;
            List incompatibleModuleIds = ContainerUtil.notNullize(rootDescriptor.incompatibilities);
            if (dependencies == null) {
                dependencies = Collections.emptyList();
            }
            IdeaPluginDescriptorImpl implicitDep = PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep, hasAllModules);
            int capacity = dependencies.size() + incompatibleModuleIds.size();
            if (!withOptional) {
                for (PluginDependency dependency : dependencies) {
                    if (!dependency.isOptional) continue;
                    --capacity;
                }
            }
            if (capacity == 0) {
                return implicitDep == null ? Collections.emptyList() : Collections.singletonList(implicitDep);
            }
            uniqueCheck.clear();
            ArrayList<IdeaPluginDescriptorImpl> plugins = new ArrayList<IdeaPluginDescriptorImpl>(capacity + (implicitDep == null ? 0 : 1));
            if (implicitDep != null) {
                if (rootDescriptor == implicitDep) {
                    PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                } else {
                    uniqueCheck.add(implicitDep);
                    plugins.add(implicitDep);
                }
            }
            for (PluginDependency dependency : dependencies) {
                if (!withOptional && dependency.isOptional || (dep = (IdeaPluginDescriptorImpl)idToDescriptorMap.apply(dependency.id)) == null) continue;
                if (rootDescriptor == dep) {
                    if (rootDescriptor.getPluginId() == CORE_ID) continue;
                    PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                    continue;
                }
                if (!uniqueCheck.add(dep)) continue;
                plugins.add(dep);
            }
            for (PluginId moduleId : incompatibleModuleIds) {
                dep = (IdeaPluginDescriptorImpl)idToDescriptorMap.apply(moduleId);
                if (dep == null || !uniqueCheck.add(dep)) continue;
                plugins.add(dep);
            }
            return plugins;
        });
    }

    private static void checkPluginCycles(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull List<PluginError> errors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(descriptors, idToDescriptorMap::get, true, idToDescriptorMap.containsKey(ALL_MODULES_MARKER));
        DFSTBuilder builder2 = new DFSTBuilder(GraphGenerator.generate(graph2));
        if (builder2.isAcyclic()) {
            return;
        }
        StringBuilder cyclePresentation = new StringBuilder();
        for (Collection component2 : builder2.getComponents()) {
            if (component2.size() < 2) continue;
            if (cyclePresentation.length() > 0) {
                cyclePresentation.append(", ");
            }
            String separator = " <-> ";
            for (IdeaPluginDescriptor descriptor2 : component2) {
                descriptor2.setEnabled(false);
                cyclePresentation.append(descriptor2.getPluginId());
                cyclePresentation.append(separator);
            }
            cyclePresentation.setLength(cyclePresentation.length() - separator.length());
        }
        if (cyclePresentation.length() > 0) {
            errors.add(new PluginError(null, "Plugins should not have cyclic dependencies: " + cyclePresentation, null));
        }
    }

    @Nullable
    static PathBasedJdomXIncluder.PathResolver<Path> createPluginJarsPathResolver(@NotNull Path pluginDir, @NotNull DescriptorLoadingContext context) {
        ArrayList<Path> dirs;
        ArrayList<Path> pluginJarFiles;
        if (pluginDir == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if (!PluginDescriptorLoader.collectPluginDirectoryContents(pluginDir, pluginJarFiles = new ArrayList<Path>(), dirs = new ArrayList<Path>())) {
            return null;
        }
        return new PluginXmlPathResolver(pluginJarFiles, context);
    }

    public static void getDescriptorsToMigrate(@NotNull Path dir, @Nullable BuildNumber compatibleBuildNumber, @Nullable Path bundledPluginsPath, @Nullable Map<PluginId, Set<String>> brokenPluginVersions, List<IdeaPluginDescriptorImpl> pluginsToMigrate, List<IdeaPluginDescriptorImpl> incompatiblePlugins) throws ExecutionException, InterruptedException {
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        PluginLoadingResult loadingResult = new PluginLoadingResult(brokenPluginVersions != null ? brokenPluginVersions : PluginManagerCore.getBrokenPluginVersions(), () -> compatibleBuildNumber == null ? PluginManagerCore.getBuildNumber() : compatibleBuildNumber);
        int flags = 6;
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(flags, Collections.emptySet(), loadingResult, bundledPluginsPath);
        PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context, dir);
        for (IdeaPluginDescriptorImpl descriptor2 : loadingResult.idMap.values()) {
            if (descriptor2.isBundled()) continue;
            if (loadingResult.isBroken(descriptor2.getPluginId())) {
                incompatiblePlugins.add(descriptor2);
                continue;
            }
            pluginsToMigrate.add(descriptor2);
        }
        for (IdeaPluginDescriptorImpl descriptor2 : loadingResult.incompletePlugins.values()) {
            if (descriptor2.isBundled()) continue;
            incompatiblePlugins.add(descriptor2);
        }
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull Map<PluginId, String> disabledIds, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull List<PluginError> errors) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        ArrayList<String> actions = new ArrayList<String>();
        if (!disabledIds.isEmpty()) {
            String text = "<br><a href=\"disable\">Disable ";
            if (disabledIds.size() == 1) {
                PluginId id2 = disabledIds.keySet().iterator().next();
                text = text + (idMap.containsKey(id2) ? PluginManagerCore.toPresentableName(idMap.get(id2)) : PluginManagerCore.toPresentableName(id2.getIdString()));
            } else {
                text = text + "not loaded plugins";
            }
            actions.add(text + "</a>");
            if (!disabledRequiredIds.isEmpty()) {
                String name = disabledRequiredIds.size() == 1 ? PluginManagerCore.toPresentableName(idMap.get(disabledRequiredIds.iterator().next())) : "all necessary plugins";
                actions.add("<a href=\"enable\">Enable " + name + "</a>");
            }
            actions.add("<a href=\"edit\">Open plugin manager</a>");
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors, actions);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) throws ExecutionException, InterruptedException {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader, urlsFromClassPath);
        BuildNumber buildNumber = BuildNumber.fromString((String)"2042.42");
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(0, Collections.emptySet(), new PluginLoadingResult(Collections.emptyMap(), () -> buildNumber, false));
        try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(loader));){
            PluginDescriptorLoader.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, null);
        }
        context.result.finishLoading();
        List<IdeaPluginDescriptorImpl> list2 = context.result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        return list2;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<DescriptorListLoadingContext> getOrScheduleLoading() {
        CompletableFuture<DescriptorListLoadingContext> future2 = descriptorListFuture;
        if (future2 != null) {
            CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(59);
            }
            return completableFuture;
        }
        descriptorListFuture = future2 = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity((String)"plugin descriptor loading");
            DescriptorListLoadingContext context = PluginDescriptorLoader.loadDescriptors();
            activity.end();
            return context;
        }, AppExecutorUtil.getAppExecutorService());
        CompletableFuture<DescriptorListLoadingContext> completableFuture = future2;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getEnabledPluginRawList() {
        List<IdeaPluginDescriptorImpl> list2 = PluginManagerCore.getOrScheduleLoading().join().result.getEnabledPlugins();
        if (list2 == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        return list2;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionStage<List<IdeaPluginDescriptorImpl>> initPlugins(@NotNull ClassLoader coreClassLoader) {
        CompletableFuture<DescriptorListLoadingContext> future2;
        if (coreClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if ((future2 = descriptorListFuture) == null) {
            future2 = CompletableFuture.completedFuture(null);
        }
        CompletionStage completionStage = future2.thenApply(context -> {
            PluginManagerCore.loadAndInitializePlugins(context, coreClassLoader);
            return ourLoadedPlugins;
        });
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        return completionStage;
    }

    @NotNull
    static PluginLoadingResult createLoadingResult(@Nullable BuildNumber buildNumber) {
        return new PluginLoadingResult(PluginManagerCore.getBrokenPluginVersions(), () -> buildNumber == null ? PluginManagerCore.getBuildNumber() : buildNumber);
    }

    private static void mergeOptionalConfigs(@NotNull List<IdeaPluginDescriptorImpl> enabledPlugins, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (enabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            for (IdeaPluginDescriptorImpl descriptor2 : enabledPlugins) {
                if (!descriptor2.isUseCoreClassLoader() || descriptor2.pluginDependencies == null) continue;
                for (PluginDependency dependency : descriptor2.pluginDependencies) {
                    IdeaPluginDescriptorImpl dependent;
                    if (dependency.subDescriptor == null || (dependent = idMap.get(dependency.id)) == null || dependent.isUseCoreClassLoader()) continue;
                    dependency.subDescriptor = null;
                }
            }
        }
        for (IdeaPluginDescriptorImpl mainDescriptor : enabledPlugins) {
            List<PluginDependency> pluginDependencies = mainDescriptor.pluginDependencies;
            if (pluginDependencies == null) continue;
            PluginManagerCore.mergeOptionalDescriptors(mainDescriptor, pluginDependencies, idMap);
        }
    }

    private static void mergeOptionalDescriptors(@NotNull IdeaPluginDescriptorImpl mergedDescriptor, @NotNull List<PluginDependency> pluginDependencies, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (mergedDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if (pluginDependencies == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        block0: for (PluginDependency dependency : pluginDependencies) {
            IdeaPluginDescriptorImpl dependencyDescriptor;
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            dependency.subDescriptor = null;
            if (subDescriptor == null || dependency.isDisabledOrBroken || (dependencyDescriptor = idMap.get(dependency.id)) == null || !dependencyDescriptor.isEnabled()) continue;
            if (subDescriptor.pluginDependencies != null) {
                for (PluginDependency pluginDependency : subDescriptor.pluginDependencies) {
                    IdeaPluginDescriptorImpl dependentDescriptor;
                    if (pluginDependency.isOptional || !pluginDependency.isDisabledOrBroken && (dependentDescriptor = idMap.get(pluginDependency.id)) != null && dependentDescriptor.isEnabled()) continue;
                    continue block0;
                }
            }
            mergedDescriptor.mergeOptionalConfig(subDescriptor);
            List<PluginDependency> childDependencies = subDescriptor.pluginDependencies;
            if (childDependencies == null) continue;
            PluginManagerCore.mergeOptionalDescriptors(mergedDescriptor, childDependencies, idMap);
        }
    }

    @NotNull
    private static Map<String, String[]> loadAdditionalLayoutMap() {
        Path fileWithLayout;
        Path path = fileWithLayout = usePluginClassLoader ? Paths.get(PathManager.getSystemPath(), PlatformUtils.getPlatformPrefix() + ".txt") : null;
        if (fileWithLayout == null || !Files.exists(fileWithLayout, new LinkOption[0])) {
            Map<String, String[]> map2 = Collections.emptyMap();
            if (map2 == null) {
                PluginManagerCore.$$$reportNull$$$0(69);
            }
            return map2;
        }
        LinkedHashMap<String, String[]> additionalLayoutMap = new LinkedHashMap<String, String[]>();
        try (BufferedReader bufferedReader = Files.newBufferedReader(fileWithLayout);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                List parameters2 = ParametersListUtil.parse((String)line.trim());
                if (parameters2.size() < 2) continue;
                additionalLayoutMap.put((String)parameters2.get(0), ArrayUtilRt.toStringArray(parameters2.subList(1, parameters2.size())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashMap<String, String[]> linkedHashMap = additionalLayoutMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        return linkedHashMap;
    }

    @ApiStatus.Internal
    public static void initClassLoader(@NotNull IdeaPluginDescriptorImpl rootDescriptor) {
        ClassLoader[] classLoaderArray;
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.buildPluginIdMap(ContainerUtil.concat(PluginManagerCore.getLoadedPlugins(null), Collections.singletonList(rootDescriptor)));
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        PluginManagerCore.processAllDependencies(rootDescriptor, true, idMap, (IdeaPluginDescriptor descriptor2) -> {
            ClassLoader loader = descriptor2.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error(rootDescriptor.formatErrorMessage("requires missing class loader for " + PluginManagerCore.toPresentableName(descriptor2)));
            } else {
                loaders.add(loader);
            }
            return FileVisitResult.SKIP_SUBTREE;
        });
        IdeaPluginDescriptorImpl javaDep = idMap.get(JAVA_MODULE_ID);
        boolean hasAllModules = idMap.containsKey(ALL_MODULES_MARKER);
        IdeaPluginDescriptorImpl implicitDependency = PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep, hasAllModules);
        if (implicitDependency != null && implicitDependency.getPluginClassLoader() != null) {
            loaders.add(implicitDependency.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = PluginManagerCore.class.getClassLoader();
        } else {
            classLoaderArray = loaders.toArray(new ClassLoader[0]);
        }
        ClassLoader[] array2 = classLoaderArray;
        rootDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(array2, rootDescriptor, PluginManagerCore.createUrlClassLoaderBuilder(), PluginManagerCore.class.getClassLoader(), ourAdditionalLayoutMap));
    }

    @NotNull
    private static UrlClassLoader.Builder createUrlClassLoaderBuilder() {
        UrlClassLoader.Builder builder2 = UrlClassLoader.build().allowLock().useCache().urlsInterned();
        if (builder2 == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        return builder2;
    }

    @NotNull
    static BuildNumber getBuildNumber() {
        BuildNumber result2 = ourBuildNumber;
        if (result2 == null) {
            result2 = BuildNumber.fromString((String)PluginManagerCore.getPluginsCompatibleBuild());
            if (result2 == null) {
                if (isUnitTestMode) {
                    result2 = BuildNumber.currentVersion();
                } else {
                    try {
                        result2 = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result2 = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result2;
        }
        BuildNumber buildNumber = result2;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull List<PluginError> errors) {
        boolean isNonBundledPluginDisabled;
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (isNonBundledPluginDisabled = ourDisableNonBundledPlugins) {
            PluginManagerCore.getLogger().info("Running with disableThirdPartyPlugins argument, third-party plugins will be disabled");
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set = new HashSet();
            List strings = StringUtil.split((String)selectedIds, (String)",");
            for (String it : strings) {
                set.add(PluginId.getId((String)it));
            }
            set.addAll(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set.size());
            Iterator<Object> iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                PluginId id3 = (PluginId)iterator2.next();
                IdeaPluginDescriptorImpl descriptor2 = idMap.get(id3);
                if (descriptor2 == null) continue;
                explicitlyEnabled.add(descriptor2);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl descriptor3 : descriptors) {
                if (!selectedCategory.equals(descriptor3.getCategory())) continue;
                explicitlyEnabled.add(descriptor3);
            }
        }
        if (explicitlyEnabled != null) {
            LinkedHashSet<IdeaPluginDescriptorImpl> finalExplicitlyEnabled = explicitlyEnabled;
            HashSet<IdeaPluginDescriptor> depProcessed = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptorImpl descriptor4 : new ArrayList(explicitlyEnabled)) {
                PluginManagerCore.processAllDependencies(descriptor4, false, idMap, depProcessed, (id2, dependency) -> {
                    finalExplicitlyEnabled.add((IdeaPluginDescriptorImpl)dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
        }
        Map<PluginId, Set<String>> brokenPluginVersions = PluginManagerCore.getBrokenPluginVersions();
        boolean shouldLoadPlugins = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor4 : descriptors) {
            if (descriptor4 == coreDescriptor) continue;
            Set<String> set = brokenPluginVersions.get(descriptor4.getPluginId());
            if (set != null && set.contains(descriptor4.getVersion())) {
                descriptor4.setEnabled(false);
                errors.add(new PluginError(descriptor4, "was marked as broken", "marked as broken"));
                continue;
            }
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor4)) continue;
                descriptor4.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin " + PluginManagerCore.toPresentableName(descriptor4) + " " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (!shouldLoadPlugins) {
                descriptor4.setEnabled(false);
                errors.add(new PluginError(descriptor4, "is skipped (plugins loading disabled)", null));
                continue;
            }
            if (!isNonBundledPluginDisabled || descriptor4.isBundled()) continue;
            descriptor4.setEnabled(false);
            errors.add(new PluginError(descriptor4, "is skipped (third-party plugins loading disabled)", null, false));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        return !PluginManagerCore.isIncompatible(descriptor2);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        return !PluginManagerCore.isIncompatible(descriptor2, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        return PluginManagerCore.isIncompatible(descriptor2, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor2, @Nullable BuildNumber buildNumber) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.getIncompatibleMessage(buildNumber, descriptor2.getSinceBuild(), descriptor2.getUntilBuild()) != null;
    }

    @Nullable
    static String getIncompatibleMessage(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild) {
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            String message = null;
            BuildNumber buildNumber2 = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString((String)sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
                message = "since build " + sinceBuildNumber + " > " + buildNumber;
            }
            BuildNumber buildNumber3 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString((String)untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
                message = message == null ? "" : message + ", ";
                message = message + "until build " + untilBuildNumber + " < " + buildNumber;
            }
            return message;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            return "version check failed";
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        List<PluginId> required = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id2 : required) {
            IdeaPluginDescriptorImpl descriptor2 = idMap.get(id2);
            if (descriptor2 != null && descriptor2.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id2.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins) {
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        PluginLoadingResult loadingResult = context.result;
        ArrayList<PluginError> errors = new ArrayList<PluginError>(loadingResult.getErrors());
        if (loadingResult.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : loadingResult.duplicateModuleMap.entrySet()) {
                errors.add(new PluginError(null, "Module " + entry.getKey() + " is declared by plugins:\n  " + StringUtil.join((Iterable)entry.getValue(), (String)"\n  "), null));
            }
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult.idMap;
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        if (checkEssentialPlugins && coreDescriptor == null) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        List<IdeaPluginDescriptorImpl> descriptors = loadingResult.getEnabledPlugins();
        PluginManagerCore.disableIncompatiblePlugins(descriptors, idMap, errors);
        PluginManagerCore.checkPluginCycles(descriptors, idMap, errors);
        IdeaPluginDescriptorImpl[] sortedRequired = PluginManagerCore.getTopologicallySorted(PluginManagerCore.createPluginIdGraph(descriptors, idMap::get, false, idMap.containsKey(ALL_MODULES_MARKER)));
        LinkedHashSet<PluginId> enabledPluginIds = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> enabledModuleIds = new LinkedHashSet<PluginId>();
        LinkedHashMap<PluginId, String> disabledIds = new LinkedHashMap<PluginId, String>();
        LinkedHashSet<PluginId> disabledRequiredIds = new LinkedHashSet<PluginId>();
        for (IdeaPluginDescriptorImpl descriptor2 : sortedRequired) {
            boolean wasEnabled = descriptor2.isEnabled();
            if (wasEnabled && PluginManagerCore.computePluginEnabled(descriptor2, enabledPluginIds, enabledModuleIds, idMap, disabledRequiredIds, context.disabledPlugins, errors)) {
                enabledPluginIds.add(descriptor2.getPluginId());
                enabledModuleIds.addAll(descriptor2.getModules());
                continue;
            }
            descriptor2.setEnabled(false);
            if (!wasEnabled) continue;
            disabledIds.put(descriptor2.getPluginId(), descriptor2.getName());
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(disabledIds, disabledRequiredIds, idMap, errors);
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(Arrays.asList(sortedRequired), idMap::get, true, idMap.containsKey(ALL_MODULES_MARKER));
        IdeaPluginDescriptorImpl[] sortedAll = PluginManagerCore.getTopologicallySorted(graph2);
        List<IdeaPluginDescriptorImpl> enabledPlugins = PluginManagerCore.getOnlyEnabledPlugins(sortedAll);
        PluginManagerCore.mergeOptionalConfigs(enabledPlugins, idMap);
        Map<String, String[]> additionalLayoutMap = PluginManagerCore.loadAdditionalLayoutMap();
        ourAdditionalLayoutMap = additionalLayoutMap;
        PluginManagerCore.configureClassLoaders(coreLoader, graph2, coreDescriptor, enabledPlugins, additionalLayoutMap, context.usePluginClassLoader);
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        HashSet<PluginId> effectiveDisabledIds = disabledIds.isEmpty() ? Collections.emptySet() : new HashSet<PluginId>(disabledIds.keySet());
        return new PluginManagerState(sortedAll, enabledPlugins, disabledRequiredIds, effectiveDisabledIds, idMap);
    }

    private static void configureClassLoaders(@NotNull ClassLoader coreLoader, @NotNull CachingSemiGraph<IdeaPluginDescriptorImpl> graph2, @Nullable IdeaPluginDescriptor coreDescriptor, @NotNull List<IdeaPluginDescriptorImpl> enabledPlugins, @NotNull Map<String, String[]> additionalLayoutMap, boolean usePluginClassLoader) {
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (enabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (additionalLayoutMap == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader[] emptyClassLoaderArray = new ClassLoader[]{};
        UrlClassLoader.Builder urlClassLoaderBuilder = PluginManagerCore.createUrlClassLoaderBuilder();
        for (IdeaPluginDescriptorImpl rootDescriptor : enabledPlugins) {
            ClassLoader[] classLoaderArray;
            if (rootDescriptor == coreDescriptor || rootDescriptor.isUseCoreClassLoader()) {
                rootDescriptor.setLoader(coreLoader);
                continue;
            }
            if (!usePluginClassLoader) {
                rootDescriptor.setLoader(null);
                continue;
            }
            loaders.clear();
            List<IdeaPluginDescriptorImpl> dependencies = graph2.getInList(rootDescriptor);
            if (!dependencies.isEmpty()) {
                loaders.ensureCapacity(dependencies.size());
                for (IdeaPluginDescriptorImpl descriptor2 : dependencies) {
                    ClassLoader loader = descriptor2.getPluginClassLoader();
                    if (loader == null) {
                        PluginManagerCore.getLogger().error(rootDescriptor.formatErrorMessage("requires missing class loader for " + PluginManagerCore.toPresentableName(descriptor2)));
                        continue;
                    }
                    loaders.add(loader);
                }
            }
            if (loaders.isEmpty()) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[0] = coreLoader;
            } else {
                classLoaderArray = loaders.toArray(emptyClassLoaderArray);
            }
            ClassLoader[] parentLoaders = classLoaderArray;
            rootDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(parentLoaders, rootDescriptor, urlClassLoaderBuilder, coreLoader, additionalLayoutMap));
        }
    }

    @NotNull
    private static @NotNull IdeaPluginDescriptorImpl @NotNull [] getTopologicallySorted(@NotNull InboundSemiGraph<IdeaPluginDescriptorImpl> graph2) {
        if (graph2 == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        DFSTBuilder requiredOnlyGraph = new DFSTBuilder(GraphGenerator.generate(graph2));
        IdeaPluginDescriptorImpl[] sortedRequired = graph2.getNodes().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        Comparator comparator2 = requiredOnlyGraph.comparator();
        Arrays.sort(sortedRequired, (o1, o2) -> {
            if (o1.getPluginId() == CORE_ID) {
                return -1;
            }
            if (o2.getPluginId() == CORE_ID) {
                return 1;
            }
            return comparator2.compare(o1, o2);
        });
        if (sortedRequired == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        return sortedRequired;
    }

    public static List<IdeaPluginDescriptorImpl> getPluginsSortedByDependency(List<IdeaPluginDescriptorImpl> plugins, boolean withOptional) {
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph2 = PluginManagerCore.createPluginIdGraph(plugins, id2 -> (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(id2), withOptional, PluginManagerCore.findPluginByModuleDependency(ALL_MODULES_MARKER) != null);
        IdeaPluginDescriptorImpl[] sortedRequired = PluginManagerCore.getTopologicallySorted(graph2);
        return Arrays.asList(sortedRequired);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap(@NotNull List<IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new LinkedHashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor2 : descriptors) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, descriptor2.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor2.getModules()) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor2, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> linkedHashMap = idMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull PluginId id2, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id2)) != null) {
            duplicates.add(descriptor2);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id2, descriptor2);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id2);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list2 = new ArrayList<IdeaPluginDescriptorImpl>();
        list2.add(existingDescriptor);
        list2.add(descriptor2);
        duplicateMap.put(id2, list2);
        return duplicateMap;
    }

    private static boolean computePluginEnabled(@NotNull IdeaPluginDescriptorImpl descriptor2, @NotNull Set<PluginId> loadedPluginIds, @NotNull Set<PluginId> loadedModuleIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Set<PluginId> disabledPlugins, @NotNull List<PluginError> errors) {
        if (descriptor2 == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (loadedPluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        if (loadedModuleIds == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        if (descriptor2.getPluginId() == CORE_ID) {
            return true;
        }
        boolean notifyUser = !descriptor2.isImplementationDetail();
        boolean result2 = true;
        for (PluginId incompatibleId : ContainerUtil.notNullize(descriptor2.incompatibilities)) {
            if (!loadedModuleIds.contains(incompatibleId) || disabledPlugins.contains(incompatibleId)) continue;
            result2 = false;
            String presentableName = PluginManagerCore.toPresentableName(incompatibleId.getIdString());
            errors.add(new PluginError(descriptor2, "is incompatible with the IDE containing module " + presentableName, "IDE contains module " + presentableName, notifyUser));
        }
        if (descriptor2.pluginDependencies == null) {
            return result2;
        }
        for (PluginDependency dependency : descriptor2.pluginDependencies) {
            String depName;
            PluginId depId = dependency.id;
            if (dependency.isOptional || loadedPluginIds.contains(depId) || loadedModuleIds.contains(depId)) continue;
            result2 = false;
            IdeaPluginDescriptor dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequiredIds.add(dep.getPluginId());
            }
            String string = depName = dep == null ? null : dep.getName();
            if (depName == null) {
                if (PluginManagerCore.findErrorForPlugin(errors, depId) != null) {
                    errors.add(new PluginError(descriptor2, "depends on plugin " + PluginManagerCore.toPresentableName(depId.getIdString()) + " that failed to load", null, notifyUser));
                    continue;
                }
                errors.add(new PluginError(descriptor2, "requires " + PluginManagerCore.toPresentableName(depId.getIdString()) + " plugin to be installed", null, notifyUser));
                continue;
            }
            PluginError error = new PluginError(descriptor2, "requires " + PluginManagerCore.toPresentableName(depName) + " plugin to be enabled", null, notifyUser);
            error.setDisabledDependency(dep.getPluginId());
            errors.add(error);
        }
        return result2;
    }

    private static String toPresentableName(@Nullable IdeaPluginDescriptor descriptor2) {
        return PluginManagerCore.toPresentableName(descriptor2 == null ? null : descriptor2.getName());
    }

    @NotNull
    private static String toPresentableName(@Nullable String s) {
        String string = "\"" + (s == null ? "" : s) + "\"";
        if (string == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        return string;
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor2;
        if (pluginRoot == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(DisabledPluginsState.disabledPlugins());
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, true, true, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            descriptor2 = Files.isDirectory(pluginRoot, new LinkOption[0]) ? PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot, META_INF + fileName, null, context) : PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot, fileName, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, context, null);
        }
        if (descriptor2 == null) {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
            return;
        }
        List<ExtensionPointImpl<?>> extensionPoints = descriptor2.appContainerDescriptor.extensionPoints;
        if (extensionPoints != null) {
            ((ExtensionsAreaImpl)area).registerExtensionPoints(extensionPoints, false);
        }
        descriptor2.registerExtensions((ExtensionsAreaImpl)area, descriptor2, descriptor2.appContainerDescriptor, null);
    }

    private static synchronized void loadAndInitializePlugins(@Nullable DescriptorListLoadingContext context, @Nullable ClassLoader coreLoader) {
        if (coreLoader == null) {
            Class callerClass = ReflectionUtil.findCallerClass((int)1);
            assert (callerClass != null);
            coreLoader = callerClass.getClassLoader();
        }
        try {
            if (context == null) {
                context = PluginDescriptorLoader.loadDescriptors();
            }
            Activity activity = StartUpMeasurer.startActivity((String)"plugin initialization");
            PluginManagerState initResult = PluginManagerCore.initializePlugins(context, coreLoader, !isUnitTestMode);
            ourPlugins = initResult.sortedPlugins;
            PluginLoadingResult result2 = context.result;
            if (!result2.incompletePlugins.isEmpty()) {
                int oldSize = initResult.sortedPlugins.length;
                Object[] all = new IdeaPluginDescriptorImpl[oldSize + result2.incompletePlugins.size()];
                System.arraycopy(initResult.sortedPlugins, 0, all, 0, oldSize);
                ArrayUtil.copy(result2.incompletePlugins.values(), (Object[])all, (int)oldSize);
                ourPlugins = all;
            }
            ourPluginsToDisable = initResult.effectiveDisabledIds;
            ourPluginsToEnable = initResult.disabledRequiredIds;
            ourLoadedPlugins = initResult.sortedEnabledPlugins;
            ourShadowedBundledPlugins = result2.getShadowedBundledIds();
            activity.end();
            activity.setDescription("plugin count: " + ourLoadedPlugins.size());
            PluginManagerCore.logPlugins(initResult.sortedPlugins);
        }
        catch (ExtensionInstantiationException e) {
            throw new PluginException((Throwable)e, e.getExtensionOwnerId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error((Throwable)e);
            throw e;
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger = Logger.getInstance((String)"#com.intellij.ide.plugins.PluginManager");
        if (logger == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        return logger;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id2) {
        if (id2 != null) {
            for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
                if (id2 != plugin.getPluginId()) continue;
                return plugin;
            }
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptor findPluginByModuleDependency(@NotNull PluginId id2) {
        if (id2 == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        for (IdeaPluginDescriptor descriptor2 : PluginManagerCore.getPlugins()) {
            if (!(descriptor2 instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)descriptor2).getModules().contains(id2)) continue;
            return descriptor2;
        }
        return null;
    }

    public static boolean isPluginInstalled(PluginId id2) {
        return PluginManagerCore.getPlugin(id2) != null;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        return PluginManagerCore.buildPluginIdMap(Arrays.asList(ourPlugins));
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, PluginManagerCore.buildPluginIdMap(), consumer);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet<IdeaPluginDescriptor>(), (id2, descriptor2) -> descriptor2 != null ? (FileVisitResult)((Object)((Object)consumer.apply((IdeaPluginDescriptor)descriptor2))) : FileVisitResult.SKIP_SUBTREE);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull @NotNull BiFunction<? super @NotNull PluginId, ? super @Nullable IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet<IdeaPluginDescriptor>(), consumer);
    }

    @ApiStatus.Internal
    private static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Set<IdeaPluginDescriptor> depProcessed, @NotNull BiFunction<? super PluginId, ? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(120);
        }
        if (rootDescriptor.pluginDependencies == null) {
            return true;
        }
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            if (!withOptionalDeps && dependency.isOptional) continue;
            IdeaPluginDescriptorImpl descriptor2 = idToMap.get(dependency.id);
            PluginId pluginId = descriptor2 == null ? dependency.id : descriptor2.getPluginId();
            switch (consumer.apply((PluginId)pluginId, descriptor2)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor2 == null || !depProcessed.add(descriptor2)) break;
                    PluginManagerCore.processAllDependencies(descriptor2, withOptionalDeps, idToMap, depProcessed, consumer);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    public static boolean processAllBackwardDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(122);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> semiGraph = PluginManagerCore.createPluginIdGraph(Arrays.asList(ourPlugins), id2 -> (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(id2), withOptionalDeps, PluginManagerCore.findPluginByModuleDependency(ALL_MODULES_MARKER) != null);
        Graph graph2 = GraphGenerator.generate(semiGraph);
        LinkedHashSet dependencies = new LinkedHashSet();
        GraphAlgorithms.getInstance().collectOutsRecursively(graph2, (Object)rootDescriptor, dependencies);
        for (IdeaPluginDescriptorImpl dependency : dependencies) {
            if (dependency == rootDescriptor || consumer.apply(dependency) != FileVisitResult.TERMINATE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<IdeaPluginDescriptorImpl> getOnlyEnabledPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] sortedAll) {
        if (sortedAll == null) {
            PluginManagerCore.$$$reportNull$$$0(123);
        }
        ArrayList<IdeaPluginDescriptorImpl> enabledPlugins = new ArrayList<IdeaPluginDescriptorImpl>(sortedAll.length);
        for (IdeaPluginDescriptorImpl descriptor2 : sortedAll) {
            if (!descriptor2.isEnabled()) continue;
            enabledPlugins.add(descriptor2);
        }
        ArrayList<IdeaPluginDescriptorImpl> arrayList = enabledPlugins;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(124);
        }
        return arrayList;
    }

    @Deprecated
    public static void addDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(125);
        }
        PluginManager.getInstance().addDisablePluginListener(listener2);
    }

    @Deprecated
    public static void removeDisablePluginListener(@NotNull Runnable listener2) {
        if (listener2 == null) {
            PluginManagerCore.$$$reportNull$$$0(126);
        }
        PluginManager.getInstance().removeDisablePluginListener(listener2);
    }

    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(127);
        }
        return ourShadowedBundledPlugins != null && ourShadowedBundledPlugins.contains(plugin.getPluginId());
    }

    static {
        ourAdditionalLayoutMap = Collections.emptyMap();
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        usePluginClassLoader = Boolean.getBoolean("idea.from.sources.plugins.class.loader");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 94: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 26: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlLoaderBuilder";
                break;
            }
            case 31: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 32: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 40: 
            case 49: 
            case 56: 
            case 76: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 45: 
            case 47: 
            case 74: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 51: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 54: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 55: 
            case 65: 
            case 68: 
            case 75: 
            case 82: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 64: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledPlugins";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDescriptor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDependencies";
                break;
            }
            case 71: 
            case 109: 
            case 111: 
            case 114: 
            case 117: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPluginIds";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedModuleIds";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 110: 
            case 113: 
            case 116: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 112: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedAll";
                break;
            }
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginClassLoader";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "localFileToUrl";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalLayoutMap";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlClassLoaderBuilder";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySorted";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableName";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyEnabledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSetPlugins";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "localFileToUrl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 40: 
            case 41: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findErrorForPlugin";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createPluginJarsPathResolver";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorsToMigrate";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalDescriptors";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleMessage";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "configureClassLoaders";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySorted";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "processAllBackwardDependencies";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyEnabledPlugins";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

